## ---- setup, include=FALSE----------------------------------------------------
knitr::opts_chunk$set(cache = TRUE)

## ----include=TRUE,results="hide",message=FALSE,warning=FALSE------------------
library(cBioPortalData)
library(AnVIL)

## ----message=FALSE,warning=FALSE----------------------------------------------
## Use ask=FALSE for non-interactive use
cBioDataPack("laml_tcga", ask = FALSE)

## ----warning=FALSE------------------------------------------------------------
cbio <- cBioPortal()
acc <- cBioPortalData(api = cbio, by = "hugoGeneSymbol", studyId = "acc_tcga",
    genePanelId = "IMPACT341",
    molecularProfileIds = c("acc_tcga_rppa", "acc_tcga_linear_CNA")
)
acc

## ----eval=FALSE---------------------------------------------------------------
#  removeCache("laml_tcga")

## ----eval=FALSE---------------------------------------------------------------
#  unlink("~/.cache/cBioPortalData/")

## -----------------------------------------------------------------------------
sessionInfo()

