## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo=TRUE)

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
library(bigPint)
library(DelayedArray)
library(SummarizedExperiment)

data(soybean_ir_sub)
data = soybean_ir_sub
data(soybean_ir_sub_metrics)
dataMetrics = soybean_ir_sub_metrics

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
dMUnlist <- dataMetrics
dMUnlist[-1] <- lapply(dMUnlist[-1], transform, ID = NULL)
dMUnlist <- do.call(cbind, dMUnlist)
names(dMUnlist)[1] <- "ID"

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
rownames(data) = data[,1]
data = data[,-1]
data <- DelayedArray(data)
se_soybean_ir_sub <- SummarizedExperiment(assays = data, rowData = dMUnlist)
assay(se_soybean_ir_sub)
rowData(se_soybean_ir_sub)

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
data(soybean_cn_sub)
data = soybean_cn_sub
data(soybean_cn_sub_metrics)
dataMetrics = soybean_cn_sub_metrics

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
dMUnlist <- dataMetrics
dMUnlist[-1] <- lapply(dMUnlist[-1], transform, ID = NULL)
dMUnlist <- do.call(cbind, dMUnlist)
names(dMUnlist)[1] <- "ID"

## ---- eval=TRUE, include=TRUE, message=FALSE----------------------------------
rownames(data) = data[,1]
data = data[,-1]
data <- DelayedArray(data)
se_soybean_cn_sub <- SummarizedExperiment(assays = data, rowData = dMUnlist)
assay(se_soybean_cn_sub)
rowData(se_soybean_cn_sub)

