## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"-----------------------------
BiocStyle::latex()

## ----include=FALSE------------------------------------------------------------------
library(knitr)
opts_chunk$set(
concordance = TRUE,
background = "#f3f3ff"
)

## ----req----------------------------------------------------------------------------
library("VERSO")
data(variants)
head(variants)

## ----example_error_rates------------------------------------------------------------
alpha = c(0.01,0.05)
beta = c(0.01,0.05)
head(alpha)
head(beta)

## ----example_inference--------------------------------------------------------------
set.seed(12345)
inference = VERSO(D = variants, 
                  alpha = alpha, 
                  beta = beta, 
                  check_indistinguishable = TRUE, 
                  num_rs = 5, 
                  num_iter = 100, 
                  n_try_bs = 50, 
                  num_processes = 1, 
                  verbose = TRUE)

## ----example_inference_full---------------------------------------------------------
data(inference)
print(names(inference))

## ----example_plot-------------------------------------------------------------------
plot(inference$phylogenetic_tree)

## ----sessioninfo,results='asis',echo=FALSE------------------------------------------
toLatex(sessionInfo())

