## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## -----------------------------------------------------------------------------
library(TreeAndLeaf)
library(RedeR)
library(RColorBrewer)


## ----echo=TRUE----------------------------------------------------------------
dim(USArrests)
head(USArrests)

## ----echo=TRUE----------------------------------------------------------------
hc <- hclust(dist(USArrests), "ave")
plot(hc)

## -----------------------------------------------------------------------------
gg <- hclust2igraph(hc)

## -----------------------------------------------------------------------------
gg <- formatTree(gg = gg, theme = 5)

## -----------------------------------------------------------------------------
gg <- att.mapv(g = gg, dat = USArrests, refcol = 0)

## -----------------------------------------------------------------------------
pal <- brewer.pal(9, "Reds")
gg <- att.setv(g = gg, from = "Murder", to = "nodeColor",
               cols = pal, nquant = 5)
gg <- att.setv(g = gg, from = "UrbanPop", to = "nodeSize",
               xlim = c(50, 150, 1), nquant = 5)

## ---- eval = FALSE------------------------------------------------------------
#  rdp <- RedPort()
#  calld(rdp)
#  resetd(rdp)

## ---- eval = FALSE------------------------------------------------------------
#  treeAndLeaf(obj = rdp, gg = gg)
#  

## ---- eval = FALSE------------------------------------------------------------
#  addLegend.color(obj = rdp, gg, title = "Murder Rate",
#                  position = "right")
#  addLegend.size(obj = rdp, gg, title = "Urban Population Size",
#                 position = "bottomright")

## -----------------------------------------------------------------------------
library(TreeAndLeaf)
library(RedeR)
library(RColorBrewer)

## ----echo=TRUE----------------------------------------------------------------
dim(quakes)
head(quakes)

## ----echo=TRUE----------------------------------------------------------------
hc <- hclust(dist(quakes))
plot(hc)

## -----------------------------------------------------------------------------
# Converting hclust to igraph format
gg <- hclust2igraph(hc)

# Formatting the tree
gg <- formatTree(gg, theme = 1, cleanalias = TRUE)

# Mapping the data into the igraph object
gg <- att.mapv(gg, quakes, refcol = 0)

# Set attributes
pal <- brewer.pal(9, "Greens")
gg <- att.setv(gg, from = "mag", to = "nodeColor",
               cols = pal, nquant = 10)
gg <- att.setv(gg, from = "depth", to = "nodeSize",
               xlim = c(240, 880, 1), nquant = 5)


## ---- eval = FALSE------------------------------------------------------------
#  rdp <- RedPort()
#  calld(rdp)
#  resetd(rdp)

## ---- eval = FALSE------------------------------------------------------------
#  # Plotting the tree
#  treeAndLeaf(rdp, gg)
#  
#  # Adding legend
#  addLegend.color(obj = rdp, gg, title = "Richter Magnitude")
#  addLegend.size(obj = rdp, gg, title = "Depth (km)")

## -----------------------------------------------------------------------------
library(TreeAndLeaf)
library(RedeR)
library(RColorBrewer)
library(ape) # Analyses of Phylogenetics and Evolution
library(igraph)

## -----------------------------------------------------------------------------
library(geneplast)
data("gpdata.gs")
plot(phyloTree)

## -----------------------------------------------------------------------------
data("spdata")

## -----------------------------------------------------------------------------
# Accessory indexing 
idx <- match(as.numeric(spdata$tax_id), as.numeric(phyloTree$tip.label))
idx <- idx[!is.na(idx)]
tokeep <- phyloTree$tip.label[idx]
phyloTree$tip.label <- as.character(phyloTree$tip.label)

# Remaking the tree
pruned.tree <- drop.tip(phyloTree, phyloTree$tip.label[-match(tokeep,
                                                              phyloTree$tip.label)])

## -----------------------------------------------------------------------------
# Converting phylo to igraph
tal.phylo <- phylo2igraph(pruned.tree)

# Formatting the tree
tal.phylo <- formatTree(tal.phylo, theme = 4)

# Mapping data to the igraph object
tal.phylo <- att.mapv(g = tal.phylo, dat = spdata, refcol = 1)

# Setting attributes
pal <- brewer.pal(9, "Purples")
tal.phylo <- att.setv(g = tal.phylo, from = "genome_size_Mb",
                      to = "nodeSize", xlim = c(120, 250, 1), nquant = 5)
tal.phylo <- att.setv (g = tal.phylo, from = "proteins",
                       to = "nodeColor", nquant = 5,
                       cols = pal, na.col = "black")

## -----------------------------------------------------------------------------
# Changing the alias to show the names and making them invisible
idx <- match(V(tal.phylo)$nodeAlias, spdata$tax_id)
V(tal.phylo)$nodeAlias <- spdata$sp_name[idx]
V(tal.phylo)$nodeAlias[is.na(V(tal.phylo)$nodeAlias)] <- ""
V(tal.phylo)$nodeFontSize <- 1

# Randomly selecting some names to be shown
set.seed(9)
V(tal.phylo)$nodeFontSize[sample(1:length(V(tal.phylo)$nodeFontSize), 50)] <- 100
V(tal.phylo)$nodeFontSize[V(tal.phylo)$name == "9606"] <- 100 #Homo sapiens

## ----eval = FALSE-------------------------------------------------------------
#  # Calling RedeR
#  rdp <- RedPort()
#  calld(rdp)
#  resetd(rdp)
#  
#  # Plotting
#  treeAndLeaf(obj = rdp, gg = tal.phylo)
#  
#  # Adding Legend
#  addLegend.size(rdp, tal.phylo, title = "Genome Size (Mb)")
#  addLegend.color(rdp, tal.phylo, title = "Protein Count")

## -----------------------------------------------------------------------------
# Packages required
library(TreeAndLeaf)
library(RedeR)
library(RColorBrewer)
library(ape)
library(igraph)
library(geneplast)

## -----------------------------------------------------------------------------
# Loading data
data("spdata") # NCBI Genomes scraped info
data("phylo_species") # STRING-db tree metadata
data("phylo_tree") # STRING-db phylo object

# Remaking the tree with species inside spdata
idx <- match(as.numeric(spdata$tax_id), as.numeric(phylo_species$X...taxon_id))
idx <- idx[!is.na(idx)]
tokeep <- phylo_species$X...taxon_id[idx]
pruned.tree <- drop.tip(phylo_tree,phylo_tree$tip.label[-match(tokeep, phylo_tree$tip.label)])

# Converting phylo to igraph
tal.phy <- phylo2igraph(pruned.tree)

# Formatting the tree
tal.phy <- formatTree(gg = tal.phy, theme = 3)

# Mapping data into the igraph object
tal.phy <- att.mapv(g = tal.phy, dat = spdata, refcol = 1)

# Setting attributes
pal <- brewer.pal(9, "Blues")
tal.phy <- att.setv(g = tal.phy, from = "genome_size_Mb",
                    to = "nodeSize", nquant = 5, xlim = c(200, 600, 1))
tal.phy <- att.setv(g = tal.phy, from = "proteins", to = "nodeColor",
                    nquant = 5, cols = pal, na.col = "black")

# Randomly selecting names to be shown
set.seed(9)
V(tal.phy)$nodeFontSize <- 1
V(tal.phy)$nodeFontSize[sample(1:length(V(tal.phy)$nodeFontSize), 80)] <- 300
V(tal.phy)$nodeFontSize[V(tal.phy)$name == 9606] <- 300

idx <- match(V(tal.phy)$nodeAlias, spdata$tax_id)
V(tal.phy)$nodeAlias <- spdata$sp_name[idx]
V(tal.phy)$nodeAlias[is.na(V(tal.phy)$nodeAlias)] <- ""

## ----eval = FALSE-------------------------------------------------------------
#  # Calling RedeR and plotting
#  rdp <- RedPort()
#  calld(rdp)
#  resetd(rdp)
#  
#  # Plotting the tree
#  treeAndLeaf(rdp, tal.phy)
#  
#  # Adding legends
#  addLegend.color(rdp, tal.phy, title = "Protein count")
#  addLegend.size(rdp, tal.phy, title = "Genome size (Mb)")

## ----label='Session information', eval=TRUE, echo=FALSE-----------------------
sessionInfo()

