## ---- eval=FALSE--------------------------------------------------------------
#  if(!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("SpatialExperiment")

## ---- message=FALSE-----------------------------------------------------------
library(SpatialExperiment)

## -----------------------------------------------------------------------------
fishCoordFile <- system.file(file.path("extdata", "seqFISH",
                            "fcortex.coordinates.txt"), 
                            package="SpatialExperiment")
fishCoordinates <- read.table(fishCoordFile, header=FALSE, sep=" ")
colnames(fishCoordinates) <- c("Cell_ID", "Irrelevant", "x", "y")

fishCellLabsFile <- system.file(file.path("extdata", "seqFISH", 
                            "seqfish_cell_labels.tsv"),
                            package="SpatialExperiment")
fishCellLabels <- read.table(file=fishCellLabsFile, header=FALSE, sep="\t")
colnames(fishCellLabels) <- c("Cell_ID", "cluster", "class", "classID", 
                                "Irrelevant", "Prob")
fishFeatCountsFile <- system.file(file.path("extdata", "seqFISH",
                            "seqfish_normalized_cortex_b2_testing.txt"), 
                            package="SpatialExperiment")
fishFeaturesCounts <- read.table(file=fishFeatCountsFile, 
                                header=FALSE, sep="\t", row.names=1)

## -----------------------------------------------------------------------------
se <- SpatialExperiment(rowData=rownames(fishFeaturesCounts),
                        colData=fishCellLabels,
                        assays=SimpleList(counts=as.matrix(fishFeaturesCounts)),
                        spatialCoords=fishCoordinates)
show(se)

## -----------------------------------------------------------------------------
spatialCoords(se)

## -----------------------------------------------------------------------------
fakeFishCoords <- cbind(fishCoordinates[,c(1:3)], fishCoordinates[,3])
colnames(fakeFishCoords) <- c("Cell_ID", "Irrelevant", "x", "y")
spatialCoords(se) <- fakeFishCoords
spatialCoords(se)

## -----------------------------------------------------------------------------
sessionInfo()

