## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----Load, message=FALSE, eval = TRUE-----------------------------------------
library(SQLDataFrame)
library(DBI)

## ----constructor--------------------------------------------------------------
dbfile <- system.file("extdata/test.db", package = "SQLDataFrame")
conn <- DBI::dbConnect(dbDriver("SQLite"), dbname = dbfile)
obj <- SQLDataFrame(
    conn = conn, dbtable = "state", dbkey = "state")
obj

## -----------------------------------------------------------------------------
slotNames(obj)
dbtable(obj)
dbkey(obj)

## -----------------------------------------------------------------------------
tblData(obj)

## -----------------------------------------------------------------------------
dbnrows(obj)
dbconcatKey(obj)

## -----------------------------------------------------------------------------
obj@indexes
obj_sub <- obj[sample(5, 3, replace = TRUE), 2:3]
obj_sub
obj_sub@indexes
identical(tblData(obj), tblData(obj_sub))

## -----------------------------------------------------------------------------
obj_filter <- obj %>% filter(division == "South Atlantic" & size == "medium")
obj_filter@indexes
identical(tblData(obj), tblData(obj_filter))

obj_select <- obj %>% select(division, size)
obj_select@indexes
identical(tblData(obj), tblData(obj_select))

## -----------------------------------------------------------------------------
rnms <- ROWNAMES(obj)
obj[sample(rnms, 3), ]

## -----------------------------------------------------------------------------
obj1 <- SQLDataFrame(conn = conn, dbtable = "state",
                     dbkey = c("region", "population"))
ROWNAMES(obj1[1:10,])
obj1[c("South:3615.0", "West:365.0"), ]

## -----------------------------------------------------------------------------
sessionInfo()

