/*
 * Decompiled with CFR 0.152.
 */
package base;

import java.util.Comparator;
import java.util.Random;

public class QuickSort {
    public static final Random RND = new Random();

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static <E> int partition(E[] EArray, int n, int n2, Comparator<? super E> comparator) {
        int n3 = n + RND.nextInt(n2 - n + 1);
        E e = EArray[n3];
        QuickSort.swap(EArray, n3, n2);
        for (int i = n3 = n; i < n2; ++i) {
            if (comparator.compare(EArray[i], e) >= 0) continue;
            QuickSort.swap(EArray, n3++, i);
        }
        QuickSort.swap(EArray, n3, n2);
        return n3;
    }

    public static <E> void qsort(E[] EArray, int n, int n2, Comparator<? super E> comparator) {
        if (n2 > n) {
            int n3 = QuickSort.partition(EArray, n, n2, comparator);
            QuickSort.qsort(EArray, n, n3 - 1, comparator);
            QuickSort.qsort(EArray, n3 + 1, n2, comparator);
        }
    }

    public static <E> void sort(E[] EArray, Comparator<? super E> comparator) {
        QuickSort.qsort(EArray, 0, EArray.length - 1, comparator);
    }
}

