library(DESeq2)
library(pasilla)
library(RUnit)
library(ReportingTools)

countData <- read.delim(system.file("extdata/pasilla_gene_counts.tsv", package = "pasilla"),
    stringsAsFactors = FALSE, row.names=1)
pData <- read.csv(system.file("extdata/pasilla_sample_annotation.csv", package = "pasilla"), 
    stringsAsFactors = FALSE)
rownames(pData) <- gsub("fb", "", pData$file)
pData <- pData[colnames(countData),]
pData$type <- factor(pData$type)
levels(pData$type) <- c("paired.end", "single.end")
dds <- DESeqDataSetFromMatrix(countData = countData,
                              colData = pData,
                              design = ~ condition + type)
colData(dds)$condition <- factor(colData(dds)$condition,
                                 levels=c("untreated","treated"))
dds.res <- DESeq(dds)

test_1dataframe <- function(){
    df <- toReportDF(dds.res, coef = 2, n = 100, make.plots = FALSE)
    checkTrue(nrow(df) == 100, 
        "100 rows are returned in coercing the DataSet to data.frame")
    checkTrue(ncol(df) == 4,
        "3 columns are returned for the default data.frame")
}

test_2coefs <- function(){
    df <- toReportDF(dds.res, resultName = "condition_treated_vs_untreated", n = 100,
        make.plots = FALSE)
    df2 <- toReportDF(dds.res, resultName = "type_single.end_vs_paired.end", n = 100,
        make.plots = FALSE)
    checkTrue(any(df$logFC != df2$logFC),
        "Results are different between selected coefficients")
    df3 <- toReportDF(dds.res, 
        contrast = c("condition", "treated", "untreated"), n = 100, 
        make.plots = FALSE)
}

test_3objectToHTML <- function(){
    rv <- objectToHTML(dds.res, rep=NULL, factor = dds.res$condition, 
        contrast = c("condition", "treated", "untreated"), n = 100,
        make.plots=FALSE)
    df <- rv[[2]]
    checkTrue(nrow(df) == 100, 
        "100 rows are returned in coercing the DataSet to data.frame")
    checkTrue(ncol(df) == 4,
        "3 columns are returned for the default data.frame")
}

test_4publish <- function(){
    htmlRep <- HTMLReport("testDESeqDataSet1",
        reportDirectory = "testHTMLDirectory", 
        title = "Test DESeqDataSet Report 1")
    publish(dds.res, htmlRep, factor = dds.res$condition, 
        contrast = c("condition", "treated", "untreated"), n = 100, 
        make.plots = TRUE)
    finish(htmlRep)    
}

test_5modifyDF <- function(){
    fives <- function(df, ...){df$Fives <- rep(5, nrow(df)); df}
    htmlRep <- HTMLReport("testDESeqDataSet2",
        reportDirectory = "testHTMLDirectory", 
        title = "Test DESeqDataSet Report 2")
    publish(dds.res, htmlRep, factor = dds.res$condition, 
        contrast = c("condition", "treated", "untreated"), n = 100,
        make.plots = FALSE, .modifyDF = fives)
    finish(htmlRep)    
}

test_2coefs()
