/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeType;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantDirectionalEdgeValueTransformer<V, E>
implements Transformer<Context<Graph<V, E>, E>, Number> {
    protected Double undirected_value;
    protected Double directed_value;

    public ConstantDirectionalEdgeValueTransformer(double undirected, double directed) {
        this.undirected_value = new Double(undirected);
        this.directed_value = new Double(directed);
    }

    @Override
    public Number transform(Context<Graph<V, E>, E> context) {
        Graph graph = (Graph)context.graph;
        Object e = context.element;
        if (graph.getEdgeType(e) == EdgeType.DIRECTED) {
            return this.directed_value;
        }
        return this.undirected_value;
    }

    public void setUndirectedValue(double value) {
        this.undirected_value = value;
    }

    public void setDirectedValue(double value) {
        this.directed_value = value;
    }
}

