/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxBasicCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxSvgCanvas
extends mxBasicCanvas {
    protected Document document;

    public mxSvgCanvas() {
        this(null);
    }

    public mxSvgCanvas(Document document) {
        this.setDocument(document);
    }

    public void appendSvgElement(Element element) {
        if (this.document != null) {
            this.document.getDocumentElement().appendChild(element);
        }
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public Object drawVertex(int n, int n2, int n3, int n4, Map<String, Object> map) {
        Element element = null;
        n += this.translate.x;
        n2 += this.translate.y;
        if (!mxUtils.getString(map, mxConstants.STYLE_SHAPE, "").equals("swimlane")) {
            element = this.drawShape(n, n2, n3, n4, map);
        } else {
            int n5 = (int)Math.round((double)mxUtils.getInt(map, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_STARTSIZE) * this.scale);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>(map);
            hashtable.remove(mxConstants.STYLE_FILLCOLOR);
            hashtable.remove(mxConstants.STYLE_ROUNDED);
            if (mxUtils.isTrue(map, mxConstants.STYLE_HORIZONTAL, true)) {
                element = this.drawShape(n, n2, n3, n5, map);
                this.drawShape(n, n2 + n5, n3, n4 - n5, hashtable);
            } else {
                element = this.drawShape(n, n2, n5, n4, map);
                this.drawShape(n + n5, n2, n3 - n5, n4, hashtable);
            }
        }
        return element;
    }

    @Override
    public Object drawEdge(List<mxPoint> list, Map<String, Object> map) {
        list = mxUtils.translatePoints(list, this.translate.x, this.translate.y);
        Element element = this.drawLine(list, map);
        float f = mxUtils.getFloat(map, mxConstants.STYLE_OPACITY, 100.0f);
        if (f != 100.0f) {
            String string = String.valueOf(f / 100.0f);
            element.setAttribute("fill-opacity", string);
            element.setAttribute("stroke-opacity", string);
        }
        return element;
    }

    @Override
    public Object drawLabel(String string, int n, int n2, int n3, int n4, Map<String, Object> map, boolean bl) {
        if (this.drawLabels) {
            return this.drawText(string, n += this.translate.x, n2 += this.translate.y, n3, n4, map);
        }
        return null;
    }

    public Element drawShape(int n, int n2, int n3, int n4, Map<String, Object> map) {
        float f;
        double d;
        Object object;
        String string = mxUtils.getString(map, mxConstants.STYLE_FILLCOLOR, "none");
        String string2 = mxUtils.getString(map, mxConstants.STYLE_STROKECOLOR);
        float f2 = (float)((double)mxUtils.getFloat(map, mxConstants.STYLE_STROKEWIDTH, 1.0f) * this.scale);
        String string3 = mxUtils.getString(map, mxConstants.STYLE_SHAPE);
        Element element = null;
        Element element2 = null;
        if (string3.equals("image")) {
            String string4 = this.getImageForStyle(map);
            if (string4 != null) {
                element = this.document.createElement("image");
                element.setAttribute("x", String.valueOf(n));
                element.setAttribute("y", String.valueOf(n2));
                element.setAttribute("width", String.valueOf(n3));
                element.setAttribute("height", String.valueOf(n4));
                element.setAttributeNS(mxConstants.NS_XLINK, "xlink:href", string4);
            }
        } else if (string3.equals("line")) {
            int n5;
            String string5 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, "east");
            object = null;
            if (string5.equals("east") || string5.equals("west")) {
                n5 = n2 + n4 / 2;
                object = "M " + n + " " + n5 + " L " + (n + n3) + " " + n5;
            } else {
                n5 = n + n3 / 2;
                object = "M " + n5 + " " + n2 + " L " + n5 + " " + (n2 + n4);
            }
            element = this.document.createElement("path");
            element.setAttribute("d", (String)object + " Z");
        } else if (string3.equals("ellipse")) {
            element = this.document.createElement("ellipse");
            element.setAttribute("cx", String.valueOf(n + n3 / 2));
            element.setAttribute("cy", String.valueOf(n2 + n4 / 2));
            element.setAttribute("rx", String.valueOf(n3 / 2));
            element.setAttribute("ry", String.valueOf(n4 / 2));
        } else if (string3.equals("doubleEllipse")) {
            element = this.document.createElement("g");
            element2 = this.document.createElement("ellipse");
            element2.setAttribute("cx", String.valueOf(n + n3 / 2));
            element2.setAttribute("cy", String.valueOf(n2 + n4 / 2));
            element2.setAttribute("rx", String.valueOf(n3 / 2));
            element2.setAttribute("ry", String.valueOf(n4 / 2));
            element.appendChild(element2);
            int n6 = (int)((double)(3.0f + f2) * this.scale);
            object = this.document.createElement("ellipse");
            object.setAttribute("fill", "none");
            object.setAttribute("stroke", string2);
            object.setAttribute("stroke-width", String.valueOf(f2));
            object.setAttribute("cx", String.valueOf(n + n3 / 2));
            object.setAttribute("cy", String.valueOf(n2 + n4 / 2));
            object.setAttribute("rx", String.valueOf(n3 / 2 - n6));
            object.setAttribute("ry", String.valueOf(n4 / 2 - n6));
            element.appendChild((Node)object);
        } else if (string3.equals("rhombus")) {
            element = this.document.createElement("path");
            String string6 = "M " + (n + n3 / 2) + " " + n2 + " L " + (n + n3) + " " + (n2 + n4 / 2) + " L " + (n + n3 / 2) + " " + (n2 + n4) + " L " + n + " " + (n2 + n4 / 2);
            element.setAttribute("d", string6 + " Z");
        } else if (string3.equals("triangle")) {
            element = this.document.createElement("path");
            String string7 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, "");
            object = null;
            object = string7.equals("north") ? "M " + n + " " + (n2 + n4) + " L " + (n + n3 / 2) + " " + n2 + " L " + (n + n3) + " " + (n2 + n4) : (string7.equals("south") ? "M " + n + " " + n2 + " L " + (n + n3 / 2) + " " + (n2 + n4) + " L " + (n + n3) + " " + n2 : (string7.equals("west") ? "M " + (n + n3) + " " + n2 + " L " + n + " " + (n2 + n4 / 2) + " L " + (n + n3) + " " + (n2 + n4) : "M " + n + " " + n2 + " L " + (n + n3) + " " + (n2 + n4 / 2) + " L " + n + " " + (n2 + n4)));
            element.setAttribute("d", (String)object + " Z");
        } else if (string3.equals("hexagon")) {
            element = this.document.createElement("path");
            String string8 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, "");
            object = null;
            object = string8.equals("north") || string8.equals("south") ? "M " + ((double)n + 0.5 * (double)n3) + " " + n2 + " L " + (n + n3) + " " + ((double)n2 + 0.25 * (double)n4) + " L " + (n + n3) + " " + ((double)n2 + 0.75 * (double)n4) + " L " + ((double)n + 0.5 * (double)n3) + " " + (n2 + n4) + " L " + n + " " + ((double)n2 + 0.75 * (double)n4) + " L " + n + " " + ((double)n2 + 0.25 * (double)n4) : "M " + ((double)n + 0.25 * (double)n3) + " " + n2 + " L " + ((double)n + 0.75 * (double)n3) + " " + n2 + " L " + (n + n3) + " " + ((double)n2 + 0.5 * (double)n4) + " L " + ((double)n + 0.75 * (double)n3) + " " + (n2 + n4) + " L " + ((double)n + 0.25 * (double)n3) + " " + (n2 + n4) + " L " + n + " " + ((double)n2 + 0.5 * (double)n4);
            element.setAttribute("d", (String)object + " Z");
        } else if (string3.equals("cloud")) {
            element = this.document.createElement("path");
            String string9 = "M " + ((double)n + 0.25 * (double)n3) + " " + ((double)n2 + 0.25 * (double)n4) + " C " + ((double)n + 0.05 * (double)n3) + " " + ((double)n2 + 0.25 * (double)n4) + " " + n + " " + ((double)n2 + 0.5 * (double)n4) + " " + ((double)n + 0.16 * (double)n3) + " " + ((double)n2 + 0.55 * (double)n4) + " C " + n + " " + ((double)n2 + 0.66 * (double)n4) + " " + ((double)n + 0.18 * (double)n3) + " " + ((double)n2 + 0.9 * (double)n4) + " " + ((double)n + 0.31 * (double)n3) + " " + ((double)n2 + 0.8 * (double)n4) + " C " + ((double)n + 0.4 * (double)n3) + " " + (n2 + n4) + " " + ((double)n + 0.7 * (double)n3) + " " + (n2 + n4) + " " + ((double)n + 0.8 * (double)n3) + " " + ((double)n2 + 0.8 * (double)n4) + " C " + (n + n3) + " " + ((double)n2 + 0.8 * (double)n4) + " " + (n + n3) + " " + ((double)n2 + 0.6 * (double)n4) + " " + ((double)n + 0.875 * (double)n3) + " " + ((double)n2 + 0.5 * (double)n4) + " C " + (n + n3) + " " + ((double)n2 + 0.3 * (double)n4) + " " + ((double)n + 0.8 * (double)n3) + " " + ((double)n2 + 0.1 * (double)n4) + " " + ((double)n + 0.625 * (double)n3) + " " + ((double)n2 + 0.2 * (double)n4) + " C " + ((double)n + 0.5 * (double)n3) + " " + ((double)n2 + 0.05 * (double)n4) + " " + ((double)n + 0.3 * (double)n3) + " " + ((double)n2 + 0.05 * (double)n4) + " " + ((double)n + 0.25 * (double)n3) + " " + ((double)n2 + 0.25 * (double)n4);
            element.setAttribute("d", string9 + " Z");
        } else if (string3.equals("actor")) {
            element = this.document.createElement("path");
            double d2 = n3 / 3;
            String string10 = " M " + n + " " + (n2 + n4) + " C " + n + " " + (n2 + 3 * n4 / 5) + " " + n + " " + (n2 + 2 * n4 / 5) + " " + (n + n3 / 2) + " " + (n2 + 2 * n4 / 5) + " C " + ((double)(n + n3 / 2) - d2) + " " + (n2 + 2 * n4 / 5) + " " + ((double)(n + n3 / 2) - d2) + " " + n2 + " " + (n + n3 / 2) + " " + n2 + " C " + ((double)(n + n3 / 2) + d2) + " " + n2 + " " + ((double)(n + n3 / 2) + d2) + " " + (n2 + 2 * n4 / 5) + " " + (n + n3 / 2) + " " + (n2 + 2 * n4 / 5) + " C " + (n + n3) + " " + (n2 + 2 * n4 / 5) + " " + (n + n3) + " " + (n2 + 3 * n4 / 5) + " " + (n + n3) + " " + (n2 + n4);
            element.setAttribute("d", string10 + " Z");
        } else if (string3.equals("cylinder")) {
            element = this.document.createElement("g");
            element2 = this.document.createElement("path");
            double d3 = Math.min(40.0, Math.floor(n4 / 5));
            String string11 = " M " + n + " " + ((double)n2 + d3) + " C " + n + " " + ((double)n2 - d3 / 3.0) + " " + (n + n3) + " " + ((double)n2 - d3 / 3.0) + " " + (n + n3) + " " + ((double)n2 + d3) + " L " + (n + n3) + " " + ((double)(n2 + n4) - d3) + " C " + (n + n3) + " " + ((double)(n2 + n4) + d3 / 3.0) + " " + n + " " + ((double)(n2 + n4) + d3 / 3.0) + " " + n + " " + ((double)(n2 + n4) - d3);
            element2.setAttribute("d", string11 + " Z");
            element.appendChild(element2);
            Element element3 = this.document.createElement("path");
            string11 = "M " + n + " " + ((double)n2 + d3) + " C " + n + " " + ((double)n2 + 2.0 * d3) + " " + (n + n3) + " " + ((double)n2 + 2.0 * d3) + " " + (n + n3) + " " + ((double)n2 + d3);
            element3.setAttribute("d", string11);
            element3.setAttribute("fill", "none");
            element3.setAttribute("stroke", string2);
            element3.setAttribute("stroke-width", String.valueOf(f2));
            element.appendChild(element3);
        } else {
            element = this.document.createElement("rect");
            element.setAttribute("x", String.valueOf(n));
            element.setAttribute("y", String.valueOf(n2));
            element.setAttribute("width", String.valueOf(n3));
            element.setAttribute("height", String.valueOf(n4));
            if (mxUtils.isTrue(map, mxConstants.STYLE_ROUNDED, false)) {
                element.setAttribute("rx", String.valueOf((double)n3 * mxConstants.RECTANGLE_ROUNDING_FACTOR));
                element.setAttribute("ry", String.valueOf((double)n4 * mxConstants.RECTANGLE_ROUNDING_FACTOR));
            }
        }
        Element element4 = element2;
        if (element4 == null) {
            element4 = element;
        }
        element4.setAttribute("fill", string);
        element4.setAttribute("stroke", string2);
        element4.setAttribute("stroke-width", String.valueOf(f2));
        object = null;
        if (mxUtils.isTrue(map, mxConstants.STYLE_SHADOW, false) && !string.equals("none")) {
            object = (Element)element4.cloneNode(true);
            object.setAttribute("transform", mxConstants.SVG_SHADOWTRANSFORM);
            object.setAttribute("fill", mxConstants.W3C_SHADOWCOLOR);
            object.setAttribute("stroke", mxConstants.W3C_SHADOWCOLOR);
            object.setAttribute("stroke-width", String.valueOf(f2));
            this.appendSvgElement((Element)object);
        }
        if ((d = mxUtils.getDouble(map, mxConstants.STYLE_ROTATION)) != 0.0) {
            int n7 = n + n3 / 2;
            int n8 = n2 + n4 / 2;
            element.setAttribute("transform", "rotate(" + d + "," + n7 + "," + n8 + ")");
            if (object != null) {
                object.setAttribute("transform", "rotate(" + d + "," + n7 + "," + n8 + ") " + mxConstants.SVG_SHADOWTRANSFORM);
            }
        }
        if ((f = mxUtils.getFloat(map, mxConstants.STYLE_OPACITY, 100.0f)) != 100.0f) {
            String string12 = String.valueOf(f / 100.0f);
            element.setAttribute("fill-opacity", string12);
            element.setAttribute("stroke-opacity", string12);
            if (object != null) {
                object.setAttribute("fill-opacity", string12);
                object.setAttribute("stroke-opacity", string12);
            }
        }
        this.appendSvgElement(element);
        return element;
    }

    public Element drawLine(List<mxPoint> list, Map<String, Object> map) {
        Element element = this.document.createElement("g");
        Element element2 = this.document.createElement("path");
        String string = mxUtils.getString(map, mxConstants.STYLE_STROKECOLOR);
        float f = mxUtils.getFloat(map, mxConstants.STYLE_STROKEWIDTH, 1.0f);
        float f2 = (float)((double)f * this.scale);
        if (string != null && f2 > 0.0f) {
            Object object = map.get(mxConstants.STYLE_STARTARROW);
            mxPoint mxPoint2 = list.get(1);
            mxPoint mxPoint3 = list.get(0);
            mxPoint mxPoint4 = null;
            if (object != null) {
                float f3 = mxUtils.getFloat(map, mxConstants.STYLE_STARTSIZE, mxConstants.DEFAULT_MARKERSIZE);
                mxPoint4 = this.drawMarker(element, object, mxPoint2, mxPoint3, f3, f, string);
            } else {
                double d = mxPoint2.getX() - mxPoint3.getX();
                double d2 = mxPoint2.getY() - mxPoint3.getY();
                double d3 = Math.max(1.0, Math.sqrt(d * d + d2 * d2));
                double d4 = d * (double)f2 / d3;
                double d5 = d2 * (double)f2 / d3;
                mxPoint4 = new mxPoint(d4 / 2.0, d5 / 2.0);
            }
            if (mxPoint4 != null) {
                mxPoint3 = (mxPoint)mxPoint3.clone();
                mxPoint3.setX(mxPoint3.getX() + mxPoint4.getX());
                mxPoint3.setY(mxPoint3.getY() + mxPoint4.getY());
                mxPoint4 = null;
            }
            object = map.get(mxConstants.STYLE_ENDARROW);
            mxPoint2 = list.get(list.size() - 2);
            mxPoint mxPoint5 = list.get(list.size() - 1);
            if (object != null) {
                float f4 = mxUtils.getFloat(map, mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE);
                mxPoint4 = this.drawMarker(element, object, mxPoint2, mxPoint5, f4, f, string);
            } else {
                double d = mxPoint2.getX() - mxPoint3.getX();
                double d6 = mxPoint2.getY() - mxPoint3.getY();
                double d7 = Math.max(1.0, Math.sqrt(d * d + d6 * d6));
                double d8 = d * (double)f2 / d7;
                double d9 = d6 * (double)f2 / d7;
                mxPoint4 = new mxPoint(d8 / 2.0, d9 / 2.0);
            }
            if (mxPoint4 != null) {
                mxPoint5 = (mxPoint)mxPoint5.clone();
                mxPoint5.setX(mxPoint5.getX() + mxPoint4.getX());
                mxPoint5.setY(mxPoint5.getY() + mxPoint4.getY());
                mxPoint4 = null;
            }
            mxPoint2 = mxPoint3;
            String string2 = "M " + mxPoint2.getX() + " " + mxPoint2.getY();
            for (int i = 1; i < list.size() - 1; ++i) {
                mxPoint2 = list.get(i);
                string2 = string2 + " L " + mxPoint2.getX() + " " + mxPoint2.getY();
            }
            string2 = string2 + " L " + mxPoint5.getX() + " " + mxPoint5.getY();
            element2.setAttribute("d", string2);
            element2.setAttribute("stroke", string);
            element2.setAttribute("fill", "none");
            element2.setAttribute("stroke-width", String.valueOf(f2));
            element.appendChild(element2);
            this.appendSvgElement(element);
        }
        return element;
    }

    public mxPoint drawMarker(Element element, Object object, mxPoint mxPoint2, mxPoint mxPoint3, float f, float f2, String string) {
        mxPoint mxPoint4 = null;
        double d = mxPoint3.getX() - mxPoint2.getX();
        double d2 = mxPoint3.getY() - mxPoint2.getY();
        double d3 = Math.max(1.0, Math.sqrt(d * d + d2 * d2));
        double d4 = (double)f * this.scale;
        double d5 = d * d4 / d3;
        double d6 = d2 * d4 / d3;
        mxPoint3 = (mxPoint)mxPoint3.clone();
        mxPoint3.setX(mxPoint3.getX() - d5 * (double)f2 / (double)(2.0f * f));
        mxPoint3.setY(mxPoint3.getY() - d6 * (double)f2 / (double)(2.0f * f));
        d5 *= 0.5 + (double)(f2 / 2.0f);
        d6 *= 0.5 + (double)(f2 / 2.0f);
        Element element2 = this.document.createElement("path");
        element2.setAttribute("stroke-width", String.valueOf((double)f2 * this.scale));
        element2.setAttribute("stroke", string);
        element2.setAttribute("fill", string);
        String string2 = null;
        if (object.equals("classic") || object.equals("block")) {
            string2 = "M " + mxPoint3.getX() + " " + mxPoint3.getY() + " L " + (mxPoint3.getX() - d5 - d6 / 2.0) + " " + (mxPoint3.getY() - d6 + d5 / 2.0) + (!object.equals("classic") ? "" : " L " + (mxPoint3.getX() - d5 * 3.0 / 4.0) + " " + (mxPoint3.getY() - d6 * 3.0 / 4.0)) + " L " + (mxPoint3.getX() + d6 / 2.0 - d5) + " " + (mxPoint3.getY() - d6 - d5 / 2.0) + " z";
        } else if (object.equals("open")) {
            string2 = "M " + (mxPoint3.getX() - (d5 *= 1.2) - (d6 *= 1.2) / 2.0) + " " + (mxPoint3.getY() - d6 + d5 / 2.0) + " L " + (mxPoint3.getX() - d5 / 6.0) + " " + (mxPoint3.getY() - d6 / 6.0) + " L " + (mxPoint3.getX() + d6 / 2.0 - d5) + " " + (mxPoint3.getY() - d6 - d5 / 2.0) + " M " + mxPoint3.getX() + " " + mxPoint3.getY();
            element2.setAttribute("fill", "none");
        } else if (object.equals("oval")) {
            string2 = "M " + (mxPoint3.getX() - (d6 *= 1.2) / 2.0) + " " + (mxPoint3.getY() + (d5 *= 1.2) / 2.0) + " a " + (d4 *= 1.2) / 2.0 + " " + d4 / 2.0 + " 0  1,1 " + d5 / 8.0 + " " + d6 / 8.0 + " z";
        } else if (object.equals("diamond")) {
            string2 = "M " + (mxPoint3.getX() + d5 / 2.0) + " " + (mxPoint3.getY() + d6 / 2.0) + " L " + (mxPoint3.getX() - d6 / 2.0) + " " + (mxPoint3.getY() + d5 / 2.0) + " L " + (mxPoint3.getX() - d5 / 2.0) + " " + (mxPoint3.getY() - d6 / 2.0) + " L " + (mxPoint3.getX() + d6 / 2.0) + " " + (mxPoint3.getY() - d5 / 2.0) + " z";
        }
        if (string2 != null) {
            element2.setAttribute("d", string2);
            element.appendChild(element2);
        }
        return mxPoint4;
    }

    public Object drawText(String string, int n, int n2, int n3, int n4, Map<String, Object> map) {
        Element element = null;
        String string2 = mxUtils.getString(map, mxConstants.STYLE_FONTCOLOR, "black");
        String string3 = mxUtils.getString(map, mxConstants.STYLE_FONTFAMILY, mxConstants.DEFAULT_FONTFAMILIES);
        int n5 = (int)((double)mxUtils.getInt(map, mxConstants.STYLE_FONTSIZE, mxConstants.DEFAULT_FONTSIZE) * this.scale);
        if (string != null && string.length() > 0) {
            String[] stringArray;
            element = this.document.createElement("text");
            float f = mxUtils.getFloat(map, mxConstants.STYLE_TEXT_OPACITY, 100.0f);
            if (f != 100.0f) {
                stringArray = String.valueOf(f / 100.0f);
                element.setAttribute("fill-opacity", (String)stringArray);
                element.setAttribute("stroke-opacity", (String)stringArray);
            }
            element.setAttribute("text-anchor", "middle");
            element.setAttribute("font-weight", "normal");
            element.setAttribute("font-decoration", "none");
            element.setAttribute("font-size", String.valueOf(n5));
            element.setAttribute("font-family", string3);
            element.setAttribute("fill", string2);
            stringArray = string.split("\n");
            n2 += n5 + (n4 - stringArray.length * (n5 + mxConstants.LINESPACING)) / 2 - 2;
            for (int i = 0; i < stringArray.length; ++i) {
                Element element2 = this.document.createElement("tspan");
                element2.setAttribute("x", String.valueOf(n + n3 / 2));
                element2.setAttribute("y", String.valueOf(n2));
                element2.appendChild(this.document.createTextNode(stringArray[i]));
                element.appendChild(element2);
                n2 += n5 + mxConstants.LINESPACING;
            }
            this.appendSvgElement(element);
        }
        return element;
    }
}

