/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.cmdline;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.picard.cmdline.CommandLineParser;
import net.sf.picard.cmdline.Option;
import net.sf.picard.metrics.Header;
import net.sf.picard.metrics.MetricBase;
import net.sf.picard.metrics.MetricsFile;
import net.sf.picard.metrics.StringHeader;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.util.BlockCompressedOutputStream;

public abstract class CommandLineProgram {
    private static final Set<String> STANDARD_OPTIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("TMP_DIR", "VERBOSITY", "QUIET", "VALIDATION_STRINGENCY", "COMPRESSION_LEVEL", "MAX_RECORDS_IN_RAM", "CREATE_INDEX", "MD5_FILE")));
    @Option
    public File TMP_DIR = System.getProperty("java.io.tmpdir").endsWith("/" + System.getProperty("user.name")) ? new File(System.getProperty("java.io.tmpdir")) : new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
    @Option(doc="Control verbosity of logging.")
    public Log.LogLevel VERBOSITY = Log.LogLevel.INFO;
    @Option(doc="Whether to suppress job-summary info on System.err.")
    public Boolean QUIET = false;
    @Option(doc="Validation stringency for all SAM files read by this program.  Setting stringency to SILENT can improve performance when processing a BAM file in which variable-length data (read, qualities, tags) do not otherwise need to be decoded.")
    public SAMFileReader.ValidationStringency VALIDATION_STRINGENCY = SAMFileReader.ValidationStringency.DEFAULT_STRINGENCY;
    @Option(doc="Compression level for all compressed files created (e.g. BAM and GELI).")
    public int COMPRESSION_LEVEL = 5;
    @Option(doc="When writing SAM files that need to be sorted, this will specify the number of records stored in RAM before spilling to disk. Increasing this number reduces the number of file handles needed to sort a SAM file, and increases the amount of RAM needed.", optional=true)
    public Integer MAX_RECORDS_IN_RAM = SAMFileWriterImpl.getDefaultMaxRecordsInRam();
    @Option(doc="Whether to create a BAM index when writing a coordinate-sorted BAM file.")
    public Boolean CREATE_INDEX = false;
    @Option(doc="Whether to create an MD5 digest for any BAM files created.  ")
    public boolean CREATE_MD5_FILE = false;
    private final String standardUsagePreamble = CommandLineParser.getStandardUsagePreamble(this.getClass());
    private CommandLineParser commandLineParser;
    private final List<Header> defaultHeaders = new ArrayList<Header>();
    private String commandLine;

    protected abstract int doWork();

    public void instanceMainWithExit(String[] argv) {
        System.exit(this.instanceMain(argv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int instanceMain(String[] argv) {
        int ret;
        if (!this.parseArgs(argv)) {
            return 1;
        }
        Date startDate = new Date();
        this.defaultHeaders.add(new StringHeader(this.commandLine));
        this.defaultHeaders.add(new StringHeader("Started on: " + startDate));
        Log.setGlobalLogLevel(this.VERBOSITY);
        SAMFileReader.setDefaultValidationStringency(this.VALIDATION_STRINGENCY);
        BlockCompressedOutputStream.setDefaultCompressionLevel(this.COMPRESSION_LEVEL);
        if (this.MAX_RECORDS_IN_RAM != null) {
            SAMFileWriterImpl.setDefaultMaxRecordsInRam(this.MAX_RECORDS_IN_RAM);
        }
        if (this.CREATE_INDEX.booleanValue()) {
            SAMFileWriterFactory.setDefaultCreateIndexWhileWriting(true);
        }
        SAMFileWriterFactory.setDefaultCreateMd5File(this.CREATE_MD5_FILE);
        if (!this.TMP_DIR.exists()) {
            this.TMP_DIR.mkdir();
        }
        System.setProperty("java.io.tmpdir", this.TMP_DIR.getAbsolutePath());
        if (!this.QUIET.booleanValue()) {
            System.err.println("[" + new Date() + "] " + this.commandLine);
        }
        try {
            ret = this.doWork();
        }
        finally {
            if (!this.QUIET.booleanValue()) {
                System.err.println("[" + new Date() + "] " + this.getClass().getName() + " done.");
                System.err.println("Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
            }
        }
        return ret;
    }

    protected String[] customCommandLineValidation() {
        return null;
    }

    protected boolean parseArgs(String[] argv) {
        this.commandLineParser = new CommandLineParser(this);
        boolean ret = this.commandLineParser.parseOptions(System.err, argv);
        this.commandLine = this.commandLineParser.getCommandLine();
        if (!ret) {
            return false;
        }
        String[] customErrorMessages = this.customCommandLineValidation();
        if (customErrorMessages != null) {
            for (String msg : customErrorMessages) {
                System.err.println(msg);
            }
            this.commandLineParser.usage(System.err);
            return false;
        }
        return true;
    }

    protected <A extends MetricBase, B extends Comparable<?>> MetricsFile<A, B> getMetricsFile() {
        MetricsFile file = new MetricsFile();
        for (Header h : this.defaultHeaders) {
            file.addHeader(h);
        }
        return file;
    }

    public String getStandardUsagePreamble() {
        return this.standardUsagePreamble;
    }

    public CommandLineParser getCommandLineParser() {
        return this.commandLineParser;
    }

    public String getProgramVersion() {
        return this.commandLineParser.getProgramVersion();
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public static Set<String> getStandardOptions() {
        return STANDARD_OPTIONS;
    }
}

