## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  # fig.align = "center",
  comment = ">"
)

## ---- eval = FALSE------------------------------------------------------------
#  # install.packages("BiocManager")
#  BiocManager::install("POMA")

## ---- warning = FALSE, message = FALSE, comment = FALSE-----------------------
library(POMA)

## ---- warning = FALSE, message = FALSE, comment = FALSE-----------------------
library(ggplot2)
library(ggraph)

## ---- eval = FALSE------------------------------------------------------------
#  # create an MSnSet object from two separated data frames
#  target <- readr::read_csv("your_target.csv")
#  features <- readr::read_csv("your_features.csv")
#  
#  data <- PomaMSnSetClass(target = target, features = features)

## -----------------------------------------------------------------------------
# load example data
data("st000336")
st000336

## -----------------------------------------------------------------------------
imputed <- PomaImpute(st000336, ZerosAsNA = TRUE, RemoveNA = TRUE, cutoff = 20, method = "knn")
imputed

## -----------------------------------------------------------------------------
normalized <- PomaNorm(imputed, method = "log_pareto")
normalized

## ---- message = FALSE, comment = FALSE----------------------------------------
PomaBoxplots(imputed, group = "samples", jitter = FALSE) +
  ggtitle("Not Normalized") +
  theme(legend.position = "none") # data before normalization

## ---- message = FALSE, comment = FALSE----------------------------------------
PomaBoxplots(normalized, group = "samples", jitter = FALSE) +
  ggtitle("Normalized") # data after normalization

## ---- message = FALSE, comment = FALSE----------------------------------------
PomaDensity(imputed, group = "features") +
  ggtitle("Not Normalized") +
  theme(legend.position = "none") # data before normalization

## ---- message = FALSE, comment = FALSE----------------------------------------
PomaDensity(normalized, group = "features") +
  ggtitle("Normalized") # data after normalization

## -----------------------------------------------------------------------------
PomaOutliers(normalized, do = "analyze")$polygon_plot # to explore
pre_processed <- PomaOutliers(normalized, do = "clean") # to remove outliers
pre_processed

## -----------------------------------------------------------------------------
PomaUnivariate(pre_processed, method = "ttest") %>% head()

## -----------------------------------------------------------------------------
PomaVolcano(imputed, pval = "adjusted")

## ---- warning = FALSE---------------------------------------------------------
PomaUnivariate(pre_processed, method = "mann") %>% head()

## -----------------------------------------------------------------------------
PomaLimma(pre_processed, contrast = "Controls-DMD", adjust = "fdr") %>% head()

## -----------------------------------------------------------------------------
poma_pca <- PomaMultivariate(pre_processed, method = "pca")

## -----------------------------------------------------------------------------
poma_pca$scoresplot +
  ggtitle("Scores Plot")

## ---- comment = FALSE, warning = FALSE, message = FALSE, results = 'hide'-----
poma_plsda <- PomaMultivariate(pre_processed, method = "plsda")

## -----------------------------------------------------------------------------
poma_plsda$scoresplot +
  ggtitle("Scores Plot")

## -----------------------------------------------------------------------------
poma_plsda$errors_plsda_plot +
  ggtitle("Error Plot")

## -----------------------------------------------------------------------------
poma_cor <- PomaCorr(pre_processed, label_size = 8, coeff = 0.6)
poma_cor$correlations %>% head()
poma_cor$corrplot
poma_cor$graph

## -----------------------------------------------------------------------------
PomaCorr(pre_processed, corr_type = "glasso", coeff = 0.6)$graph

## -----------------------------------------------------------------------------
# alpha = 1 for Lasso
PomaLasso(pre_processed, alpha = 1, labels = TRUE)$coefficientPlot

## -----------------------------------------------------------------------------
poma_rf <- PomaRandForest(pre_processed, ntest = 10, nvar = 10)
poma_rf$error_tree

## -----------------------------------------------------------------------------
poma_rf$confusion_matrix

## -----------------------------------------------------------------------------
poma_rf$gini_plot

## -----------------------------------------------------------------------------
sessionInfo()

