/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.ptm;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.ptm.PtmDialog;
import com.compomics.util.gui.ptm.PtmDialogParent;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.pride.PrideObjectsFactory;
import com.compomics.util.pride.PtmToPrideMap;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;

public class ModificationsDialog
extends JDialog
implements PtmDialogParent {
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private PtmDialogParent ptmDialogParent;
    private PtmToPrideMap ptmToPrideMap;
    private Color sparklineColor = new Color(110, 196, 97);
    private String selectedRowHtmlTagFontColor = "#FFFFFF";
    private String notSelectedRowHtmlTagFontColor = "#0101DF";
    private ArrayList<String> defaultModsTableToolTips;
    private ArrayList<String> userModsTableToolTips;
    private ArrayList<Integer> searchPossibilities = new ArrayList();
    private int searchCurrentSelection = 0;
    private final String searchWelcomeText = "(name or mass)";
    private JButton addUserPTM;
    private JTable defaultModificationsTable;
    private JPanel defaultModsPanel;
    private JScrollPane defaultModsScrollPane;
    private JPopupMenu defaultPtmPopupMenu;
    private JButton deleteUserPTM;
    private JMenuItem editDefaultPtmJMenuItem;
    private JButton editUserPTM;
    private JMenuItem editUserPtmJMenuItem;
    private JLabel findJLabel;
    private JPanel modificationsEditorPanel;
    private JButton modificationsHelpJButton;
    private JSplitPane modificationsSplitPane;
    private JButton okButton;
    private JLabel searchIndexLabel;
    private JTextField searchInputTxt;
    private JButton searchNextButton;
    private JButton searchPreviousButton;
    private JTable userModificationsTable;
    private JPanel userModsPanel;
    private JScrollPane userModsScrollPane;
    private JPopupMenu userPtmPopupMenu;

    public ModificationsDialog(Frame parentFrame, PtmDialogParent parent, boolean modal) {
        super(parentFrame, modal);
        this.ptmDialogParent = parent;
        this.initComponents();
        this.setUpTables();
        try {
            PrideObjectsFactory prideObjectsFactory = PrideObjectsFactory.getInstance();
            this.ptmToPrideMap = prideObjectsFactory.getPtmToPrideMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.searchInputTxt.setText("(name or mass)");
        this.searchIndexLabel.setText("");
        this.searchPreviousButton.setEnabled(false);
        this.searchNextButton.setEnabled(false);
        this.setLocationRelativeTo(parentFrame);
        this.setVisible(true);
    }

    private void setUpTables() {
        this.defaultModificationsTable.setAutoCreateRowSorter(true);
        this.userModificationsTable.setAutoCreateRowSorter(true);
        this.defaultModsScrollPane.getViewport().setOpaque(false);
        this.userModsScrollPane.getViewport().setOpaque(false);
        this.defaultModificationsTable.getTableHeader().setReorderingAllowed(false);
        this.userModificationsTable.getTableHeader().setReorderingAllowed(false);
        this.defaultModificationsTable.getColumn(" ").setMaxWidth(50);
        this.defaultModificationsTable.getColumn(" ").setMinWidth(50);
        this.userModificationsTable.getColumn(" ").setMaxWidth(50);
        this.userModificationsTable.getColumn(" ").setMinWidth(50);
        this.defaultModificationsTable.getColumn("Type").setMaxWidth(50);
        this.defaultModificationsTable.getColumn("Type").setMinWidth(50);
        this.userModificationsTable.getColumn("Type").setMaxWidth(50);
        this.userModificationsTable.getColumn("Type").setMinWidth(50);
        this.defaultModificationsTable.getColumn("CV").setMaxWidth(100);
        this.defaultModificationsTable.getColumn("CV").setMinWidth(100);
        this.userModificationsTable.getColumn("CV").setMaxWidth(100);
        this.userModificationsTable.getColumn("CV").setMinWidth(100);
        HashMap<Integer, Color> ptmTypeColorMap = new HashMap<Integer, Color>();
        ptmTypeColorMap.put(9, Color.lightGray);
        ptmTypeColorMap.put(0, this.sparklineColor);
        ptmTypeColorMap.put(3, Color.CYAN);
        ptmTypeColorMap.put(4, Color.MAGENTA);
        ptmTypeColorMap.put(7, Color.RED);
        ptmTypeColorMap.put(8, Color.ORANGE);
        ptmTypeColorMap.put(1, Color.YELLOW);
        ptmTypeColorMap.put(2, Color.PINK);
        ptmTypeColorMap.put(5, Color.BLUE);
        ptmTypeColorMap.put(6, Color.GRAY);
        HashMap<Integer, String> ptmTypeTooltipMap = new HashMap<Integer, String>();
        ptmTypeTooltipMap.put(9, "max number of modification types");
        ptmTypeTooltipMap.put(0, "Particular Amino Acid(s)");
        ptmTypeTooltipMap.put(3, "Protein C-term");
        ptmTypeTooltipMap.put(4, "Protein C-term - Particular Amino Acid(s)");
        ptmTypeTooltipMap.put(7, "Peptide C-term");
        ptmTypeTooltipMap.put(8, "Peptide C-term - Particular Amino Acid(s)");
        ptmTypeTooltipMap.put(1, "Protein N-term");
        ptmTypeTooltipMap.put(2, "Protein N-term - Particular Amino Acid(s)");
        ptmTypeTooltipMap.put(5, "Peptide N-term");
        ptmTypeTooltipMap.put(6, "Peptide N-term - Particular Amino Acid(s)");
        this.defaultModificationsTable.getColumn("Type").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, ptmTypeColorMap, ptmTypeTooltipMap));
        this.userModificationsTable.getColumn("Type").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, ptmTypeColorMap, ptmTypeTooltipMap));
        this.defaultModificationsTable.getColumn("CV").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(this.selectedRowHtmlTagFontColor, this.notSelectedRowHtmlTagFontColor));
        this.userModificationsTable.getColumn("CV").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(this.selectedRowHtmlTagFontColor, this.notSelectedRowHtmlTagFontColor));
        this.updateMassSparklines();
        this.defaultModsTableToolTips = new ArrayList();
        this.defaultModsTableToolTips.add(null);
        this.defaultModsTableToolTips.add("Modification Name");
        this.defaultModsTableToolTips.add("Modification Short Name");
        this.defaultModsTableToolTips.add("Modification Mass Change");
        this.defaultModsTableToolTips.add("Modification Type");
        this.defaultModsTableToolTips.add("Affected Residues");
        this.defaultModsTableToolTips.add("CV Term Mapping");
        this.userModsTableToolTips = new ArrayList();
        this.userModsTableToolTips.add(null);
        this.userModsTableToolTips.add("Modification Name");
        this.userModsTableToolTips.add("Modification Short Name");
        this.userModsTableToolTips.add("Modification Mass Change");
        this.userModsTableToolTips.add("Modification Type");
        this.userModsTableToolTips.add("Affected Residues");
        this.userModsTableToolTips.add("CV Term Mapping");
    }

    private void updateMassSparklines() {
        int i;
        double maxMassChange = 0.0;
        for (i = 0; i < this.defaultModificationsTable.getRowCount(); ++i) {
            if (!(Math.abs((Double)this.defaultModificationsTable.getValueAt(i, this.defaultModificationsTable.getColumn("Mass").getModelIndex())) > maxMassChange)) continue;
            maxMassChange = Math.abs((Double)this.defaultModificationsTable.getValueAt(i, this.defaultModificationsTable.getColumn("Mass").getModelIndex()));
        }
        for (i = 0; i < this.userModificationsTable.getRowCount(); ++i) {
            if (!(Math.abs((Double)this.userModificationsTable.getValueAt(i, this.userModificationsTable.getColumn("Mass").getModelIndex())) > maxMassChange)) continue;
            maxMassChange = Math.abs((Double)this.userModificationsTable.getValueAt(i, this.userModificationsTable.getColumn("Mass").getModelIndex()));
        }
        this.defaultModificationsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(-maxMassChange), Double.valueOf(maxMassChange)));
        ((JSparklinesBarChartTableCellRenderer)this.defaultModificationsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 55, new DecimalFormat("0.0000"));
        this.userModificationsTable.getColumn("Mass").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(-maxMassChange), Double.valueOf(maxMassChange)));
        ((JSparklinesBarChartTableCellRenderer)this.userModificationsTable.getColumn("Mass").getCellRenderer()).showNumberAndChart(true, 55, new DecimalFormat("0.0000"));
    }

    private void initComponents() {
        this.defaultPtmPopupMenu = new JPopupMenu();
        this.editDefaultPtmJMenuItem = new JMenuItem();
        this.userPtmPopupMenu = new JPopupMenu();
        this.editUserPtmJMenuItem = new JMenuItem();
        this.modificationsEditorPanel = new JPanel();
        this.modificationsSplitPane = new JSplitPane();
        this.defaultModsPanel = new JPanel();
        this.defaultModsScrollPane = new JScrollPane();
        this.defaultModificationsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)ModificationsDialog.this.defaultModsTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.searchIndexLabel = new JLabel();
        this.searchNextButton = new JButton();
        this.searchPreviousButton = new JButton();
        this.searchInputTxt = new JTextField();
        this.findJLabel = new JLabel();
        this.userModsPanel = new JPanel();
        this.userModsScrollPane = new JScrollPane();
        this.userModificationsTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        return (String)ModificationsDialog.this.userModsTableToolTips.get(realIndex);
                    }
                };
            }
        };
        this.deleteUserPTM = new JButton();
        this.editUserPTM = new JButton();
        this.addUserPTM = new JButton();
        this.okButton = new JButton();
        this.modificationsHelpJButton = new JButton();
        this.editDefaultPtmJMenuItem.setText("Edit");
        this.editDefaultPtmJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.editDefaultPtmJMenuItemActionPerformed(evt);
            }
        });
        this.defaultPtmPopupMenu.add(this.editDefaultPtmJMenuItem);
        this.editUserPtmJMenuItem.setText("Edit");
        this.editUserPtmJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.editUserPtmJMenuItemActionPerformed(evt);
            }
        });
        this.userPtmPopupMenu.add(this.editUserPtmJMenuItem);
        this.setDefaultCloseOperation(0);
        this.setTitle("Modification Details");
        this.setMinimumSize(new Dimension(500, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ModificationsDialog.this.formWindowClosing(evt);
            }
        });
        this.modificationsEditorPanel.setBackground(new Color(230, 230, 230));
        this.modificationsSplitPane.setBorder(null);
        this.modificationsSplitPane.setDividerLocation(296);
        this.modificationsSplitPane.setDividerSize(-1);
        this.modificationsSplitPane.setOrientation(0);
        this.modificationsSplitPane.setResizeWeight(0.5);
        this.modificationsSplitPane.setOpaque(false);
        this.defaultModsPanel.setBorder(BorderFactory.createTitledBorder("Default Modifications"));
        this.defaultModsPanel.setOpaque(false);
        this.defaultModificationsTable.setModel(new DefaultPTMTable());
        this.defaultModificationsTable.setSelectionMode(0);
        this.defaultModificationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsDialog.this.defaultModificationsTableMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModificationsDialog.this.defaultModificationsTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.defaultModificationsTableMouseExited(evt);
            }
        });
        this.defaultModificationsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModificationsDialog.this.defaultModificationsTableMouseMoved(evt);
            }
        });
        this.defaultModsScrollPane.setViewportView(this.defaultModificationsTable);
        this.searchIndexLabel.setFont(this.searchIndexLabel.getFont().deriveFont(this.searchIndexLabel.getFont().getStyle() | 2));
        this.searchIndexLabel.setHorizontalAlignment(0);
        this.searchIndexLabel.setText(" ");
        this.searchNextButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/next_grey.png")));
        this.searchNextButton.setToolTipText("Next");
        this.searchNextButton.setBorderPainted(false);
        this.searchNextButton.setContentAreaFilled(false);
        this.searchNextButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/next.png")));
        this.searchNextButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsDialog.this.searchNextButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.searchNextButtonMouseExited(evt);
            }
        });
        this.searchNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.searchNextButtonActionPerformed(evt);
            }
        });
        this.searchPreviousButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/previous_grey.png")));
        this.searchPreviousButton.setToolTipText("Previous");
        this.searchPreviousButton.setBorder(null);
        this.searchPreviousButton.setBorderPainted(false);
        this.searchPreviousButton.setContentAreaFilled(false);
        this.searchPreviousButton.setIconTextGap(0);
        this.searchPreviousButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/previous.png")));
        this.searchPreviousButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsDialog.this.searchPreviousButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.searchPreviousButtonMouseExited(evt);
            }
        });
        this.searchPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.searchPreviousButtonActionPerformed(evt);
            }
        });
        this.searchInputTxt.setForeground(new Color(204, 204, 204));
        this.searchInputTxt.setHorizontalAlignment(0);
        this.searchInputTxt.setText("(name or mass)");
        this.searchInputTxt.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.searchInputTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsDialog.this.searchInputTxtMouseReleased(evt);
            }
        });
        this.searchInputTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ModificationsDialog.this.searchInputTxtKeyReleased(evt);
            }
        });
        this.findJLabel.setText("Find:");
        GroupLayout defaultModsPanelLayout = new GroupLayout(this.defaultModsPanel);
        this.defaultModsPanel.setLayout(defaultModsPanelLayout);
        defaultModsPanelLayout.setHorizontalGroup(defaultModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, defaultModsPanelLayout.createSequentialGroup().addContainerGap().addGroup(defaultModsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.defaultModsScrollPane, GroupLayout.Alignment.LEADING, -1, 657, Short.MAX_VALUE).addGroup(defaultModsPanelLayout.createSequentialGroup().addComponent(this.findJLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchInputTxt, -2, 205, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchPreviousButton, -2, 15, -2).addGap(0, 0, 0).addComponent(this.searchNextButton, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchIndexLabel, -2, 97, -2))).addContainerGap()));
        defaultModsPanelLayout.setVerticalGroup(defaultModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, defaultModsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.defaultModsScrollPane, -1, 224, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(defaultModsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.findJLabel).addComponent(this.searchInputTxt, -2, -1, -2).addComponent(this.searchIndexLabel).addComponent(this.searchPreviousButton, -2, 15, -2).addComponent(this.searchNextButton, -2, 15, -2)).addContainerGap()));
        this.modificationsSplitPane.setTopComponent(this.defaultModsPanel);
        this.userModsPanel.setBorder(BorderFactory.createTitledBorder("User Modifications"));
        this.userModsPanel.setOpaque(false);
        this.userModificationsTable.setModel(new UserPTMTable());
        this.userModificationsTable.setSelectionMode(0);
        this.userModificationsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ModificationsDialog.this.userModificationsTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.userModificationsTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ModificationsDialog.this.userModificationsTableMouseReleased(evt);
            }
        });
        this.userModificationsTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ModificationsDialog.this.userModificationsTableMouseMoved(evt);
            }
        });
        this.userModsScrollPane.setViewportView(this.userModificationsTable);
        this.deleteUserPTM.setText("Delete");
        this.deleteUserPTM.setToolTipText("Delete a user defined modification");
        this.deleteUserPTM.setEnabled(false);
        this.deleteUserPTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.deleteUserPTMActionPerformed(evt);
            }
        });
        this.editUserPTM.setText("Edit");
        this.editUserPTM.setToolTipText("Edit a user defined modification");
        this.editUserPTM.setEnabled(false);
        this.editUserPTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.editUserPTMActionPerformed(evt);
            }
        });
        this.addUserPTM.setText("Add");
        this.addUserPTM.setToolTipText("Add a new user defined modification");
        this.addUserPTM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.addUserPTMActionPerformed(evt);
            }
        });
        GroupLayout userModsPanelLayout = new GroupLayout(this.userModsPanel);
        this.userModsPanel.setLayout(userModsPanelLayout);
        userModsPanelLayout.setHorizontalGroup(userModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(userModsPanelLayout.createSequentialGroup().addContainerGap().addGroup(userModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userModsScrollPane, -1, 657, Short.MAX_VALUE).addGroup(userModsPanelLayout.createSequentialGroup().addGap(10, 450, Short.MAX_VALUE).addComponent(this.addUserPTM, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editUserPTM, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteUserPTM, -2, 65, -2))).addContainerGap()));
        userModsPanelLayout.setVerticalGroup(userModsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, userModsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.userModsScrollPane, -1, 114, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(userModsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.deleteUserPTM, -1, -1, Short.MAX_VALUE).addComponent(this.editUserPTM, -1, -1, Short.MAX_VALUE).addComponent(this.addUserPTM, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.modificationsSplitPane.setRightComponent(this.userModsPanel);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.modificationsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.modificationsHelpJButton.setToolTipText("Help");
        this.modificationsHelpJButton.setBorder(null);
        this.modificationsHelpJButton.setBorderPainted(false);
        this.modificationsHelpJButton.setContentAreaFilled(false);
        this.modificationsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ModificationsDialog.this.modificationsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ModificationsDialog.this.modificationsHelpJButtonMouseExited(evt);
            }
        });
        this.modificationsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModificationsDialog.this.modificationsHelpJButtonActionPerformed(evt);
            }
        });
        GroupLayout modificationsEditorPanelLayout = new GroupLayout(this.modificationsEditorPanel);
        this.modificationsEditorPanel.setLayout(modificationsEditorPanelLayout);
        modificationsEditorPanelLayout.setHorizontalGroup(modificationsEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationsEditorPanelLayout.createSequentialGroup().addContainerGap().addGroup(modificationsEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationsSplitPane, -1, 689, Short.MAX_VALUE).addGroup(modificationsEditorPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.modificationsHelpJButton, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton))).addContainerGap()));
        modificationsEditorPanelLayout.setVerticalGroup(modificationsEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(modificationsEditorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.modificationsSplitPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(modificationsEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.okButton).addComponent(this.modificationsHelpJButton, -2, 23, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 709, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.modificationsEditorPanel, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 534, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.modificationsEditorPanel, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0))));
        this.pack();
    }

    private void defaultModificationsTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.defaultModificationsTable.setRowSelectionInterval(this.defaultModificationsTable.rowAtPoint(evt.getPoint()), this.defaultModificationsTable.rowAtPoint(evt.getPoint()));
            this.defaultPtmPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        } else if (evt.getClickCount() == 2 && this.defaultModificationsTable.getSelectedRow() != -1) {
            String ptmName = (String)this.defaultModificationsTable.getValueAt(this.defaultModificationsTable.getSelectedRow(), this.defaultModificationsTable.getColumn("Name").getModelIndex());
            PTM ptm = this.ptmFactory.getPTM(ptmName);
            new PtmDialog(this, (PtmDialogParent)this, this.ptmToPrideMap, ptm, false);
        }
    }

    private void defaultModificationsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void defaultModificationsTableMouseReleased(MouseEvent evt) {
        int row = this.defaultModificationsTable.rowAtPoint(evt.getPoint());
        int column = this.defaultModificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.defaultModificationsTable.getColumn("CV").getModelIndex() && column == this.defaultModificationsTable.getColumn("CV").getModelIndex() && evt.getButton() == 1 && ((String)this.defaultModificationsTable.getValueAt(row, column)).lastIndexOf("<html>") != -1) {
            String link = (String)this.defaultModificationsTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void defaultModificationsTableMouseMoved(MouseEvent evt) {
        int row = this.defaultModificationsTable.rowAtPoint(evt.getPoint());
        int column = this.defaultModificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.defaultModificationsTable.getColumn("CV").getModelIndex() && this.defaultModificationsTable.getValueAt(row, column) != null) {
                String tempValue = (String)this.defaultModificationsTable.getValueAt(row, column);
                if (tempValue.lastIndexOf("<html>") != -1) {
                    this.setCursor(new Cursor(12));
                } else {
                    this.setCursor(new Cursor(0));
                }
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void searchNextButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void searchNextButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchNextButtonActionPerformed(ActionEvent evt) {
        this.searchCurrentSelection = this.searchCurrentSelection == this.searchPossibilities.size() - 1 ? 0 : ++this.searchCurrentSelection;
        this.updatePtmSelection();
    }

    private void searchPreviousButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void searchPreviousButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchPreviousButtonActionPerformed(ActionEvent evt) {
        this.searchCurrentSelection = this.searchCurrentSelection == 0 ? this.searchPossibilities.size() - 1 : --this.searchCurrentSelection;
        this.updatePtmSelection();
    }

    private void searchInputTxtMouseReleased(MouseEvent evt) {
        if (this.searchInputTxt.getText().equals("(name or mass)")) {
            this.searchInputTxt.selectAll();
        }
    }

    private void searchInputTxtKeyReleased(KeyEvent evt) {
        if (!this.searchInputTxt.getText().equalsIgnoreCase("(name or mass)")) {
            this.searchInputTxt.setForeground(Color.black);
        } else {
            this.searchInputTxt.setForeground(new Color(204, 204, 204));
        }
        if (evt.getKeyCode() == 39 && this.searchNextButton.isEnabled()) {
            this.searchNextButtonActionPerformed(null);
        } else if (evt.getKeyCode() == 37 & this.searchPreviousButton.isEnabled()) {
            this.searchPreviousButtonActionPerformed(null);
        } else {
            ArrayList<Integer> toAdd = new ArrayList<Integer>();
            this.searchPossibilities.clear();
            this.searchCurrentSelection = 0;
            String input = this.searchInputTxt.getText().trim().toLowerCase();
            if (!input.equals("")) {
                for (int row = 0; row < this.ptmFactory.getDefaultModifications().size(); ++row) {
                    String ptmName = this.ptmFactory.getDefaultModifications().get(row);
                    String mass = this.ptmFactory.getPTM(ptmName).getMass() + "";
                    if (mass.startsWith(input)) {
                        this.searchPossibilities.add(row);
                        continue;
                    }
                    if (!ptmName.contains(input)) continue;
                    toAdd.add(row);
                }
                this.searchPossibilities.addAll(toAdd);
            }
        }
        if (this.searchPossibilities.size() > 1) {
            this.searchPreviousButton.setEnabled(true);
            this.searchNextButton.setEnabled(true);
            this.searchIndexLabel.setForeground(Color.BLACK);
            this.updatePtmSelection();
        } else if (this.searchPossibilities.size() == 1) {
            this.searchPreviousButton.setEnabled(false);
            this.searchNextButton.setEnabled(false);
            this.searchIndexLabel.setForeground(Color.BLACK);
            this.updatePtmSelection();
        } else {
            this.searchPreviousButton.setEnabled(false);
            this.searchNextButton.setEnabled(false);
            this.searchIndexLabel.setForeground(Color.RED);
            this.searchIndexLabel.setText("(no match)");
        }
    }

    private void userModificationsTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3) {
            this.userModificationsTable.setRowSelectionInterval(this.userModificationsTable.rowAtPoint(evt.getPoint()), this.userModificationsTable.rowAtPoint(evt.getPoint()));
            this.editUserPTM.setEnabled(true);
            this.deleteUserPTM.setEnabled(true);
            this.userPtmPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        } else if (evt.getClickCount() == 2 && this.userModificationsTable.getSelectedRow() != -1) {
            String ptmName = (String)this.userModificationsTable.getValueAt(this.userModificationsTable.getSelectedRow(), this.userModificationsTable.getColumn("Name").getModelIndex());
            PTM ptm = this.ptmFactory.getPTM(ptmName);
            new PtmDialog(this, (PtmDialogParent)this, this.ptmToPrideMap, ptm, true);
        }
    }

    private void userModificationsTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void userModificationsTableMouseReleased(MouseEvent evt) {
        this.editUserPTM.setEnabled(this.userModificationsTable.getSelectedColumnCount() > 0);
        this.deleteUserPTM.setEnabled(this.userModificationsTable.getSelectedColumnCount() > 0);
        int row = this.userModificationsTable.rowAtPoint(evt.getPoint());
        int column = this.userModificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column == this.userModificationsTable.getColumn("CV").getModelIndex() && column == this.userModificationsTable.getColumn("CV").getModelIndex() && evt.getButton() == 1 && ((String)this.userModificationsTable.getValueAt(row, column)).lastIndexOf("<html>") != -1) {
            String link = (String)this.userModificationsTable.getValueAt(row, column);
            link = link.substring(link.indexOf("\"") + 1);
            link = link.substring(0, link.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL(link);
            this.setCursor(new Cursor(0));
        }
    }

    private void userModificationsTableMouseMoved(MouseEvent evt) {
        int row = this.userModificationsTable.rowAtPoint(evt.getPoint());
        int column = this.userModificationsTable.columnAtPoint(evt.getPoint());
        if (row != -1) {
            if (column == this.userModificationsTable.getColumn("CV").getModelIndex() && this.userModificationsTable.getValueAt(row, column) != null) {
                String tempValue = (String)this.userModificationsTable.getValueAt(row, column);
                if (tempValue.lastIndexOf("<html>") != -1) {
                    this.setCursor(new Cursor(12));
                } else {
                    this.setCursor(new Cursor(0));
                }
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    private void deleteUserPTMActionPerformed(ActionEvent evt) {
        int row = this.userModificationsTable.getSelectedRow();
        String ptmName = (String)this.userModificationsTable.getValueAt(row, this.userModificationsTable.getColumn("Name").getModelIndex());
        int value = JOptionPane.showConfirmDialog(this, "Are you sure that you want to delete '" + ptmName + "'?", "Delete Modification?", 0);
        if (value == 0) {
            this.ptmFactory.removeUserPtm(ptmName);
            this.updateModifications();
        }
    }

    private void editUserPTMActionPerformed(ActionEvent evt) {
        int row = this.userModificationsTable.getSelectedRow();
        String ptmName = (String)this.userModificationsTable.getValueAt(row, this.userModificationsTable.getColumn("Name").getModelIndex());
        PTM ptm = this.ptmFactory.getPTM(ptmName);
        new PtmDialog(this, (PtmDialogParent)this, this.ptmToPrideMap, ptm, true);
    }

    private void addUserPTMActionPerformed(ActionEvent evt) {
        if (this.ptmFactory.getUserModifications().size() < 30) {
            new PtmDialog(this, (PtmDialogParent)this, this.ptmToPrideMap, null, true);
        } else {
            JOptionPane.showMessageDialog(this, "In order to ensure compatibility with OMSSA, only 30 user modifications can be implemented. Please delete unused modifications.", "Too many modifications", 2);
        }
    }

    private void modificationsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void modificationsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void modificationsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog(this, this.getClass().getResource("/helpFiles/ModificationEditor.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), "Help - Modifications", 500, 10);
        this.setCursor(new Cursor(0));
    }

    private void editDefaultPtmJMenuItemActionPerformed(ActionEvent evt) {
        String ptmName = (String)this.defaultModificationsTable.getValueAt(this.defaultModificationsTable.getSelectedRow(), this.defaultModificationsTable.getColumn("Name").getModelIndex());
        PTM ptm = this.ptmFactory.getPTM(ptmName);
        new PtmDialog(this, (PtmDialogParent)this, this.ptmToPrideMap, ptm, false);
    }

    private void editUserPtmJMenuItemActionPerformed(ActionEvent evt) {
        String ptmName = (String)this.userModificationsTable.getValueAt(this.userModificationsTable.getSelectedRow(), this.userModificationsTable.getColumn("Name").getModelIndex());
        PTM ptm = this.ptmFactory.getPTM(ptmName);
        new PtmDialog(this, (PtmDialogParent)this, this.ptmToPrideMap, ptm, true);
    }

    private void formWindowClosing(WindowEvent evt) {
        try {
            this.ptmFactory.saveFactory();
            PrideObjectsFactory prideObjectsFactory = PrideObjectsFactory.getInstance();
            prideObjectsFactory.setPtmToPrideMap(this.ptmToPrideMap);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving the modification.", "Saving Error", 2);
        }
        catch (ClassNotFoundException ce) {
            JOptionPane.showMessageDialog(this, "An error occurred while saving the modification.", "Saving Error", 2);
        }
        this.ptmDialogParent.updateModifications();
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
    }

    public String getOlsAccessionLink(String modAccession) {
        String accessionNumberWithLink = "<html><a href=\"http://www.ebi.ac.uk/ontology-lookup/?termId=" + modAccession + "\"" + "\"><font color=\"" + this.selectedRowHtmlTagFontColor + "\">" + modAccession + "</font></a></html>";
        return accessionNumberWithLink;
    }

    public String getUniModAccessionLink(String unimodAccession) {
        String accessionNumber = unimodAccession.substring("Unimod:".length());
        String accessionNumberWithLink = "<html><a href=\"http://www.unimod.org/modifications_view.php?editid1=" + accessionNumber + "\"" + "\"><font color=\"" + this.selectedRowHtmlTagFontColor + "\">" + unimodAccession + "</font></a></html>";
        return accessionNumberWithLink;
    }

    @Override
    public void updateModifications() {
        DefaultTableModel dm = (DefaultTableModel)this.defaultModificationsTable.getModel();
        dm.fireTableDataChanged();
        dm = (DefaultTableModel)this.userModificationsTable.getModel();
        dm.fireTableDataChanged();
        this.editUserPTM.setEnabled(this.userModificationsTable.getSelectedColumnCount() > 0);
        this.deleteUserPTM.setEnabled(this.userModificationsTable.getSelectedColumnCount() > 0);
        this.updateMassSparklines();
    }

    public void updatePtmSelection() {
        int row = this.defaultModificationsTable.convertRowIndexToView(this.searchPossibilities.get(this.searchCurrentSelection));
        this.defaultModificationsTable.setRowSelectionInterval(row, row);
        this.searchIndexLabel.setText("(" + (this.searchCurrentSelection + 1) + " of " + this.searchPossibilities.size() + ")");
        this.defaultModificationsTable.scrollRectToVisible(this.defaultModificationsTable.getCellRect(row, 0, false));
    }

    private class UserPTMTable
    extends DefaultTableModel {
        private UserPTMTable() {
        }

        @Override
        public int getRowCount() {
            return ModificationsDialog.this.ptmFactory.getUserModifications().size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Short";
                }
                case 3: {
                    return "Mass";
                }
                case 4: {
                    return "Type";
                }
                case 5: {
                    return "Residues";
                }
                case 6: {
                    return "CV";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String name = ModificationsDialog.this.ptmFactory.getUserModificationsOrdered().get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return name;
                }
                case 2: {
                    return ModificationsDialog.this.ptmFactory.getShortName(name);
                }
                case 3: {
                    return ModificationsDialog.this.ptmFactory.getPTM(name).getMass();
                }
                case 4: {
                    return ModificationsDialog.this.ptmFactory.getPTM(name).getType();
                }
                case 5: {
                    String residues = "";
                    for (Character residue : ModificationsDialog.this.ptmFactory.getPTM(name).getPattern().getAminoAcidsAtTarget()) {
                        if (!residues.equals("")) {
                            residues = residues + ", ";
                        }
                        residues = residues + residue;
                    }
                    return residues;
                }
                case 6: {
                    CvTerm cvTerm = null;
                    if (ModificationsDialog.this.ptmToPrideMap != null) {
                        cvTerm = ModificationsDialog.this.ptmToPrideMap.getCVTerm(name);
                    }
                    if (cvTerm != null) {
                        if (cvTerm.getOntology().equalsIgnoreCase("UNIMOD")) {
                            return ModificationsDialog.this.getUniModAccessionLink(cvTerm.getAccession());
                        }
                        return ModificationsDialog.this.getOlsAccessionLink(cvTerm.getAccession());
                    }
                    cvTerm = PtmToPrideMap.getDefaultCVTerm(name);
                    if (cvTerm == null) break;
                    if (cvTerm.getOntology().equalsIgnoreCase("UNIMOD")) {
                        return ModificationsDialog.this.getUniModAccessionLink(cvTerm.getAccession());
                    }
                    return ModificationsDialog.this.getOlsAccessionLink(cvTerm.getAccession());
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return new Double(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    private class DefaultPTMTable
    extends DefaultTableModel {
        private DefaultPTMTable() {
        }

        @Override
        public int getRowCount() {
            return ModificationsDialog.this.ptmFactory.getDefaultModifications().size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Short";
                }
                case 3: {
                    return "Mass";
                }
                case 4: {
                    return "Type";
                }
                case 5: {
                    return "Residues";
                }
                case 6: {
                    return "CV";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String name = ModificationsDialog.this.ptmFactory.getDefaultModificationsOrdered().get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return name;
                }
                case 2: {
                    return ModificationsDialog.this.ptmFactory.getShortName(name);
                }
                case 3: {
                    return ModificationsDialog.this.ptmFactory.getPTM(name).getMass();
                }
                case 4: {
                    return ModificationsDialog.this.ptmFactory.getPTM(name).getType();
                }
                case 5: {
                    String residues = "";
                    for (Character residue : ModificationsDialog.this.ptmFactory.getPTM(name).getPattern().getAminoAcidsAtTarget()) {
                        if (!residues.equals("")) {
                            residues = residues + ", ";
                        }
                        residues = residues + residue;
                    }
                    return residues;
                }
                case 6: {
                    CvTerm cvTerm = null;
                    if (ModificationsDialog.this.ptmToPrideMap != null) {
                        cvTerm = ModificationsDialog.this.ptmToPrideMap.getCVTerm(name);
                    }
                    if (cvTerm != null) {
                        if (cvTerm.getOntology().equalsIgnoreCase("UNIMOD")) {
                            return ModificationsDialog.this.getUniModAccessionLink(cvTerm.getAccession());
                        }
                        return ModificationsDialog.this.getOlsAccessionLink(cvTerm.getAccession());
                    }
                    cvTerm = PtmToPrideMap.getDefaultCVTerm(name);
                    if (cvTerm == null) break;
                    if (cvTerm.getOntology().equalsIgnoreCase("UNIMOD")) {
                        return ModificationsDialog.this.getUniModAccessionLink(cvTerm.getAccession());
                    }
                    return ModificationsDialog.this.getOlsAccessionLink(cvTerm.getAccession());
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return new Double(0.0).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

