/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.PeptideAssumption;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.identification.SequenceFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.io.identifications.IdfileReader;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.refinementparameters.MsAmandaScore;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.bind.JAXBException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

public class MsAmandaIdfileReader
extends ExperimentObject
implements IdfileReader {
    private String softwareName = "MS Amanda";
    private String softwareVersion = null;
    private File msAmandaCsvFile;
    private HashMap<String, LinkedList<Peptide>> peptideMap;
    private int peptideMapKeyLength;

    public MsAmandaIdfileReader() {
    }

    public MsAmandaIdfileReader(File msAmandaCsvFile) throws FileNotFoundException, IOException {
        this(msAmandaCsvFile, null);
    }

    public MsAmandaIdfileReader(File msAmandaCsvFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        this.msAmandaCsvFile = msAmandaCsvFile;
        this.extractVersionNumber();
    }

    private void extractVersionNumber() throws IOException {
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(this.msAmandaCsvFile, "r", 102400);
        String versionNumberString = bufferedRandomAccessFile.readLine();
        if (versionNumberString.toLowerCase().startsWith("#version: ")) {
            this.softwareVersion = versionNumberString.substring("#version: ".length()).trim();
        }
        bufferedRandomAccessFile.close();
    }

    @Override
    public String getExtension() {
        return ".csv";
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        return this.getAllSpectrumMatches(waitingHandler, searchParameters, null, true);
    }

    @Override
    public LinkedList<SpectrumMatch> getAllSpectrumMatches(WaitingHandler waitingHandler, SearchParameters searchParameters, SequenceMatchingPreferences sequenceMatchingPreferences, boolean expandAaCombinations) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, JAXBException {
        String line;
        if (sequenceMatchingPreferences != null) {
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            this.peptideMapKeyLength = sequenceFactory.getDefaultProteinTree().getInitialTagSize();
            this.peptideMap = new HashMap(1024);
        }
        LinkedList<SpectrumMatch> result = new LinkedList<SpectrumMatch>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(this.msAmandaCsvFile, "r", 102400);
        if (waitingHandler != null) {
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(100);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        String versionNumberString = bufferedRandomAccessFile.readLine();
        String headerString = versionNumberString.toLowerCase().startsWith("#version: ") ? bufferedRandomAccessFile.readLine() : versionNumberString;
        String[] headers = headerString.split("\t");
        int scanNumberIndex = -1;
        int titleIndex = -1;
        int sequenceIndex = -1;
        int modificationsIndex = -1;
        int proteinAccessionsIndex = -1;
        int amandaScoreIndex = -1;
        int rankIndex = -1;
        int mzIndex = -1;
        int chargeIndex = -1;
        int rtIndex = -1;
        int filenameIndex = -1;
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            if (header.equalsIgnoreCase("Scan Number")) {
                scanNumberIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Title")) {
                titleIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Sequence")) {
                sequenceIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Modifications")) {
                modificationsIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Protein Accessions")) {
                proteinAccessionsIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Amanda Score")) {
                amandaScoreIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Rank")) {
                rankIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("m/z")) {
                mzIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("Charge")) {
                chargeIndex = i;
                continue;
            }
            if (header.equalsIgnoreCase("RT")) {
                rtIndex = i;
                continue;
            }
            if (!header.equalsIgnoreCase("Filename")) continue;
            filenameIndex = i;
        }
        if (scanNumberIndex == -1 || titleIndex == -1 || sequenceIndex == -1 || modificationsIndex == -1 || proteinAccessionsIndex == -1 || amandaScoreIndex == -1 || rankIndex == -1 || mzIndex == -1 || chargeIndex == -1 || filenameIndex == -1) {
            throw new IllegalArgumentException("Mandatory columns are missing in the MS Amanda csv file. Please check the file!");
        }
        String currentSpectrumTitle = null;
        SpectrumMatch currentMatch = null;
        while ((line = bufferedRandomAccessFile.readLine()) != null) {
            String[] elements = line.split("\t");
            if (line.trim().isEmpty()) continue;
            String spectrumTitle = elements[titleIndex];
            String peptideSequence = elements[sequenceIndex].toUpperCase();
            String modifications = elements[modificationsIndex].trim();
            String scoreAsText = elements[amandaScoreIndex];
            double msAmandaScore = Util.readDoubleAsString(scoreAsText);
            double msAmandaEValue = Math.pow(10.0, -msAmandaScore);
            int rank = Integer.valueOf(elements[rankIndex]);
            int charge = Integer.valueOf(elements[chargeIndex]);
            String fileName = elements[filenameIndex];
            if (currentMatch == null || currentSpectrumTitle != null && !currentSpectrumTitle.equalsIgnoreCase(spectrumTitle)) {
                if (currentMatch != null) {
                    result.add(currentMatch);
                }
                currentMatch = new SpectrumMatch(Spectrum.getSpectrumKey(fileName, spectrumTitle));
                currentSpectrumTitle = spectrumTitle;
            }
            ArrayList<ModificationMatch> utilitiesModifications = new ArrayList<ModificationMatch>();
            if (!modifications.isEmpty()) {
                String[] ptms;
                for (String ptm : ptms = modifications.split(";")) {
                    try {
                        String location = ptm.substring(0, ptm.indexOf("("));
                        int modSite = location.equalsIgnoreCase("N-Term") ? 1 : (location.equalsIgnoreCase("C-Term") ? peptideSequence.length() + 1 : Integer.parseInt(ptm.substring(1, ptm.indexOf("("))));
                        String rest = ptm.substring(ptm.indexOf("(") + 1, ptm.length() - 1).toLowerCase();
                        String[] details = rest.split("\\|");
                        String ptmName = details[0];
                        String ptmMassAsString = details[1];
                        double ptmMass = Util.readDoubleAsString(ptmMassAsString);
                        String ptmFixedStatus = details[2];
                        if (!ptmFixedStatus.equalsIgnoreCase("variable")) continue;
                        utilitiesModifications.add(new ModificationMatch(ptmMass + "@" + peptideSequence.charAt(modSite - 1), true, modSite));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error parsing ptm: " + ptm + "!");
                    }
                }
            }
            Peptide peptide = new Peptide(peptideSequence, utilitiesModifications);
            if (sequenceMatchingPreferences != null) {
                String subSequence = peptideSequence.substring(0, this.peptideMapKeyLength);
                LinkedList<Peptide> peptidesForTag = this.peptideMap.get(subSequence = AminoAcid.getMatchingSequence(subSequence, sequenceMatchingPreferences));
                if (peptidesForTag == null) {
                    peptidesForTag = new LinkedList();
                    this.peptideMap.put(subSequence, peptidesForTag);
                }
                peptidesForTag.add(peptide);
            }
            Charge peptideCharge = new Charge(1, charge);
            PeptideAssumption peptideAssumption = new PeptideAssumption(peptide, rank, Advocate.msAmanda.getIndex(), peptideCharge, msAmandaEValue, Util.getFileName(this.msAmandaCsvFile));
            MsAmandaScore scoreParam = new MsAmandaScore(msAmandaScore);
            if (expandAaCombinations && AminoAcidSequence.hasCombination(peptideSequence)) {
                ArrayList<ModificationMatch> modificationMatches = peptide.getModificationMatches();
                for (StringBuilder expandedSequence : AminoAcidSequence.getCombinations(peptide.getSequence())) {
                    Peptide newPeptide = new Peptide(expandedSequence.toString(), new ArrayList<ModificationMatch>(modificationMatches.size()));
                    for (ModificationMatch modificationMatch : modificationMatches) {
                        newPeptide.addModificationMatch(new ModificationMatch(modificationMatch.getTheoreticPtm(), modificationMatch.isVariable(), modificationMatch.getModificationSite()));
                    }
                    PeptideAssumption newAssumption = new PeptideAssumption(newPeptide, peptideAssumption.getRank(), peptideAssumption.getAdvocate(), peptideAssumption.getIdentificationCharge(), peptideAssumption.getScore(), peptideAssumption.getIdentificationFile());
                    peptideAssumption.addUrParam(scoreParam);
                    currentMatch.addHit(Advocate.msAmanda.getIndex(), newAssumption, false);
                }
            } else {
                peptideAssumption.addUrParam(scoreParam);
                currentMatch.addHit(Advocate.msAmanda.getIndex(), peptideAssumption, false);
            }
            if (waitingHandler == null || progressUnit == 0L) continue;
            waitingHandler.setSecondaryProgressCounter((int)(bufferedRandomAccessFile.getFilePointer() / progressUnit));
            if (!waitingHandler.isRunCanceled()) continue;
            bufferedRandomAccessFile.close();
            break;
        }
        if (currentMatch != null) {
            result.add(currentMatch);
        }
        bufferedRandomAccessFile.close();
        return result;
    }

    @Override
    public void close() throws IOException {
        this.msAmandaCsvFile = null;
    }

    @Override
    public HashMap<String, ArrayList<String>> getSoftwareVersions() {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(this.softwareVersion);
        result.put(this.softwareName, versions);
        return result;
    }

    @Override
    public HashMap<String, LinkedList<Peptide>> getPeptidesMap() {
        return this.peptideMap;
    }

    @Override
    public HashMap<String, LinkedList<SpectrumMatch>> getTagsMap() {
        return new HashMap<String, LinkedList<SpectrumMatch>>();
    }

    @Override
    public void clearTagsMap() {
    }

    @Override
    public void clearPeptidesMap() {
        if (this.peptideMap != null) {
            this.peptideMap.clear();
        }
    }
}

