/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches_iterators;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.personalization.UrParameter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

public class PsmIterator {
    private final Identification identification;
    private final ArrayList<String> spectrumKeys;
    private final ArrayList<UrParameter> psmParameters;
    private final boolean loadAssumptions;
    private final int nMatches;
    private int index = -1;
    public final int defaultBatchSize = 1000;
    private int batchSize = 1000;
    private int loadingIndex = -1;
    private boolean buffering = false;
    public final double defaultMargin = 0.1;
    private double margin = 0.1;

    public PsmIterator(String spectrumFile, ArrayList<String> spectrumKeys, Identification identification, ArrayList<UrParameter> psmParameters, boolean loadAssumptions) {
        this.identification = identification;
        this.spectrumKeys = spectrumKeys == null ? identification.getSpectrumIdentification(spectrumFile) : spectrumKeys;
        this.nMatches = this.spectrumKeys.size();
        this.psmParameters = psmParameters;
        this.loadAssumptions = loadAssumptions;
    }

    public PsmIterator(String spectrumFile, ArrayList<String> spectrumKeys, Identification identification, boolean loadAssumptions) {
        this(spectrumFile, spectrumKeys, identification, null, loadAssumptions);
    }

    public PsmIterator(String spectrumFile, Identification identification, ArrayList<UrParameter> psmParameters, boolean loadAssumptions) {
        this(spectrumFile, null, identification, psmParameters, loadAssumptions);
    }

    public PsmIterator(String spectrumFile, Identification identification, boolean loadAssumptions) {
        this(spectrumFile, identification, null, loadAssumptions);
    }

    public boolean hasNext() {
        return this.index < this.nMatches - 1;
    }

    public SpectrumMatch next() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        int threadIndex = this.incrementIndex();
        if (threadIndex < this.nMatches) {
            this.checkBuffer();
            String key = this.spectrumKeys.get(threadIndex);
            SpectrumMatch match = this.identification.getSpectrumMatch(key);
            return match;
        }
        return null;
    }

    private void checkBuffer() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (!this.buffering) {
            int trigger = this.loadingIndex - (int)(this.margin * (double)this.batchSize);
            if (this.index >= trigger) {
                int newLoadingIndex = Math.min(this.loadingIndex + this.batchSize, this.nMatches - 1);
                ArrayList<String> keysInBatch = new ArrayList<String>(this.spectrumKeys.subList(this.loadingIndex + 1, newLoadingIndex + 1));
                this.identification.loadSpectrumMatches(keysInBatch, null);
                if (this.psmParameters != null) {
                    for (UrParameter urParameter : this.psmParameters) {
                        if (urParameter == null) {
                            throw new IllegalArgumentException("Parameter to for batch load is null.");
                        }
                        this.identification.loadSpectrumMatchParameters(keysInBatch, urParameter, null);
                    }
                }
                if (this.loadAssumptions) {
                    this.identification.loadAssumptions(keysInBatch, null);
                }
                this.loadingIndex = newLoadingIndex;
                trigger += (int)(this.margin * (double)this.batchSize / 2.0);
                if (this.index < (trigger = Math.max(0, trigger))) {
                    if (this.batchSize > 1000) {
                        this.batchSize = Math.max(1000, 0 * this.batchSize);
                    } else if (this.margin > 0.1) {
                        this.margin = Math.max(0.1, 0.9 * this.margin);
                    }
                }
                this.buffering = false;
            }
        } else if (this.index == this.loadingIndex) {
            this.margin *= 1.1;
            if (this.margin >= 0.25) {
                this.batchSize = (int)((double)this.batchSize * 1.1);
                this.margin = 0.1;
            }
        }
    }

    private synchronized int incrementIndex() {
        int localIndex = ++this.index;
        return localIndex;
    }
}

