/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PrecursorIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.personalization.ExperimentObject;

public abstract class SpectrumIdentificationAssumption
extends ExperimentObject {
    static final long serialVersionUID = 496273793273328259L;
    protected int rank;
    protected int advocate;
    protected Charge identificationCharge;
    protected double score;
    protected String identificationFile;

    public int getRank() {
        return this.rank;
    }

    public void setRank(int aRank) {
        this.rank = aRank;
    }

    public int getAdvocate() {
        return this.advocate;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public String getIdentificationFile() {
        return this.identificationFile;
    }

    public Charge getIdentificationCharge() {
        return this.identificationCharge;
    }

    public void setIdentificationCharge(Charge identificationCharge) {
        this.identificationCharge = identificationCharge;
    }

    public abstract double getTheoreticMass();

    public double getTheoreticMz() {
        return (this.getTheoreticMass() + ElementaryIon.proton.getTheoreticMass() * (double)(this.identificationCharge.value - 1)) / (double)this.identificationCharge.value;
    }

    public double getDeltaMass(double measuredMZ, boolean ppm, boolean subtractIsotope) {
        return this.getPrecursorMatch(new Peak(measuredMZ, 0.0, 0.0)).getError(ppm, subtractIsotope);
    }

    public double getDeltaMass(double measuredMZ, boolean ppm) {
        return this.getPrecursorMatch(new Peak(measuredMZ, 0.0, 0.0)).getError(ppm, true);
    }

    public int getIsotopeNumber(double measuredMZ) {
        return this.getPrecursorMatch(new Peak(measuredMZ, 0.0, 0.0)).getIsotopeNumber();
    }

    public IonMatch getPrecursorMatch(Peak precursorPeak) {
        return new IonMatch(precursorPeak, new PrecursorIon(this.getTheoreticMass()), this.getIdentificationCharge());
    }
}

