/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.db.ObjectsCache;
import com.compomics.util.db.ObjectsDB;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class IdentificationDB
implements Serializable {
    static final long serialVersionUID = 691986038787590646L;
    public String dbName;
    private String proteinTableName = "proteins";
    private String proteinParametersTableSuffix = "_protein_parameters";
    private String peptideTableName = "peptides";
    private String peptideParametersTableSuffix = "_peptide_parameters";
    private String psmTableSuffix = "_psms";
    private String assumptionsTableSuffix = "_assumptions";
    private String psmParametersTableSuffix = "_psm_parameters";
    private String parametersSuffix = "_parameters";
    private ArrayList<String> assumptionsTables = new ArrayList();
    private ArrayList<String> psmTables = new ArrayList();
    private ArrayList<String> psmParametersTables = new ArrayList();
    private ArrayList<String> peptideParametersTables = new ArrayList();
    private ArrayList<String> proteinParametersTables = new ArrayList();
    private ArrayList<String> matchParametersTables = new ArrayList();
    private ObjectsDB objectsDB;

    public IdentificationDB(String folder, String name, boolean deleteOldDatabase, ObjectsCache objectCache) throws SQLException {
        this.dbName = name;
        this.objectsDB = new ObjectsDB(folder, this.dbName, deleteOldDatabase, objectCache);
        if (deleteOldDatabase) {
            this.objectsDB.addTable(this.proteinTableName);
            this.objectsDB.addTable(this.peptideTableName);
        }
    }

    public boolean spectrumMatchLoaded(String spectrumKey) throws SQLException {
        String tableName = this.getSpectrumMatchTable(spectrumKey);
        return this.objectsDB.inDB(tableName, spectrumKey, true);
    }

    public boolean peptideMatchLoaded(String peptideKey) throws SQLException {
        return this.objectsDB.inDB(this.peptideTableName, peptideKey, true);
    }

    public boolean proteinMatchLoaded(String proteinKey) throws SQLException {
        return this.objectsDB.inDB(this.proteinTableName, proteinKey, true);
    }

    public void updateProteinMatch(ProteinMatch proteinMatch) throws SQLException, IOException {
        this.objectsDB.updateObject(this.proteinTableName, proteinMatch.getKey(), proteinMatch);
    }

    public void updatePeptideMatch(PeptideMatch peptideMatch) throws SQLException, IOException {
        this.objectsDB.updateObject(this.peptideTableName, peptideMatch.getKey(), peptideMatch);
    }

    public void updateSpectrumMatch(SpectrumMatch spectrumMatch) throws SQLException, IOException {
        String key = spectrumMatch.getKey();
        String tableName = this.getSpectrumMatchTable(key);
        this.objectsDB.updateObject(tableName, key, spectrumMatch);
    }

    public void updateAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptionsMap) throws SQLException, IOException {
        String tableName = this.getAssumptionTable(spectrumKey);
        this.objectsDB.updateObject(tableName, spectrumKey, assumptionsMap);
    }

    public void updateMatch(IdentificationMatch match) throws SQLException, IOException {
        switch (match.getType()) {
            case Spectrum: {
                this.updateSpectrumMatch((SpectrumMatch)match);
                return;
            }
            case Peptide: {
                this.updatePeptideMatch((PeptideMatch)match);
                return;
            }
            case Protein: {
                this.updateProteinMatch((ProteinMatch)match);
            }
        }
    }

    public void updateProteinParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        String tableName = this.getProteinParameterTable(urParameter);
        this.objectsDB.updateObject(tableName, key, urParameter);
    }

    public void updatePeptideParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        String tableName = this.getPeptideParameterTable(urParameter);
        this.objectsDB.updateObject(tableName, key, urParameter);
    }

    public void updateSpectrumParameter(String key, UrParameter urParameter) throws SQLException, IOException {
        String tableName = this.getSpectrumParameterTable(key, urParameter);
        this.objectsDB.updateObject(tableName, key, urParameter);
    }

    public void removeProteinMatch(String key) throws SQLException, IOException {
        this.objectsDB.deleteObject(this.proteinTableName, key);
        for (String proteinParameterTable : this.proteinParametersTables) {
            this.objectsDB.deleteObject(proteinParameterTable, key);
        }
    }

    public void removePeptideMatch(String key) throws SQLException, IOException {
        this.objectsDB.deleteObject(this.peptideTableName, key);
        for (String peptideParameterTable : this.peptideParametersTables) {
            this.objectsDB.deleteObject(peptideParameterTable, key);
        }
    }

    public void removeSpectrumMatch(String key) throws SQLException, IOException {
        for (String psmTable : this.psmTables) {
            this.objectsDB.deleteObject(psmTable, key);
        }
        for (String psmParameterTable : this.psmParametersTables) {
            this.objectsDB.deleteObject(psmParameterTable, key);
        }
    }

    public void removeAssumptions(String key) throws SQLException, IOException {
        for (String psmTable : this.assumptionsTables) {
            this.objectsDB.deleteObject(psmTable, key);
        }
    }

    public void removeMatch(String key) throws SQLException, IOException {
        this.removeProteinMatch(key);
        this.removePeptideMatch(key);
        this.removeSpectrumMatch(key);
    }

    public ArrayList<String> getPeptideParametersTables() {
        return this.peptideParametersTables;
    }

    public HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> getAssumptions(String key, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getAssumptionTable(key);
        this.checkTable(this.assumptionsTables, tableName);
        return (HashMap)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addAssumptions(String spectrumKey, HashMap<Integer, HashMap<Double, ArrayList<SpectrumIdentificationAssumption>>> assumptions) throws SQLException, IOException, InterruptedException {
        String tableName = this.getAssumptionTable(spectrumKey);
        this.checkTable(this.assumptionsTables, tableName);
        this.objectsDB.insertObject(tableName, spectrumKey, assumptions, true);
    }

    public SpectrumMatch getSpectrumMatch(String key, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getSpectrumMatchTable(key);
        this.checkTable(this.psmTables, tableName);
        return (SpectrumMatch)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addSpectrumMatch(SpectrumMatch spectrumMatch) throws SQLException, IOException, InterruptedException {
        String key = spectrumMatch.getKey();
        String tableName = this.getSpectrumMatchTable(key);
        this.checkTable(this.psmTables, tableName);
        this.objectsDB.insertObject(tableName, key, spectrumMatch, true);
    }

    public PeptideMatch getPeptideMatch(String key, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return (PeptideMatch)this.objectsDB.retrieveObject(this.peptideTableName, key, useDB);
    }

    public void addPeptideMatch(PeptideMatch peptideMatch) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(this.peptideTableName, peptideMatch.getKey(), peptideMatch, true);
    }

    public ProteinMatch getProteinMatch(String key, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return (ProteinMatch)this.objectsDB.retrieveObject(this.proteinTableName, key, useDB);
    }

    public void addProteinMatch(ProteinMatch proteinMatch) throws SQLException, IOException, InterruptedException {
        this.objectsDB.insertObject(this.proteinTableName, proteinMatch.getKey(), proteinMatch, true);
    }

    public void addMatch(IdentificationMatch match) throws SQLException, IOException, InterruptedException {
        switch (match.getType()) {
            case Spectrum: {
                this.addSpectrumMatch((SpectrumMatch)match);
                return;
            }
            case Peptide: {
                this.addPeptideMatch((PeptideMatch)match);
                return;
            }
            case Protein: {
                this.addProteinMatch((ProteinMatch)match);
            }
        }
    }

    public void loadAssumptions(String fileName, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String testKey = Spectrum.getSpectrumKey(fileName, "test");
        String tableName = this.getAssumptionTable(testKey);
        this.objectsDB.loadObjects(tableName, waitingHandler);
    }

    public void loadAssumptions(ArrayList<String> spectrumKeys, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(2 * spectrumKeys.size());
        }
        HashMap sortedKeys = new HashMap();
        for (String spectrumKey : spectrumKeys) {
            String tableName = this.getAssumptionTable(spectrumKey);
            if (!sortedKeys.containsKey(tableName)) {
                sortedKeys.put(tableName, new ArrayList());
            }
            ((ArrayList)sortedKeys.get(tableName)).add(spectrumKey);
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        for (String tableName : sortedKeys.keySet()) {
            this.objectsDB.loadObjects(tableName, (ArrayList)sortedKeys.get(tableName), waitingHandler);
        }
    }

    public void loadSpectrumMatches(String fileName, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String testKey = Spectrum.getSpectrumKey(fileName, "test");
        String tableName = this.getSpectrumMatchTable(testKey);
        this.objectsDB.loadObjects(tableName, waitingHandler);
    }

    public void loadSpectrumMatches(ArrayList<String> spectrumKeys, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(2 * spectrumKeys.size());
        }
        HashMap sortedKeys = new HashMap();
        for (String spectrumKey : spectrumKeys) {
            String tableName = this.getSpectrumMatchTable(spectrumKey);
            if (!sortedKeys.containsKey(tableName)) {
                sortedKeys.put(tableName, new ArrayList());
            }
            ((ArrayList)sortedKeys.get(tableName)).add(spectrumKey);
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        for (String tableName : sortedKeys.keySet()) {
            this.objectsDB.loadObjects(tableName, (ArrayList)sortedKeys.get(tableName), waitingHandler);
        }
    }

    public void loadSpectrumMatchParameters(String fileName, UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String testKey = Spectrum.getSpectrumKey(fileName, "test");
        String tableName = this.getSpectrumParameterTable(testKey, urParameter);
        this.objectsDB.loadObjects(tableName, waitingHandler);
    }

    public void loadSpectrumMatchParameters(ArrayList<String> spectrumKeys, UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(2 * spectrumKeys.size());
        }
        HashMap sortedKeys = new HashMap();
        for (String spectrumKey : spectrumKeys) {
            String tableName = this.getSpectrumParameterTable(spectrumKey, urParameter);
            if (!sortedKeys.containsKey(tableName)) {
                sortedKeys.put(tableName, new ArrayList());
            }
            ((ArrayList)sortedKeys.get(tableName)).add(spectrumKey);
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressCounter();
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        for (String tableName : sortedKeys.keySet()) {
            this.objectsDB.loadObjects(tableName, (ArrayList)sortedKeys.get(tableName), waitingHandler);
        }
    }

    public void loadPeptideMatches(WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException, InterruptedException {
        this.objectsDB.loadObjects(this.peptideTableName, waitingHandler);
    }

    public void loadPeptideMatches(ArrayList<String> peptideKeys, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(peptideKeys.size());
        }
        this.objectsDB.loadObjects(this.peptideTableName, peptideKeys, waitingHandler);
    }

    public void loadPeptideMatchParameters(UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getPeptideParameterTable(urParameter);
        this.objectsDB.loadObjects(tableName, waitingHandler);
    }

    public void loadPeptideMatchParameters(ArrayList<String> peptideKeys, UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(peptideKeys.size());
        }
        String tableName = this.getPeptideParameterTable(urParameter);
        this.objectsDB.loadObjects(tableName, peptideKeys, waitingHandler);
    }

    public void loadProteinMatches(WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        this.objectsDB.loadObjects(this.proteinTableName, waitingHandler);
    }

    public void loadProteinMatches(ArrayList<String> proteinKeys, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(proteinKeys.size());
        }
        this.objectsDB.loadObjects(this.proteinTableName, proteinKeys, waitingHandler);
    }

    public void loadProteinMatchParameters(UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getProteinParameterTable(urParameter);
        this.objectsDB.loadObjects(tableName, waitingHandler);
    }

    public void loadProteinMatchParameters(ArrayList<String> proteinKeys, UrParameter urParameter, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
            waitingHandler.setMaxSecondaryProgressCounter(proteinKeys.size());
        }
        String tableName = this.getProteinParameterTable(urParameter);
        this.objectsDB.loadObjects(tableName, proteinKeys, waitingHandler);
    }

    public UrParameter getSpectrumMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getSpectrumParameterTable(key, urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addSpectrumMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getSpectrumParameterTable(key, urParameter);
        this.checkTable(this.psmParametersTables, tableName);
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public UrParameter getPeptideMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getPeptideParameterTable(urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addPeptideMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getPeptideParameterTable(urParameter);
        this.checkTable(this.peptideParametersTables, tableName);
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public UrParameter getProteinMatchParameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getProteinParameterTable(urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addProteinMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getProteinParameterTable(urParameter);
        this.checkTable(this.proteinParametersTables, tableName);
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public UrParameter getMatchPArameter(String key, UrParameter urParameter, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        String tableName = this.getParameterTable(urParameter);
        return (UrParameter)this.objectsDB.retrieveObject(tableName, key, useDB);
    }

    public void addMatchParameter(String key, UrParameter urParameter) throws SQLException, IOException, InterruptedException {
        String tableName = this.getParameterTable(urParameter);
        if (!this.matchParametersTables.contains(tableName)) {
            this.checkTable(this.matchParametersTables, tableName);
            this.matchParametersTables.add(tableName);
        }
        this.objectsDB.insertObject(tableName, key, urParameter, true);
    }

    public synchronized void checkTable(ArrayList<String> tableList, String tableName) throws SQLException, IOException, InterruptedException {
        if (!tableList.contains(tableName)) {
            this.objectsDB.addTable(tableName);
            tableList.add(tableName);
        }
    }

    public Object getObject(String table, String objectKey, boolean useDB) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        return this.objectsDB.retrieveObject(table, objectKey, true);
    }

    public String getAssumptionTable(String spectrumKey) {
        String tableName = Spectrum.getSpectrumFile(spectrumKey) + this.assumptionsTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getSpectrumMatchTable(String spectrumKey) {
        String tableName = Spectrum.getSpectrumFile(spectrumKey) + this.psmTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getSpectrumParameterTable(String spectrumKey, UrParameter urParameter) {
        String fileName = Spectrum.getSpectrumFile(spectrumKey);
        String tableName = ExperimentObject.getParameterKey(urParameter) + "_" + fileName + this.psmParametersTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getPeptideParameterTable(UrParameter urParameter) {
        String tableName = ExperimentObject.getParameterKey(urParameter) + this.peptideParametersTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getProteinParameterTable(UrParameter urParameter) {
        String tableName = ExperimentObject.getParameterKey(urParameter) + this.proteinParametersTableSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public String getParameterTable(UrParameter urParameter) {
        String tableName = ExperimentObject.getParameterKey(urParameter) + this.parametersSuffix;
        tableName = this.objectsDB.correctTableName(tableName);
        return tableName;
    }

    public void close() throws SQLException {
        this.objectsDB.close();
    }
}

