/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Enzyme
extends ExperimentObject {
    static final long serialVersionUID = -1852087173903613377L;
    private int id;
    private String name;
    private ArrayList<Character> aminoAcidBefore = new ArrayList();
    private ArrayList<Character> aminoAcidAfter = new ArrayList();
    private ArrayList<Character> restrictionBefore = new ArrayList();
    private ArrayList<Character> restrictionAfter = new ArrayList();
    private Boolean isSemiSpecific = false;
    private Boolean isWholeProtein = false;

    public Enzyme(int id, String name, String aminoAcidBefore, String restrictionBefore, String aminoAcidAfter, String restrictionAfter) {
        this(id, name, aminoAcidBefore, restrictionBefore, aminoAcidAfter, restrictionAfter, false, false);
    }

    public Enzyme(int id, String name, String aminoAcidBefore, String restrictionBefore, String aminoAcidAfter, String restrictionAfter, Boolean isSemiSpecific, Boolean isWholeProtein) {
        this.id = id;
        this.name = name;
        this.isSemiSpecific = isSemiSpecific;
        this.isWholeProtein = isWholeProtein;
        for (char aa : aminoAcidBefore.toCharArray()) {
            this.aminoAcidBefore.add(Character.valueOf(aa));
        }
        for (char aa : restrictionBefore.toCharArray()) {
            this.restrictionBefore.add(Character.valueOf(aa));
        }
        for (char aa : aminoAcidAfter.toCharArray()) {
            this.aminoAcidAfter.add(Character.valueOf(aa));
        }
        for (char aa : restrictionAfter.toCharArray()) {
            this.restrictionAfter.add(Character.valueOf(aa));
        }
    }

    public boolean isUnspecific() {
        return this.id == 17;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public String getXTandemFormat() {
        String result = "";
        if (this.name.equals("Asp-N + Glu-C")) {
            result = "[E]|[X],[X]|[D]";
        } else if (this.isUnspecific()) {
            result = "[X]|[X]";
        } else {
            if (this.aminoAcidBefore.size() > 0) {
                result = result + "[";
                for (Character aa : this.aminoAcidBefore) {
                    result = result + aa;
                }
                result = result + "]";
            }
            if (this.restrictionBefore.size() > 0) {
                result = result + "{";
                for (Character aa : this.restrictionBefore) {
                    result = result + aa;
                }
                result = result + "}";
            }
            result = result + "|";
            if (this.aminoAcidAfter.size() > 0) {
                result = result + "[";
                for (Character aa : this.aminoAcidAfter) {
                    result = result + aa;
                }
                result = result + "]";
            }
            if (this.restrictionAfter.size() > 0) {
                result = result + "{";
                for (Character aa : this.restrictionAfter) {
                    result = result + aa;
                }
                result = result + "}";
            }
        }
        return result;
    }

    public ArrayList<Character> getAminoAcidAfter() {
        return this.aminoAcidAfter;
    }

    public ArrayList<Character> getAminoAcidBefore() {
        return this.aminoAcidBefore;
    }

    public ArrayList<Character> getRestrictionAfter() {
        return this.restrictionAfter;
    }

    public ArrayList<Character> getRestrictionBefore() {
        return this.restrictionBefore;
    }

    public boolean enzymeCleaves() {
        return !this.getAminoAcidBefore().isEmpty() || !this.getAminoAcidAfter().isEmpty();
    }

    public boolean isCleavageSite(String aaBefore, String aaAfter) {
        if (aaBefore.length() == 0 || aaAfter.length() == 0) {
            return true;
        }
        return this.isCleavageSite(aaBefore.charAt(aaBefore.length() - 1), aaAfter.charAt(0));
    }

    public boolean isCleavageSite(char aaBefore, char aaAfter) {
        boolean restriction;
        AminoAcid aminoAcid;
        for (Character aa1 : this.aminoAcidBefore) {
            aminoAcid = AminoAcid.getAminoAcid(aaBefore);
            for (char possibleAaBefore : aminoAcid.getSubAminoAcids()) {
                if (possibleAaBefore != aa1.charValue()) continue;
                restriction = false;
                for (Character aa2 : this.restrictionAfter) {
                    aminoAcid = AminoAcid.getAminoAcid(aaAfter);
                    for (char possibleAaAfter : aminoAcid.getSubAminoAcids()) {
                        if (possibleAaAfter != aa2.charValue()) continue;
                        restriction = true;
                        break;
                    }
                    if (!restriction) continue;
                    break;
                }
                if (restriction) continue;
                return true;
            }
        }
        for (Character aa1 : this.aminoAcidAfter) {
            aminoAcid = AminoAcid.getAminoAcid(aaAfter);
            for (char possibleAaAfter : aminoAcid.getSubAminoAcids()) {
                if (possibleAaAfter != aa1.charValue()) continue;
                restriction = false;
                for (Character aa2 : this.restrictionBefore) {
                    aminoAcid = AminoAcid.getAminoAcid(aaAfter);
                    for (char possibleAaBefore : aminoAcid.getSubAminoAcids()) {
                        if (possibleAaBefore != aa2.charValue()) continue;
                        restriction = true;
                        break;
                    }
                    if (!restriction) continue;
                    break;
                }
                if (restriction) continue;
                return true;
            }
        }
        return false;
    }

    public int getNmissedCleavages(String sequence) {
        int result = 0;
        if (sequence.length() > 1) {
            for (int i = 0; i < sequence.length() - 1; ++i) {
                if (!this.isCleavageSite(sequence.charAt(i), sequence.charAt(i + 1))) continue;
                ++result;
            }
        }
        return result;
    }

    public ArrayList<String> digest(String sequence, int nMissedCleavages, int nMin, int nMax) {
        int i;
        char aaAfter = sequence.charAt(0);
        String currentPeptide = aaAfter + "";
        ArrayList<String> results = new ArrayList<String>();
        HashMap mc = new HashMap();
        for (i = 1; i <= nMissedCleavages; ++i) {
            mc.put(i, new ArrayList());
        }
        for (i = 1; i < sequence.length(); ++i) {
            char aaBefore = aaAfter;
            char aa = sequence.charAt(i);
            if (this.isCleavageSite(aaBefore, aaAfter = aa) && !currentPeptide.equals("")) {
                if (currentPeptide.length() >= nMin && currentPeptide.length() <= nMax && !results.contains(currentPeptide)) {
                    results.add(currentPeptide);
                }
                Iterator iterator = mc.keySet().iterator();
                while (iterator.hasNext()) {
                    int nMc = (Integer)iterator.next();
                    ((ArrayList)mc.get(nMc)).add(currentPeptide);
                    while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                        ((ArrayList)mc.get(nMc)).remove(0);
                    }
                    String mcSequence = "";
                    for (String subPeptide : (ArrayList)mc.get(nMc)) {
                        mcSequence = mcSequence + subPeptide;
                    }
                    if (mcSequence.length() < nMin || mcSequence.length() > nMax || results.contains(mcSequence)) continue;
                    results.add(mcSequence);
                }
                currentPeptide = "";
            }
            currentPeptide = currentPeptide + aa;
        }
        if (currentPeptide.length() >= nMin && currentPeptide.length() <= nMax && !results.contains(currentPeptide)) {
            results.add(currentPeptide);
        }
        Iterator iterator = mc.keySet().iterator();
        while (iterator.hasNext()) {
            int nMc = (Integer)iterator.next();
            ((ArrayList)mc.get(nMc)).add(currentPeptide);
            while (((ArrayList)mc.get(nMc)).size() > nMc + 1) {
                ((ArrayList)mc.get(nMc)).remove(0);
            }
            String mcSequence = "";
            for (String subPeptide : (ArrayList)mc.get(nMc)) {
                mcSequence = mcSequence + subPeptide;
            }
            if (mcSequence.length() < nMin || mcSequence.length() > nMax || results.contains(mcSequence)) continue;
            results.add(mcSequence);
        }
        return results;
    }

    public boolean equals(Enzyme otherEnzyme) {
        if (otherEnzyme == null) {
            return false;
        }
        if (this.getId() != otherEnzyme.getId()) {
            return false;
        }
        if (!this.getName().equalsIgnoreCase(otherEnzyme.getName())) {
            return false;
        }
        if (!this.getAminoAcidBefore().equals(otherEnzyme.getAminoAcidBefore())) {
            return false;
        }
        if (!this.getRestrictionBefore().equals(otherEnzyme.getRestrictionBefore())) {
            return false;
        }
        if (!this.getAminoAcidAfter().equals(otherEnzyme.getAminoAcidAfter())) {
            return false;
        }
        if (!this.getRestrictionAfter().equals(otherEnzyme.getRestrictionAfter())) {
            return false;
        }
        if (this.isSemiSpecific() != otherEnzyme.isSemiSpecific()) {
            return false;
        }
        return this.isWholeProtein() == otherEnzyme.isWholeProtein();
    }

    public void setSemiSpecific(boolean isSemiSpecific) {
        this.isSemiSpecific = isSemiSpecific;
    }

    public boolean isSemiSpecific() {
        if (this.isSemiSpecific == null) {
            this.isSemiSpecific = false;
        }
        return this.isSemiSpecific;
    }

    public void setWholeProtein(boolean isWholeProtein) {
        this.isWholeProtein = isWholeProtein;
    }

    public boolean isWholeProtein() {
        if (this.isWholeProtein == null) {
            this.isWholeProtein = this.name.equalsIgnoreCase("Whole Protein") || this.name.equalsIgnoreCase("Top-Down");
        }
        return this.isWholeProtein;
    }
}

