/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot.index;

import com.compomics.mascotdatfile.util.mascot.index.ByteOffset;
import com.compomics.mascotdatfile.util.mascot.index.Controller;
import com.compomics.mascotdatfile.util.mascot.index.SummaryIndex;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class Reader {
    private static Logger logger = Logger.getLogger(Reader.class);
    private int iByteLengthStatus = -1;
    private File iFile = null;
    private Controller iController = null;
    private static File iTempFolder = null;
    private String lTempFileName = "Reader";
    private RandomAccessFile raf = null;
    private TreeSet<Integer> iLineNumbersToInclude = new TreeSet();
    private Integer iLineCount = 0;
    private Long iByteCount = 0L;
    private long iSectionEndByte = -1L;
    private long iSectionStartByte = -1L;
    private String iSectionName = "";
    private boolean isIndexingLines = false;
    private byte[] iLineSeparator;
    private boolean iTempFileNeeded = false;
    private OutputStream fos = null;
    ArrayList<Integer> lNewLineCharacters = new ArrayList();

    public Reader(String aFileName, Controller aController) {
        this(new File(aFileName), aController);
    }

    public Reader(File aFile, Controller aController) {
        this.iController = aController;
        this.iFile = aFile;
        try {
            this.construct(new BufferedReader(new InputStreamReader(new FileInputStream(this.iFile))));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public Reader(BufferedReader aBufferedReader, Controller aController) {
        this.iController = aController;
        this.iTempFileNeeded = true;
        this.construct(aBufferedReader);
    }

    private void construct(BufferedReader aBufferedReader) {
        try {
            if (this.iTempFileNeeded) {
                this.iFile = File.createTempFile(this.lTempFileName + System.currentTimeMillis(), ".tmp", Reader.getTempDirectory());
                this.iFile.deleteOnExit();
                this.fos = new BufferedOutputStream(new FileOutputStream(this.iFile));
            }
            Integer lCharacter = -1;
            ArrayList<Character> checkArray = new ArrayList<Character>();
            boolean newlinefound = false;
            lCharacter = aBufferedReader.read();
            if (lCharacter != -1) {
                Long l = this.iByteCount;
                Long l2 = this.iByteCount = Long.valueOf(this.iByteCount + 1L);
                if (this.iTempFileNeeded) {
                    this.fos.write(lCharacter);
                }
                Character temp = Character.valueOf((char)lCharacter.byteValue());
                checkArray.add(temp);
                while (!newlinefound) {
                    String checkArrayToString;
                    lCharacter = aBufferedReader.read();
                    l2 = this.iByteCount;
                    Long l3 = this.iByteCount = Long.valueOf(this.iByteCount + 1L);
                    if (this.iTempFileNeeded) {
                        this.fos.write(lCharacter);
                    }
                    temp = Character.valueOf((char)lCharacter.byteValue());
                    checkArray.add(temp);
                    if (lCharacter == 10) {
                        checkArrayToString = checkArray.toString();
                        if ((checkArrayToString = checkArrayToString.replaceAll(",", "")).contains("M a s c o t")) {
                            this.lNewLineCharacters.add(lCharacter);
                            newlinefound = true;
                            continue;
                        }
                        checkArray.clear();
                        continue;
                    }
                    if (lCharacter != 13) continue;
                    checkArrayToString = checkArray.toString();
                    if ((checkArrayToString = checkArrayToString.replaceAll(",", "")).contains("M a s c o t")) {
                        lCharacter = aBufferedReader.read();
                        l3 = this.iByteCount;
                        Long l4 = this.iByteCount = Long.valueOf(this.iByteCount + 1L);
                        if (this.iTempFileNeeded) {
                            this.fos.write(lCharacter);
                        }
                        if (lCharacter == 10) {
                            this.lNewLineCharacters.add(13);
                            this.lNewLineCharacters.add(10);
                            newlinefound = true;
                            continue;
                        }
                        this.lNewLineCharacters.add(13);
                        continue;
                    }
                    checkArray.clear();
                }
                this.iLineSeparator = new byte[this.lNewLineCharacters.size()];
                for (int i = 0; i < this.lNewLineCharacters.size(); ++i) {
                    byte b;
                    this.iLineSeparator[i] = b = this.lNewLineCharacters.get(i).byteValue();
                }
                Integer i = this.iLineCount;
                Integer n = this.iLineCount = Integer.valueOf(this.iLineCount + 1);
            }
            String lLine = "";
            boolean lSectionFinished = false;
            while ((lLine = aBufferedReader.readLine()) != null) {
                this.lineReadFromBufferedReader(lLine);
                if (!lLine.startsWith("--") && !lSectionFinished) continue;
                if (lSectionFinished) {
                    lSectionFinished = false;
                } else {
                    this.processSectionBoundary(aBufferedReader, lLine);
                }
                if (this.iSectionName.equals("peptides")) {
                    this.processPeptideSection(aBufferedReader);
                    lSectionFinished = true;
                    continue;
                }
                if (this.iSectionName.equals("summary")) {
                    this.initSummaryIndex(aBufferedReader, SummaryIndex.getInstance());
                    continue;
                }
                if (this.iSectionName.equals("decoy_peptides")) {
                    this.processDecoyPeptideSection(aBufferedReader);
                    lSectionFinished = true;
                    continue;
                }
                if (!this.iSectionName.equals("decoy_summary")) continue;
                this.initSummaryIndex(aBufferedReader, SummaryIndex.getDecoyInstance());
            }
            aBufferedReader.close();
            if (this.iTempFileNeeded) {
                this.fos.flush();
                this.fos.close();
            }
            this.raf = new RandomAccessFile(this.iFile, "r");
        }
        catch (IOException e) {
            if (this.iTempFileNeeded && this.iFile.exists()) {
                this.iFile.delete();
            }
            e.printStackTrace();
        }
    }

    private static File getTempDirectory() {
        if (iTempFolder == null) {
            try {
                File lTempFile = File.createTempFile("anchor", "tmp");
                iTempFolder = new File(lTempFile.getParent(), "mascotdatfile_raf");
                iTempFolder.mkdir();
                lTempFile.delete();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), e);
            }
        }
        return iTempFolder;
    }

    private void processSectionBoundary(BufferedReader aBufferedReader, String aCurrentLine) throws IOException {
        this.iSectionEndByte = this.iByteCount - (long)(this.iLineSeparator.length * 2) - (long)this.getStringLengthInBytes(aCurrentLine);
        String lLine = "";
        lLine = aBufferedReader.readLine();
        if (lLine != null) {
            this.lineReadFromBufferedReader(lLine);
            long[] lSectionIndex = new long[]{this.iSectionStartByte, this.iSectionEndByte};
            if (this.iSectionStartByte != -1L) {
                this.iController.addSectionIndex(this.iSectionName, new ByteOffset(this.iSectionStartByte, this.iSectionEndByte));
            }
            this.iSectionName = this.parseSectionName(lLine);
            this.isIndexingLines = this.isLineIndexedSection(this.iSectionName);
            this.iSectionStartByte = this.iByteCount + (long)this.iLineSeparator.length;
        }
    }

    private void initSummaryIndex(BufferedReader aBufferedReader, SummaryIndex aSummaryIndex) throws IOException {
        String lLine;
        int lTypeIndex = -1;
        while ((lLine = aBufferedReader.readLine()) != null) {
            this.lineReadFromBufferedReader(lLine);
            if (lLine.equals("")) continue;
            if ((lLine = lLine.substring(0, lLine.indexOf(61))).endsWith("1")) {
                ++lTypeIndex;
            } else {
                aSummaryIndex.setNumberOfIndexes(lTypeIndex + 1);
                aSummaryIndex.setSummaryLineIndex(this.iLineCount - (lTypeIndex + 1));
                break;
            }
            if (lLine.startsWith("qmass")) {
                aSummaryIndex.setMass_index(lTypeIndex);
            } else if (lLine.startsWith("qexp")) {
                aSummaryIndex.setExp_index(lTypeIndex);
            } else if (lLine.startsWith("qmatch")) {
                aSummaryIndex.setMatch_index(lTypeIndex);
            } else if (lLine.startsWith("qplughole")) {
                aSummaryIndex.setPlughole_index(lTypeIndex);
            } else if (lLine.startsWith("qintensity")) {
                aSummaryIndex.setIntensity_index(lTypeIndex);
            }
            if (!lLine.startsWith("--")) continue;
            break;
        }
    }

    private void processPeptideSection(BufferedReader aBufferedReader) throws IOException {
        String lLine;
        ArrayList<Integer> lLineNumbers = new ArrayList<Integer>();
        int lOldQuery = 1;
        int lQuery = 1;
        boolean lPeptide = true;
        while ((lLine = aBufferedReader.readLine()) != null) {
            int lUnderscore;
            this.lineReadFromBufferedReader(lLine);
            if (lLine.equals("")) continue;
            lOldQuery = lQuery;
            if (lLine.startsWith("--")) {
                Integer[] aLines = new Integer[lLineNumbers.size()];
                this.iController.addPeptideLineIndex(lLineNumbers.toArray(aLines));
                this.processSectionBoundary(aBufferedReader, lLine);
                break;
            }
            int lEqualSign = lLine.indexOf(61);
            int lSeparator = lLine.indexOf(112);
            if (lSeparator < (lUnderscore = lLine.indexOf(95, lSeparator)) && lUnderscore < lEqualSign) continue;
            lQuery = Integer.parseInt(lLine.substring(1, lSeparator - 1));
            if (lQuery != lOldQuery) {
                Integer[] aLines = new Integer[lLineNumbers.size()];
                this.iController.addPeptideLineIndex(lLineNumbers.toArray(aLines));
                lLineNumbers = new ArrayList();
            }
            lLineNumbers.add(new Integer(this.iLineCount));
        }
    }

    private void processDecoyPeptideSection(BufferedReader aBufferedReader) throws IOException {
        String lLine;
        ArrayList<Integer> lLineNumbers = new ArrayList<Integer>();
        int lOldQuery = 1;
        int lQuery = 1;
        boolean lPeptide = true;
        while ((lLine = aBufferedReader.readLine()) != null) {
            int lUnderscore;
            this.lineReadFromBufferedReader(lLine);
            if (lLine.equals("")) continue;
            lOldQuery = lQuery;
            if (lLine.startsWith("--")) {
                Integer[] aLines = new Integer[lLineNumbers.size()];
                this.iController.addDecoyPeptideLineIndex(lLineNumbers.toArray(aLines));
                this.processSectionBoundary(aBufferedReader, lLine);
                break;
            }
            int lEqualSign = lLine.indexOf(61);
            int lSeparator = lLine.indexOf(112);
            if (lSeparator < (lUnderscore = lLine.indexOf(95, lSeparator)) && lUnderscore < lEqualSign) continue;
            lQuery = Integer.parseInt(lLine.substring(1, lSeparator - 1));
            if (lQuery != lOldQuery) {
                Integer[] aLines = new Integer[lLineNumbers.size()];
                this.iController.addDecoyPeptideLineIndex(lLineNumbers.toArray(aLines));
                lLineNumbers = new ArrayList();
            }
            lLineNumbers.add(new Integer(this.iLineCount));
        }
    }

    private void lineReadFromBufferedReader(String lLine) throws IOException {
        if (this.iTempFileNeeded) {
            byte[] lBytes = lLine.getBytes();
            this.fos.write(lBytes);
            this.fos.write(this.iLineSeparator);
            this.fos.flush();
        }
        Integer n = this.iLineCount;
        Integer n2 = this.iLineCount = Integer.valueOf(this.iLineCount + 1);
        if (this.isIndexingLines) {
            this.iController.addLineIndex(this.iLineCount, this.iByteCount);
        }
        this.iByteCount = this.iByteCount + (long)this.getStringLengthInBytes(lLine) + (long)this.iLineSeparator.length;
    }

    private String parseSectionName(String lLine) {
        if (lLine.equals("")) {
            return lLine;
        }
        int endIndex = lLine.length() - 1;
        int startIndex = lLine.indexOf("name=") + 6;
        return lLine.substring(startIndex, endIndex);
    }

    public String readLine(long aBytePosition) {
        String lResult = "";
        try {
            this.raf.seek(aBytePosition);
            lResult = this.raf.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lResult;
    }

    public String readInterval(long aBytePositionStart, int aLength) {
        byte[] lReadBytes = new byte[aLength];
        String lResult = null;
        try {
            this.raf.seek(aBytePositionStart);
            this.raf.read(lReadBytes);
            lResult = new String(lReadBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lResult;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.iTempFileNeeded && this.iFile.exists()) {
            this.iFile.delete();
        }
    }

    public static void cleanOldFiles() {
        File[] lFiles;
        File lTempDirectory = Reader.getTempDirectory();
        for (File lFile : lFiles = lTempDirectory.listFiles()) {
            lFile.delete();
        }
    }

    private boolean isLineIndexedSection(String aSectionName) {
        return aSectionName.equals("peptides") || aSectionName.equals("summary") || aSectionName.equals("decoy_summary") || aSectionName.equals("decoy_peptides");
    }

    private int getStringLengthInBytes(String s) {
        return s.getBytes().length;
    }

    public int getNewLineCharacterSize() {
        return this.lNewLineCharacters.size();
    }
}

