## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

# preload to avoid loading messages
library(NanoMethViz)

## ---- eval = FALSE------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("NanoMethViz")

## -----------------------------------------------------------------------------
library(NanoMethViz)

## -----------------------------------------------------------------------------
# methylation data stored in tabix file
methy <- system.file(package = "NanoMethViz", "methy_subset.tsv.bgz")

# tabix is just a special gzipped tab-separated-values file
read.table(gzfile(methy), col.names = methy_col_names(), nrows = 6)

## -----------------------------------------------------------------------------
# helper function extracts exons from Mus.musculus package
exon_tibble <- get_exons_mus_musculus()

head(exon_tibble)

## -----------------------------------------------------------------------------
sample <- c(
  "B6Cast_Prom_1_bl6",
  "B6Cast_Prom_1_cast",
  "B6Cast_Prom_2_bl6",
  "B6Cast_Prom_2_cast",
  "B6Cast_Prom_3_bl6",
  "B6Cast_Prom_3_cast"
)

group <- c(
  "bl6",
  "cast",
  "bl6",
  "cast",
  "bl6",
  "cast"
)

sample_anno <- data.frame(sample, group, stringsAsFactors = FALSE)

sample_anno

## -----------------------------------------------------------------------------
nmeth_results <- NanoMethResult(methy, sample_anno, exon_tibble)

## -----------------------------------------------------------------------------
plot_gene(nmeth_results, "Peg3")

## -----------------------------------------------------------------------------
# loading saved results from previous bsseq analysis
bsseq_dmr <- read.table(
    system.file(package = "NanoMethViz", "dmr_subset.tsv.gz"),
    sep = "\t",
    header = TRUE,
    stringsAsFactors = FALSE
)

## -----------------------------------------------------------------------------
plot_gene(nmeth_results, "Peg3", anno_regions = bsseq_dmr)

## ---- warning = FALSE---------------------------------------------------------
# warnings have been turned off in this vignette, but this will generally
# generate many warnings as the smoothing for many reads will fail
plot_gene(nmeth_results, "Peg3", anno_regions = bsseq_dmr, spaghetti = TRUE)

