## ---- echo=FALSE, results="asis", message=FALSE, KnitrSetUp-------------------
knitr::opts_chunk$set(tidy=FALSE,warning=FALSE,message=FALSE)
Biocpkg <- function (pkg){
    sprintf("[%s](http://bioconductor.org/packages/%s)", pkg, pkg)
}

CRANpkg <- function(pkg){
    cran <- "https://CRAN.R-project.org/package" 
    fmt <- "[%s](%s=%s)"
    sprintf(fmt, pkg, cran, pkg) 
}

## ---- echo=FALSE, results="hide", message=FALSE, Loadpackages-----------------
library(tidyverse)
library(phyloseq)
library(ggtree)
library(treeio)
library(tidytree)
library(MicrobiotaProcess)

## ---- error=FALSE, KosticCRCdata----------------------------------------------
data(kostic2012crc)
kostic2012crc
#datatable(sample_data(kostic2012crc), options=list(scrollX=TRUE, scrollY="400px", scrollCollapse=TRUE))
kostic2012crc <- phyloseq::rarefy_even_depth(kostic2012crc,rngseed=1024)
table(sample_data(kostic2012crc)$DIAGNOSIS)

## ---- error=FALSE, KosticCRCdiff_analysis-------------------------------------
set.seed(1024)
diffres <- diff_analysis(obj=kostic2012crc, classgroup="DIAGNOSIS",
                         mlfun="lda",
                         filtermod="fdr",
                         firstcomfun = "kruskal.test",
                         firstalpha=0.05,
                         strictmod=TRUE,
                         secondcomfun = "wilcox.test",
                         subclmin=3,
                         subclwilc=TRUE,
                         secondalpha=0.01, 
                         lda=3)
diffres

## ---- fig.align="center", fig.height=5, fig.width=6, error=FALSE, KosticCRCplotEffectSize----
plotes <- ggeffectsize(obj=diffres) + scale_color_manual(values=c("#00AED7", "#FD9347"))
plotes

## ---- fig.align="center", fig.height=5, fig.width=7, error=FALSE, KosticCRCLDAtax----
plotes_ab <- ggdiffbox(obj=diffres, box_notch=FALSE, colorlist=c("#00AED7", "#FD9347"), l_xlabtext="relative abundance")
plotes_ab

## ---- fig.width=7, fig.height=7, fig.align="center", error=FALSE, KosticCRCdiffclade----
diffcladeplot <- ggdiffclade(obj=diffres,
                             alpha=0.3, size=0.2, 
                             skpointsize=0.6,
                             taxlevel=3,
                             settheme=FALSE, 
                             setColors=FALSE) +
                 scale_fill_manual(values=c("#00AED7", "#FD9347"))+
                 guides(color = guide_legend(keywidth = 0.1,
                                             keyheight = 0.6,
                                             order = 3, 
                                             ncol=1)) + 
                 theme(panel.background=element_rect(fill=NA),
                       legend.position="right",
                       plot.margin=margin(0,0,0,0),
                       legend.spacing.y = unit(0.02, "cm"),
                       legend.title=element_text(size=7),
                       legend.text=element_text(size=6),
                       legend.box.spacing=unit(0.02,"cm"))
diffcladeplot

## ---- KosticCRCdiffTab, error=FALSE-------------------------------------------
crcdiffTab <- as.data.frame(diffres)
#datatable(crcdiffTab, options=list(scrollX=TRUE, scrollY="400px", scrollCollapse=TRUE))

## ---- hmpdatasets-------------------------------------------------------------
data(hmp_aerobiosis_small)
# contained "featureda" "sampleda"  "taxda" datasets.
#datatable(featureda, options=list(scrollX=TRUE, scrollY="400px", scrollCollapse=TRUE))
#datatable(sampleda, options=list(scrollX=TRUE, scrollY="400px", scrollCollapse=TRUE))
#datatable(taxda, options=list(scrollX=TRUE, scrollY="400px", scrollCollapse=TRUE))
dim(featureda)
dim(sampleda)
dim(taxda)

## ---- hmpdiff_analysis, error=FALSE-------------------------------------------
set.seed(1024)
hmpdiffres <- diff_analysis(obj=featureda, 
                            sampleda=sampleda, 
                            taxda=taxda, 
                            alltax=FALSE, 
                            classgroup="oxygen_availability",
                            subclass="body_site",
                            filtermod="fdr",
                            firstalpha=0.01,
                            strictmod=TRUE,
                            subclmin=3,
                            subclwilc=TRUE,
                            secondalpha=0.05,
                            ldascore=2)
hmpdiffres

## ---- fig.align="center", fig.height=7, fig.width=5.5, error=FALSE, hmpplotEffectSize----
hmpeffetsieze <- ggeffectsize(obj=hmpdiffres, 
                              setColors=FALSE,
                              settheme=FALSE) + 
                 scale_color_manual(values=c('#00AED7', '#FD9347', '#C1E168'))+
                 theme_bw()+
                 theme(strip.background=element_rect(fill=NA),
                       panel.grid=element_blank(),
                       strip.text.y=element_blank())
hmpeffetsieze

## ---- fig.align="center", fig.height=7, fig.width=7, error=FALSE, hmpplotEffectSizeTax----
hmpes_ab <- ggdiffbox(obj=hmpdiffres, colorlist=c("#00AED7", "#FD9347", '#C1E168'), 
                      box_notch=FALSE, l_xlabtext="relative abundance(%)")
hmpes_ab

## ---- fig.width=7, fig.height=7, fig.align="center", error=FALSE, hmpdiffclade----
hmpdiffclade <- ggdiffclade(obj=hmpdiffres, alpha=0.3, size=0.2, 
                            skpointsize=0.4, taxlevel=3,
                            settheme=TRUE,
                            setColors=FALSE) +
                scale_fill_manual(values=c('#00AED7', '#FD9347', '#C1E168'))
hmpdiffclade

## ---- hmpdiffTab, error=FALSE-------------------------------------------------
hmpdiffTab <- as.data.frame(hmpdiffres)
#datatable(hmpdiffTab, options=list(scrollX=TRUE, scrollY="400px", scrollCollapse=TRUE))

## ---- echo=FALSE--------------------------------------------------------------
sessionInfo()

