## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----style, echo=FALSE, results='asis'----------------------------------------
BiocStyle::markdown()

## ----setup, echo=FALSE, message=FALSE-----------------------------------------
library(MSstatsPTM)

## ----install, eval=FALSE------------------------------------------------------
#  devtools::install_github("tsunghengtsai/MSstatsPTM")

## ----lib, eval=FALSE----------------------------------------------------------
#  library(MSstatsPTM)

## ----simulate-----------------------------------------------------------------
# sim <- PTMsimulateExperiment(
#   nGroup=2, nRep=2, nProtein=1, nSite=2, nFeature=5, 
#   mu=list(PTM=25, PROTEIN=25), 
#   delta=list(PTM=c(0, 1), PROTEIN=c(0, 1)), 
#   sRep=list(PTM=0.2, PROTEIN=0.2), 
#   sPeak=list(PTM=0.05, PROTEIN=0.05)
# )
sim <- PTMsimulateExperiment(
    nGroup=2, nRep=2, nProtein=1, nSite=2, nFeature=5,
    logAbundance=list(
        PTM=list(mu=25, delta=c(0, 1), sRep=0.2, sPeak=0.05),
        PROTEIN=list(mu=25, delta=c(0, 1), sRep=0.2, sPeak=0.05)
    )
)

## ----data-structure-----------------------------------------------------------
str(sim)

## ----data-ptm-----------------------------------------------------------------
sim[["PTM"]]

## ----data-protein-------------------------------------------------------------
sim[["PROTEIN"]]

## ----fasta, eval=FALSE--------------------------------------------------------
#  fas <- tidyFasta("https://www.uniprot.org/uniprot/P37840.fasta")

## ----normalization, message=FALSE---------------------------------------------
normalized <- PTMnormalize(sim, method="median")
normalized

## ----normalization-ref, message=FALSE-----------------------------------------
refs <- list(
    PTM=data.frame(run=paste0("R_", 1:4), adjLog2inty=c(2, -2, 0, 0)), 
    PROTEIN=data.frame(run=paste0("R_", 1:4), adjLog2inty=c(3, -1, 0, 0))
)
PTMnormalize(sim, method="ref", refs=refs)

## ----summarization, message=FALSE---------------------------------------------
summarized <- PTMsummarize(normalized)
summarized

## ----estimation, message=FALSE------------------------------------------------
estimates <- PTMestimate(summarized)
estimates

## -----------------------------------------------------------------------------
PTMcompareMeans(estimates, controls="G_1", cases="G_2")

## -----------------------------------------------------------------------------
PTMcompareMeans(estimates, controls="G_1", cases="G_2", adjProtein=TRUE)

## ----session------------------------------------------------------------------
sessionInfo()

