## ----style-knitr, eval=TRUE, echo=FALSE, results="asis"-----------------------------
BiocStyle::latex()

## ----include=FALSE------------------------------------------------------------------
library(knitr)
opts_chunk$set(
concordance = TRUE,
background = "#f3f3ff"
)

## ----req----------------------------------------------------------------------------
library("LACE")
data(longitudinal_sc_variants)
names(longitudinal_sc_variants)

## ----req_se-------------------------------------------------------------------------
library("SummarizedExperiment",attach.required=FALSE)
T1 = t(longitudinal_sc_variants[[1]])
T2 = t(longitudinal_sc_variants[[2]])
T3 = t(longitudinal_sc_variants[[3]])
T4 = t(longitudinal_sc_variants[[4]])
concat_time_point = cbind(T1,T2,T3,T4)
TimePointLabes = c(rep("T1", ncol(T1)),
                   rep("T2", ncol(T2)), 
                   rep("T3", ncol(T3)), 
                   rep("T4", ncol(T4)))
longitudinal_SE = SummarizedExperiment(assays = concat_time_point,
                                      colData = data.frame(TimePoint = TimePointLabes))
print(longitudinal_SE)

## ----example_weights----------------------------------------------------------------
lik_weights = c(0.2308772,0.2554386,0.2701754,0.2435088)

## ----example_error_rates------------------------------------------------------------
alpha = list()
alpha[[1]] = c(0.02,0.01,0.01,0.01)
alpha[[2]] = c(0.10,0.05,0.05,0.05)
beta = list()
beta[[1]] = c(0.10,0.05,0.05,0.05)
beta[[2]] = c(0.10,0.05,0.05,0.05)
head(alpha)
head(beta)

## ----example_inference--------------------------------------------------------------
inference = LACE(D = longitudinal_sc_variants,
                 lik_w = lik_weights,
                 alpha = alpha,
                 beta = beta,
                 keep_equivalent = FALSE,
                 num_rs = 5,
                 num_iter = 10,
                 n_try_bs = 5,
                 num_processes = NA,
                 seed = 12345,
                 verbose = FALSE)

## ----example_inference_full---------------------------------------------------------
data(inference)
print(names(inference))

## ----example_plot-------------------------------------------------------------------
clone_labels = c("ARPC2","PRAME","HNRNPC","COL1A2","RPL5","CCT8")
longitudinal.tree = longitudinal.tree.plot(inference = inference, 
                                           labels_show = "clones", 
                                           clone_labels = clone_labels, 
                                           legend_position = "topright")

## ----sessioninfo,results='asis',echo=FALSE------------------------------------------
toLatex(sessionInfo())

