## ----init, results='hide', echo=FALSE, warning=FALSE, message=FALSE-----------
library(knitr)
opts_chunk$set(warning=FALSE, message=FALSE)
BiocStyle::markdown()

## ----install_bioc, eval=FALSE-------------------------------------------------
#  if (!require("BiocManager"))
#      install.packages("BiocManager")
#  BiocManager::install('HCABrowser')

## ----libraries, message=FALSE-------------------------------------------------
library(HCABrowser)

## ----createHCA----------------------------------------------------------------
hca <- HCABrowser(api_url='https://dss.data.humancellatlas.org/v1/swagger.json',
                  host = 'dss.data.humancellatlas.org/v1')
hca

## ----nextResults, eval=FALSE--------------------------------------------------
#  hca <- nextResults(hca)
#  hca

## ----firstFilter--------------------------------------------------------------
hca2 <- hca %>% filter('files.specimen_from_organism_json.organ.text' == c('Brain', 'brain'))
hca2 <- hca %>% filter('files.specimen_from_organism_json.organ.text' %in% c('Brain', 'brain'))
hca2 <- hca %>% filter('files.specimen_from_organism_json.organ.text' == Brain | 'files.specimen_from_organism_json.organ.text' == brain)
hca2

## ----multiFilter--------------------------------------------------------------
hca2 <- hca %>% filter('files.specimen_from_organism_json.organ.text' %in% c('Brain', 'brain')) %>%
                filter('specimen_from_organism_json.biomaterial_core.ncbi_taxon_id' == 10090)
hca2 <- hca %>% filter('files.specimen_from_organism_json.organ.text' %in% c('Brain', 'brain'),
                       'specimen_from_organism_json.biomaterial_core.ncbi_taxon_id' == 10090)
hca <- hca %>% filter('files.specimen_from_organism_json.organ.text' %in% c('Brain', 'brain') &
                      'specimen_from_organism_json.biomaterial_core.ncbi_taxon_id' == 10090)
hca

## ----complexFilter------------------------------------------------------------
hca2 <- hca %>% filter((!organ.text %in% c('Brain', 'blood')) & 
                       (files.specimen_from_organism_json.genus_species.text == "Homo sapiens" |
                        library_preparation_protocol_json.library_construction_approach.text == 'Smart-seq2')
                )
hca2

## ----undoQuery----------------------------------------------------------------
hca <- hca %>% filter('files.specimen_from_organism_json.organ.text' == heart)
hca <- hca %>% filter('files.specimen_from_organism_json.organ.text' != brain)
hca <- undoEsQuery(hca, n = 2)
hca

## ----select-------------------------------------------------------------------
hca2 <- hca %>% select('paired_end', 'organ.ontology')
hca2 <- hca %>% select(c('paired_end', 'organ.ontology'))
hca2

## ----getBundle----------------------------------------------------------------
hca <- HCABrowser()

hca <- hca %>% filter('files.specimen_from_organism_json.organ.text' == "brain")
result <- searchBundles(hca, replica='aws', output_format='raw')
result <- parseToSearchResults(result)

bundles <- lapply(results(result), function(results) {
    uuid <- stringr::str_split(results[["bundle_fqid"]], '\\.')[[1]][[1]]
    getBundle(hca, uuid=uuid, replica='aws')
})

bundles

## ----getFile------------------------------------------------------------------
hca <- HCABrowser()

hca <- hca %>% filter('files.specimen_from_organism_json.organ.text' == "brain")
result <- searchBundles(hca, replica='aws', output_format='raw')
result <- parseToSearchResults(result)

bundles <- lapply(results(result), function(results) {
    uuid <- stringr::str_split(results[["bundle_fqid"]], '\\.')[[1]][[1]]

    bundle <- c()

    tryCatch({
    checkout_id <- httr::content(checkoutBundle(hca, uuid=uuid, replica='aws'))$checkout_job_id

    bundle_checkout_status <- httr::content(getBundleCheckout(hca, checkout_job_id=checkout_id, replica='aws'))$status

    bundle <- getBundle(uuid=uuid, replica='aws')
    httr::content(bundle)
    }, error = function(e) {
        message('Missing checkout request')
    }, finally = {
        NULL
    })
})

files <- lapply(bundles, function(bundle) {
    uuid <- bundle[['bundle']]['uuid']
    getFile(hca, uuid=uuid, replica='aws')
})

files

## ----fastq--------------------------------------------------------------------


