## ----setup, include=FALSE-----------------------------------------------------
library(GeneNetworkBuilder)
library(knitr)
library(STRINGdb)

## ----STRING-------------------------------------------------------------------
library(GeneNetworkBuilder)
try({ ## just in case STRINGdb not work
    library(STRINGdb)
    string_db <- STRINGdb$new( version="10", species=9606,
                           score_threshold=400)
    data(diff_exp_example1)
    example1_mapped <- string_db$map( diff_exp_example1, "gene", removeUnmappedRows = TRUE )
    i <- string_db$get_interactions(example1_mapped$STRING_id)
    colnames(example1_mapped) <- c("gene", "P.Value", "logFC", "symbols")
    ## get significant up regulated genes.
    genes <- unique(example1_mapped$symbols[example1_mapped$P.Value<0.005 & example1_mapped$logFC>3])
    x<-networkFromGenes(genes = genes, interactionmap=i, level=3)
    ## filter network
    ## unique expression data by symbols column
    expressionData <- uniqueExprsData(example1_mapped, 
                                       method = 'Max', 
                                       condenseName = "logFC")
    ## merge binding table with expression data by symbols column
    cifNetwork<-filterNetwork(rootgene=x$rootgene, 
                              sifNetwork=x$sifNetwork, 
                              exprsData=expressionData, mergeBy="symbols",
                              miRNAlist=character(0), 
                              tolerance=1, cutoffPVal=0.001, cutoffLFC=1)
    ## convert the id back to symbol
    IDsMap <- expressionData$gene
    names(IDsMap) <- expressionData$symbols
    cifNetwork <- convertID(cifNetwork, IDsMap)
    ## polish network
    gR<-polishNetwork(cifNetwork)
    ## browse network
    browseNetwork(gR)
})

