/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.interpreter;

import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.cytoscape.equations.EqnCompiler;
import org.cytoscape.equations.EqnParser;
import org.cytoscape.equations.Function;
import org.cytoscape.equations.Parser;
import org.cytoscape.equations.interpreter.IdentDescriptor;
import org.cytoscape.equations.interpreter.Interpreter;

public class InterpreterTest
extends TestCase {
    private final EqnCompiler compiler = new EqnCompiler();

    public void testSimpleStringConcatExpr() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("s1", String.class);
        InterpreterTest.assertTrue(this.compiler.compile("=\"Fred\"&${s1}", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        nameToDescriptorMap.put("s1", new IdentDescriptor("Bob"));
        Interpreter interpreter = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals((Object)"FredBob", interpreter.run());
    }

    public void testSimpleExpr() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("BOB", Double.class);
        InterpreterTest.assertTrue(this.compiler.compile("=42 - 12 + 3 * (4 - 2) + ${BOB:12}", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        nameToDescriptorMap.put("BOB", new IdentDescriptor(-10.0));
        Interpreter interpreter = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Double(26.0), interpreter.run());
    }

    public void testUnaryPlusAndMinus() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("attr1", Double.class);
        attribNameToTypeMap.put("attr2", Double.class);
        InterpreterTest.assertTrue(this.compiler.compile("=-17.8E-14", attribNameToTypeMap));
        InterpreterTest.assertTrue(this.compiler.compile("=+(${attr1} + ${attr2})", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        nameToDescriptorMap.put("attr1", new IdentDescriptor(5.5));
        nameToDescriptorMap.put("attr2", new IdentDescriptor(6.5));
        Interpreter interpreter = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Double(12.0), interpreter.run());
    }

    public void testFunctionCall() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        InterpreterTest.assertTrue(this.compiler.compile("=42 + log(4 - 2)", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        Interpreter interpreter = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Double(42.0 + Math.log10(2.0)), interpreter.run());
    }

    public void testExponentiation() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        InterpreterTest.assertTrue(this.compiler.compile("=2^3^4 - 0.0002", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        Interpreter interpreter = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Double(Math.pow(2.0, Math.pow(3.0, 4.0)) - 2.0E-4), interpreter.run());
    }

    public void testComparisons() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("x", Double.class);
        attribNameToTypeMap.put("y", Double.class);
        attribNameToTypeMap.put("limit", Double.class);
        InterpreterTest.assertTrue(this.compiler.compile("=${x} <= ${y}", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        nameToDescriptorMap.put("x", new IdentDescriptor(1.2));
        nameToDescriptorMap.put("y", new IdentDescriptor(-3.8E-12));
        nameToDescriptorMap.put("limit", new IdentDescriptor(-6.523E13));
        Interpreter interpreter1 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter1.run());
        InterpreterTest.assertTrue(this.compiler.compile("=-15.4^3 > ${limit}", attribNameToTypeMap));
        Interpreter interpreter2 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(true), interpreter2.run());
    }

    public void testVarargs() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        InterpreterTest.assertFalse(this.compiler.compile("=LOG()", attribNameToTypeMap));
        InterpreterTest.assertTrue(this.compiler.compile("=LOG(1)", attribNameToTypeMap));
        InterpreterTest.assertTrue(this.compiler.compile("=LOG(1,2)", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        Interpreter interpreter = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Double(Math.log(1.0) / Math.log(2.0)), interpreter.run());
        InterpreterTest.assertFalse(this.compiler.compile("=LOG(1,2,3)", attribNameToTypeMap));
    }

    public void testFixedArgs() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        InterpreterTest.assertFalse(this.compiler.compile("=ABS()", attribNameToTypeMap));
        InterpreterTest.assertTrue(this.compiler.compile("=ABS(-1.5e10)", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        Interpreter interpreter = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Double(1.5E10), interpreter.run());
        InterpreterTest.assertFalse(this.compiler.compile("=ABS(1,2)", attribNameToTypeMap));
    }

    public void testDEFINED() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("x", Double.class);
        InterpreterTest.assertTrue(this.compiler.compile("=defined(x)", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        nameToDescriptorMap.put("x", new IdentDescriptor(1.2));
        Interpreter interpreter1 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(true), interpreter1.run());
        InterpreterTest.assertTrue(this.compiler.compile("=DEFINED(${limit})", attribNameToTypeMap));
        Interpreter interpreter2 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter2.run());
    }

    public void testIntegerToFloatingPointConversion() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("BOB", Long.class);
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        nameToDescriptorMap.put("BOB", new IdentDescriptor(new Long(3L)));
        InterpreterTest.assertTrue(this.compiler.compile("=$BOB > 5.3", attribNameToTypeMap));
        Interpreter interpreter1 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter1.run());
        InterpreterTest.assertTrue(this.compiler.compile("=$BOB <= 5.3", attribNameToTypeMap));
        Interpreter interpreter2 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(true), interpreter2.run());
    }

    public void testMixedModeArithmetic() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        attribNameToTypeMap.put("x", Long.class);
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        nameToDescriptorMap.put("x", new IdentDescriptor(new Long(3L)));
        InterpreterTest.assertTrue(this.compiler.compile("=$x + 2.0", attribNameToTypeMap));
        Interpreter interpreter1 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Double(5.0), interpreter1.run());
        InterpreterTest.assertTrue(this.compiler.compile("=TRUE + TRUE", attribNameToTypeMap));
        Interpreter interpreter2 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Double(2.0), interpreter2.run());
    }

    public void testFunctionWithBadRuntimeReturnType() throws Exception {
        BadReturnFunction badReturnFunction;
        EqnParser eqnParser = Parser.getParser();
        if (eqnParser.getFunction((badReturnFunction = new BadReturnFunction()).getName()) == null) {
            eqnParser.registerFunction(badReturnFunction);
        }
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        InterpreterTest.assertTrue(this.compiler.compile("=BAD()", attribNameToTypeMap));
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        Interpreter interpreter = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        try {
            interpreter.run();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }

    public void testComparisonsWithBooleans() throws Exception {
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        HashMap<String, IdentDescriptor> nameToDescriptorMap = new HashMap<String, IdentDescriptor>();
        InterpreterTest.assertTrue(this.compiler.compile("=TRUE < FALSE", attribNameToTypeMap));
        Interpreter interpreter1 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter1.run());
        InterpreterTest.assertTrue(this.compiler.compile("=FALSE < TRUE", attribNameToTypeMap));
        Interpreter interpreter2 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(true), interpreter2.run());
        InterpreterTest.assertTrue(this.compiler.compile("=\"a\" < TRUE", attribNameToTypeMap));
        Interpreter interpreter3 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(true), interpreter3.run());
        InterpreterTest.assertTrue(this.compiler.compile("=\"ZYX\" < FALSE", attribNameToTypeMap));
        Interpreter interpreter4 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(true), interpreter4.run());
        InterpreterTest.assertTrue(this.compiler.compile("=\"a\" > TRUE", attribNameToTypeMap));
        Interpreter interpreter5 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter5.run());
        InterpreterTest.assertTrue(this.compiler.compile("=\"ZYX\" > FALSE", attribNameToTypeMap));
        Interpreter interpreter6 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter6.run());
        InterpreterTest.assertTrue(this.compiler.compile("=TRUE < \"a\"", attribNameToTypeMap));
        Interpreter interpreter7 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter7.run());
        InterpreterTest.assertTrue(this.compiler.compile("=FALSE < \"ZYX\"", attribNameToTypeMap));
        Interpreter interpreter8 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter8.run());
        InterpreterTest.assertTrue(this.compiler.compile("=TRUE < 0", attribNameToTypeMap));
        Interpreter interpreter9 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter9.run());
        InterpreterTest.assertTrue(this.compiler.compile("=FALSE < -1", attribNameToTypeMap));
        Interpreter interpreter10 = new Interpreter(this.compiler.getEquation(), nameToDescriptorMap);
        InterpreterTest.assertEquals(new Boolean(false), interpreter10.run());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BadReturnFunction
    implements Function {
        private BadReturnFunction() {
        }

        @Override
        public String getName() {
            return "BAD";
        }

        @Override
        public String getFunctionSummary() {
            return "Returns an invalid type at runtime.";
        }

        @Override
        public String getUsageDescription() {
            return "Call this with \"BAD()\".";
        }

        @Override
        public Class getReturnType() {
            return Double.class;
        }

        @Override
        public Class validateArgTypes(Class[] argTypes) {
            return argTypes.length == 0 ? Double.class : null;
        }

        @Override
        public Object evaluateFunction(Object[] args) {
            return new Integer(1);
        }

        @Override
        public List<Class> getPossibleArgTypes(Class[] leadingArgs) {
            return null;
        }
    }
}

