/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.ontology.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.biojava.bio.BioError;
import org.biojava.ontology.AlreadyExistsException;
import org.biojava.ontology.Ontology;
import org.biojava.ontology.OntologyException;
import org.biojava.ontology.OntologyFactory;
import org.biojava.ontology.Term;
import org.biojava.ontology.Triple;
import org.biojava.utils.ChangeVetoException;

public class TabDelimParser {
    public Ontology parse(BufferedReader in, OntologyFactory of) throws IOException, OntologyException {
        String name = "";
        String description = "";
        Ontology onto = null;
        String line = in.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0) {
                if (line.startsWith("#")) {
                    if (line.startsWith("#name:")) {
                        name = line.substring("#name:".length()).trim();
                    } else if (line.startsWith("#description:")) {
                        description = line.substring("#description:".length()).trim();
                    }
                } else {
                    try {
                        if (onto == null) {
                            onto = of.createOntology(name, description);
                        }
                        StringTokenizer toke = new StringTokenizer(line);
                        String subject = toke.nextToken();
                        String predicate = toke.nextToken();
                        String object = toke.nextToken();
                        Term subT = this.resolveTerm(subject, onto);
                        Term objT = this.resolveTerm(object, onto);
                        Term relT = this.resolveTerm(predicate, onto);
                        Triple trip = this.resolveTriple(subT, objT, relT, onto);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IOException("Could not parse line: " + line);
                    }
                }
            }
            line = in.readLine();
        }
        return onto;
    }

    private Term resolveTerm(String termName, Ontology onto) {
        boolean isTrippleTerm;
        boolean bl = isTrippleTerm = termName.startsWith("(") && termName.endsWith(")");
        if (onto.containsTerm(termName)) {
            return onto.getTerm(termName);
        }
        try {
            if (isTrippleTerm) {
                int c1 = termName.indexOf(",");
                int c2 = termName.indexOf(",", c1 + 1);
                String source = termName.substring(1, c1);
                String target = termName.substring(c2 + 1, termName.length() - 1);
                String predicate = termName.substring(c1 + 1, c2);
                Term st = this.resolveTerm(source, onto);
                Term tt = this.resolveTerm(target, onto);
                Term rt = this.resolveTerm(predicate, onto);
                return onto.createTriple(st, tt, rt, null, null);
            }
            return onto.createTerm(termName, "");
        }
        catch (AlreadyExistsException aee) {
            throw new BioError("Assertion Failure: Could not create term", aee);
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Assertion Failure: Could not create term", cve);
        }
    }

    private Triple resolveTriple(Term sub, Term obj, Term rel, Ontology onto) {
        if (onto.containsTriple(sub, obj, rel)) {
            return (Triple)onto.getTriples(sub, obj, rel).iterator().next();
        }
        try {
            return onto.createTriple(sub, obj, rel, null, null);
        }
        catch (AlreadyExistsException aee) {
            throw new BioError("Assertion Failure: Could not create triple", aee);
        }
        catch (ChangeVetoException cve) {
            throw new BioError("Assertion Failure: Could not create triple", cve);
        }
    }
}

