/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.io;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureException;
import org.biojava.utils.xml.XMLWriter;

public class FileConvert {
    Structure structure;

    public FileConvert(Structure struc) {
        this.structure = struc;
    }

    private String alignRight(String input, int length) {
        String spaces = "                           ";
        int n = input.length();
        int diff = length - n;
        String s = "";
        if (n >= length) {
            return input;
        }
        s = spaces.substring(0, diff) + input;
        return s;
    }

    public String toPDB() {
        StringBuffer str = new StringBuffer();
        boolean i = false;
        DecimalFormat d3 = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        d3.setMaximumIntegerDigits(3);
        d3.setMinimumFractionDigits(3);
        d3.setMaximumFractionDigits(3);
        DecimalFormat d2 = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        d2.setMaximumIntegerDigits(3);
        d3.setMinimumFractionDigits(3);
        d3.setMaximumFractionDigits(3);
        int nrModels = this.structure.nrModels();
        if (this.structure.isNmr()) {
            str.append("EXPDTA    NMR, " + nrModels + " STRUCTURES\n");
        }
        for (int m = 0; m < nrModels; ++m) {
            ArrayList model = (ArrayList)this.structure.getModel(m);
            if (this.structure.isNmr()) {
                str.append("MODEL      " + (m + 1) + "\n");
            }
            int nrChains = model.size();
            for (int c = 0; c < nrChains; ++c) {
                Chain chain = (Chain)model.get(c);
                String chainID = chain.getName();
                int nrGroups = chain.getLength();
                for (int h = 0; h < nrGroups; ++h) {
                    Group g = chain.getGroup(h);
                    String type = g.getType();
                    String record = "";
                    record = type.equals("hetatm") ? "HETATM" : "ATOM  ";
                    int groupsize = g.size();
                    String resName = g.getPDBName();
                    String pdbcode = g.getPDBCode();
                    String line = "";
                    for (int atompos = 0; atompos < groupsize; ++atompos) {
                        Atom a = null;
                        try {
                            a = g.getAtom(atompos);
                        }
                        catch (StructureException e) {
                            System.err.println(e);
                            continue;
                        }
                        int seri = a.getPDBserial();
                        String serial = this.alignRight("" + seri, 5);
                        String fullname = a.getFullName();
                        Character altLoc = a.getAltLoc();
                        String resseq = "";
                        resseq = this.hasInsertionCode(pdbcode) ? this.alignRight("" + pdbcode, 5) : this.alignRight("" + pdbcode, 4) + " ";
                        String x = this.alignRight("" + d3.format(a.getX()), 8);
                        String y = this.alignRight("" + d3.format(a.getY()), 8);
                        String z = this.alignRight("" + d3.format(a.getZ()), 8);
                        String occupancy = this.alignRight("" + d2.format(a.getOccupancy()), 6);
                        String tempfactor = this.alignRight("" + d2.format(a.getTempFactor()), 6);
                        line = record + serial + " " + fullname + altLoc + resName + " " + chainID + resseq + "   " + x + y + z + occupancy + tempfactor;
                        str.append(line + "\n");
                    }
                }
            }
            if (!this.structure.isNmr()) continue;
            str.append("ENDMDL\n");
        }
        return str.toString();
    }

    private boolean hasInsertionCode(String pdbserial) {
        try {
            int pos = Integer.parseInt(pdbserial);
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public void toDASStructure(XMLWriter xw) throws IOException {
        HashMap header = (HashMap)this.structure.getHeader();
        xw.openTag("object");
        xw.attribute("dbAccessionId", this.structure.getPDBCode());
        xw.attribute("intObjectId", this.structure.getPDBCode());
        String modificationDate = (String)header.get("modDate");
        xw.attribute("objectVersion", modificationDate);
        xw.attribute("type", "protein structure");
        xw.attribute("dbSource", "PDB");
        xw.attribute("dbVersion", "20040621");
        xw.attribute("dbCoordSys", "PDBresnum");
        xw.closeTag("object");
        for (int modelnr = 0; modelnr < this.structure.nrModels(); ++modelnr) {
            for (int chainnr = 0; chainnr < this.structure.size(modelnr); ++chainnr) {
                Chain chain = this.structure.getChain(modelnr, chainnr);
                xw.openTag("chain");
                xw.attribute("id", chain.getName());
                xw.attribute("SwissprotId", chain.getSwissprotId());
                if (this.structure.isNmr()) {
                    xw.attribute("model", Integer.toString(modelnr + 1));
                }
                for (int groupnr = 0; groupnr < chain.getLength(); ++groupnr) {
                    Group gr = chain.getGroup(groupnr);
                    xw.openTag("group");
                    xw.attribute("name", gr.getPDBName());
                    xw.attribute("type", gr.getType());
                    xw.attribute("groupID", gr.getPDBCode());
                    ArrayList atoms = (ArrayList)gr.getAtoms();
                    for (int atomnr = 0; atomnr < atoms.size(); ++atomnr) {
                        Atom atom = (Atom)atoms.get(atomnr);
                        xw.openTag("atom");
                        xw.attribute("atomID", Integer.toString(atom.getPDBserial()));
                        xw.attribute("atomName", atom.getFullName());
                        xw.attribute("x", Double.toString(atom.getX()));
                        xw.attribute("y", Double.toString(atom.getY()));
                        xw.attribute("z", Double.toString(atom.getZ()));
                        xw.closeTag("atom");
                    }
                    xw.closeTag("group");
                }
                xw.closeTag("chain");
            }
        }
        ArrayList cons = (ArrayList)this.structure.getConnections();
        for (int cnr = 0; cnr < cons.size(); ++cnr) {
            HashMap con = (HashMap)cons.get(cnr);
            Integer as = (Integer)con.get("atomserial");
            int atomserial = as;
            ArrayList atomids = new ArrayList();
            if (con.containsKey("salt1")) {
                atomids.add(con.get("salt1"));
            }
            if (con.containsKey("salt2")) {
                atomids.add(con.get("salt2"));
            }
            if (atomids.size() != 0) {
                this.addConnection(xw, "salt", atomserial, atomids);
                atomids = new ArrayList();
            }
            if (con.containsKey("hydrogen1")) {
                atomids.add(con.get("hydrogen1"));
            }
            if (con.containsKey("hydrogen2")) {
                atomids.add(con.get("hydrogen2"));
            }
            if (con.containsKey("hydrogen3")) {
                atomids.add(con.get("hydrogen3"));
            }
            if (con.containsKey("hydrogen4")) {
                atomids.add(con.get("hydrogen4"));
            }
            if (atomids.size() != 0) {
                this.addConnection(xw, "hydrogen", atomserial, atomids);
                atomids = new ArrayList();
            }
            if (con.containsKey("bond1")) {
                atomids.add(con.get("bond1"));
            }
            if (con.containsKey("bond2")) {
                atomids.add(con.get("bond2"));
            }
            if (con.containsKey("bond3")) {
                atomids.add(con.get("bond3"));
            }
            if (con.containsKey("bond4")) {
                atomids.add(con.get("bond4"));
            }
            if (atomids.size() == 0) continue;
            this.addConnection(xw, "bond", atomserial, atomids);
        }
    }

    private void addConnection(XMLWriter xw, String connType, int atomserial, ArrayList atomids) {
        try {
            xw.openTag("connect");
            xw.attribute("atomSerial", Integer.toString(atomserial));
            xw.attribute("type", connType);
            for (int i = 0; i < atomids.size(); ++i) {
                Integer atomid = (Integer)atomids.get(i);
                int aid = atomid;
                xw.openTag("atomID");
                xw.attribute("atomID", Integer.toString(aid));
                xw.closeTag("atomID");
            }
            xw.closeTag("connect");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

