/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.util.Iterator;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceRendererWrapper;
import org.biojava.bio.gui.sequence.SubSequenceRenderContext;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.GappedSymbolList;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.SymbolList;

public class GappedRenderer
extends SequenceRendererWrapper {
    public GappedRenderer() {
    }

    public GappedRenderer(SequenceRenderer renderer) {
        super(renderer);
    }

    public double getDepth(SequenceRenderContext src) {
        if (src.getSymbols() instanceof GappedSymbolList) {
            GappedSymbolList gsym = (GappedSymbolList)src.getSymbols();
            Location ungapped = gsym.getUngappedLocation();
            double depth = 0.0;
            Iterator bi = ungapped.blockIterator();
            while (bi.hasNext()) {
                RangeLocation loc = (RangeLocation)bi.next();
                depth = Math.max(depth, super.getDepth(this.makeContext(src, loc)));
            }
            return depth;
        }
        return super.getDepth(src);
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        if (src.getSymbols() instanceof GappedSymbolList) {
            GappedSymbolList gsym = (GappedSymbolList)src.getSymbols();
            Location ungapped = gsym.getUngappedLocation();
            Iterator bi = ungapped.blockIterator();
            if (bi.hasNext()) {
                return super.getMinimumLeader(this.makeContext(src, (RangeLocation)bi.next()));
            }
            return 0.0;
        }
        return super.getMinimumLeader(src);
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        if (src.getSymbols() instanceof GappedSymbolList) {
            GappedSymbolList gsym = (GappedSymbolList)src.getSymbols();
            Location ungapped = gsym.getUngappedLocation();
            Iterator bi = ungapped.blockIterator();
            RangeLocation loc = null;
            while (bi.hasNext()) {
                loc = (RangeLocation)bi.next();
            }
            if (loc == null) {
                return 0.0;
            }
            return super.getMinimumTrailer(this.makeContext(src, loc));
        }
        return super.getMinimumTrailer(src);
    }

    public void paint(Graphics2D g, SequenceRenderContext src) {
        if (src.getSymbols() instanceof GappedSymbolList) {
            GappedSymbolList gsym = (GappedSymbolList)src.getSymbols();
            Location ungapped = gsym.getUngappedLocation();
            Iterator bi = ungapped.blockIterator();
            while (bi.hasNext()) {
                RangeLocation loc = (RangeLocation)bi.next();
                super.paint(g, this.makeContext(src, loc));
            }
        } else {
            super.paint(g, src);
        }
    }

    protected SequenceRenderContext makeContext(SequenceRenderContext src, RangeLocation loc) {
        SymbolList ugsl;
        GappedSymbolList gsl = (GappedSymbolList)src.getSymbols();
        RangeLocation sourceLoc = new RangeLocation(gsl.viewToSource(loc.getMin()), gsl.viewToSource(loc.getMax()));
        int trans = loc.getMin() - sourceLoc.getMin();
        return new SubSequenceRenderContext(src, ugsl, (ugsl = gsl.getSourceSymbolList()) instanceof FeatureHolder ? (FeatureHolder)((Object)ugsl) : null, sourceLoc, trans);
    }
}

