/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.visual.VisualPropertyType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class YValueLegendPanel
extends JPanel {
    private VisualPropertyType type;

    public YValueLegendPanel(VisualPropertyType type) {
        this.type = type;
        this.setPreferredSize(new Dimension());
    }

    public void paintComponent(Graphics g) {
        this.clear(g);
        Graphics2D g2d = (Graphics2D)g;
        int panelHeight = this.getHeight() - 30;
        Polygon poly = new Polygon();
        int top = 10;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(1.0f));
        int center = this.getWidth() / 2 + 4;
        poly.addPoint(center, top);
        poly.addPoint(center - 6, top + 15);
        poly.addPoint(center, top + 15);
        g.fillPolygon(poly);
        g2d.drawLine(center, top, center, panelHeight);
        g2d.setColor(Color.DARK_GRAY);
        g2d.setFont(new Font("SansSerif", 1, 10));
        String label = this.type.getName();
        int width = SwingUtilities.computeStringWidth(g2d.getFontMetrics(), label);
        AffineTransform af = new AffineTransform();
        af.rotate(4.71238898038469);
        g2d.setTransform(af);
        g2d.setColor(Color.black);
        g2d.drawString(this.type.getName(), -this.getHeight() / 2 - width / 2, this.getWidth() / 2 + 5);
    }

    protected void clear(Graphics g) {
        super.paintComponent(g);
    }
}

