/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui.editors.continuous;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.ui.editors.continuous.ContinuousMappingEditorPanel;
import cytoscape.visual.ui.editors.continuous.ContinuousTrackRenderer;
import cytoscape.visual.ui.editors.continuous.EditorValueRangeTracer;
import cytoscape.visual.ui.editors.continuous.TriangleThumbRenderer;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.ImageIcon;
import org.jdesktop.swingx.multislider.TrackRenderer;

public class C2CMappingEditor
extends ContinuousMappingEditorPanel {
    private static final long serialVersionUID = -3555354576428996187L;
    private static final Float DEF_BELOW_AND_ABOVE = Float.valueOf(1.0f);

    public C2CMappingEditor(VisualPropertyType type) {
        super(type);
        this.abovePanel.setVisible(false);
        this.belowPanel.setVisible(false);
        this.pack();
        this.setSlider();
        if (this.mapping != null && this.mapping.getPointCount() == 0) {
            this.addSlider(0.0f, 10.0f);
            this.addSlider(100.0f, 30.0f);
        }
    }

    public static Object showDialog(int width, int height, String title, VisualPropertyType type) {
        editor = new C2CMappingEditor(type);
        Dimension size = new Dimension(width, height);
        editor.setPreferredSize(size);
        editor.setSize(size);
        editor.setTitle(title);
        editor.setAlwaysOnTop(true);
        editor.setLocationRelativeTo(Cytoscape.getDesktop());
        editor.setVisible(true);
        return editor;
    }

    public static ImageIcon getIcon(int iconWidth, int iconHeight, VisualPropertyType type) {
        editor = new C2CMappingEditor(type);
        TrackRenderer rend = C2CMappingEditor.editor.slider.getTrackRenderer();
        if (rend instanceof ContinuousTrackRenderer) {
            rend.getRendererComponent(C2CMappingEditor.editor.slider);
            return ((ContinuousTrackRenderer)rend).getTrackGraphicIcon(iconWidth, iconHeight);
        }
        return null;
    }

    public static ImageIcon getLegend(int width, int height, VisualPropertyType type) {
        editor = new C2CMappingEditor(type);
        ContinuousTrackRenderer rend = (ContinuousTrackRenderer)C2CMappingEditor.editor.slider.getTrackRenderer();
        rend.getRendererComponent(C2CMappingEditor.editor.slider);
        return rend.getLegend(width, height);
    }

    private void addSlider(float position, float value) {
        CyLogger.getLogger().info("=====Adding slider\n");
        double maxValue = EditorValueRangeTracer.getTracer().getMax(this.type);
        if (this.mapping.getPointCount() == 0) {
            this.slider.getModel().addThumb(position, Float.valueOf(value));
            BoundaryRangeValues newRange = new BoundaryRangeValues(this.below, Float.valueOf(5.0f), this.above);
            this.mapping.addPoint(maxValue / 2.0, newRange);
            Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            this.slider.repaint();
            this.repaint();
            return;
        }
        this.slider.getModel().addThumb(position, Float.valueOf(value));
        ContinuousMappingPoint previousPoint = this.mapping.getPoint(this.mapping.getPointCount() - 1);
        BoundaryRangeValues previousRange = previousPoint.getRange();
        BoundaryRangeValues newRange = new BoundaryRangeValues(previousRange);
        newRange.lesserValue = this.slider.getModel().getSortedThumbs().get(this.slider.getModel().getThumbCount() - 1);
        CyLogger.getLogger().info("EQ color = " + newRange.lesserValue);
        newRange.equalValue = Float.valueOf(5.0f);
        newRange.greaterValue = previousRange.greaterValue;
        this.mapping.addPoint(maxValue, newRange);
        this.updateMap();
        Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
        this.slider.repaint();
        this.repaint();
    }

    protected void addButtonActionPerformed(ActionEvent evt) {
        this.addSlider(100.0f, 5.0f);
    }

    protected void deleteButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.slider.getSelectedIndex();
        if (0 <= selectedIndex && this.slider.getModel().getThumbCount() > 1) {
            this.slider.getModel().removeThumb(selectedIndex);
            this.mapping.removePoint(selectedIndex);
            this.updateMap();
            ((ContinuousTrackRenderer)this.slider.getTrackRenderer()).removeSquare(selectedIndex);
            this.mapping.fireStateChanged();
            Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            this.repaint();
        }
    }

    private void setSlider() {
        this.slider.updateUI();
        double minValue = EditorValueRangeTracer.getTracer().getMin(this.type);
        double actualRange = EditorValueRangeTracer.getTracer().getRange(this.type);
        if (this.allPoints == null) {
            return;
        }
        for (ContinuousMappingPoint point : this.allPoints) {
            BoundaryRangeValues bound = point.getRange();
            Float fraction = Float.valueOf(((Number)((point.getValue() - minValue) / actualRange)).floatValue() * 100.0f);
            this.slider.getModel().addThumb(fraction.floatValue(), Float.valueOf(((Number)bound.equalValue).floatValue()));
        }
        if (this.allPoints.size() != 0) {
            this.below = (Number)((ContinuousMappingPoint)this.allPoints.get((int)0)).getRange().lesserValue;
            this.above = (Number)((ContinuousMappingPoint)this.allPoints.get((int)(this.allPoints.size() - 1))).getRange().greaterValue;
        } else {
            this.below = DEF_BELOW_AND_ABOVE;
            this.above = DEF_BELOW_AND_ABOVE;
        }
        TriangleThumbRenderer thumbRend = new TriangleThumbRenderer(this.slider);
        ContinuousTrackRenderer cRend = new ContinuousTrackRenderer(this.type, (Number)this.below, (Number)this.above);
        cRend.addPropertyChangeListener(this);
        this.slider.setThumbRenderer(thumbRend);
        this.slider.setTrackRenderer(cRend);
        this.slider.addMouseListener(new ContinuousMappingEditorPanel.ThumbMouseListener(this));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("BELOW_VALUE_CHANGED")) {
            this.below = evt.getNewValue();
        } else if (evt.getPropertyName().equals("ABOVE_VALUE_CHANGED")) {
            this.above = evt.getNewValue();
        }
    }
}

