/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.calculators.BasicCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class NewMappingBuilder {
    static void createNewCalculator(VisualPropertyType type, String newMappingName, String newCalcName, String controllingAttrName) {
        VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
        CalculatorCatalog catalog = vmm.getCalculatorCatalog();
        Class mapperClass = catalog.getMapping(newMappingName);
        if (mapperClass == null) {
            return;
        }
        Class[] conTypes = new Class[]{Class.class, String.class};
        Constructor mapperCon = null;
        try {
            mapperCon = mapperClass.getConstructor(conTypes);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (mapperCon == null) {
            return;
        }
        Object defaultObj = type.getDefault(vmm.getVisualStyle());
        Object[] invokeArgs = new Object[]{defaultObj.getClass(), controllingAttrName};
        ObjectMapping mapper = null;
        try {
            mapper = (ObjectMapping)mapperCon.newInstance(invokeArgs);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        if (mapper == null) {
            return;
        }
        vmm.getCalculatorCatalog().addCalculator(new BasicCalculator(newCalcName, mapper, type));
    }
}

