/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.visual.ui.FontRenderer;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FontChooser
extends JPanel {
    private Font selectedFont;
    protected DefaultComboBoxModel fontFaceModel;
    protected JComboBox face;
    protected static final float DEF_SIZE = 12.0f;
    protected static Font[] scaledFonts;
    protected static final Font DEF_FONT;

    public FontChooser() {
        this((Font)null);
    }

    public FontChooser(Font def) {
        this(scaledFonts, def);
    }

    public FontChooser(Font[] srcFonts, Font def) {
        Font[] displayFonts = scaledFonts;
        if (srcFonts != scaledFonts) {
            displayFonts = FontChooser.scaleFonts(srcFonts, 12.0f);
        }
        this.fontFaceModel = new DefaultComboBoxModel<Font>(displayFonts);
        this.face = new JComboBox(this.fontFaceModel);
        this.face.setRenderer(new FontRenderer());
        this.face.addItemListener(new FontFaceSelectionListener());
        this.selectedFont = def == null ? DEF_FONT : def.deriveFont(1.0f);
        this.face.setEditable(true);
        this.face.setSelectedItem(this.selectedFont);
        this.face.setEditable(false);
        this.add(this.face);
    }

    public JComboBox getFaceComboBox() {
        return this.face;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    private static Font[] scaleFonts(Font[] inFonts, float size) {
        Font[] outFonts = new Font[inFonts.length];
        int i = 0;
        for (Font f : inFonts) {
            outFonts[i++] = f.deriveFont(size);
        }
        return outFonts;
    }

    static {
        DEF_FONT = new Font("SansSerif", 0, 1);
        scaledFonts = FontChooser.scaleFonts(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts(), 12.0f);
    }

    private class FontFaceSelectionListener
    implements ItemListener {
        private FontFaceSelectionListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                JComboBox source = (JComboBox)e.getItemSelectable();
                FontChooser.this.selectedFont = (Font)source.getSelectedItem();
            }
        }
    }
}

