/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.customgraphic.impl.vector;

import cytoscape.render.stateful.PaintFactory;
import cytoscape.visual.customgraphic.CustomGraphicsPropertyImpl;
import cytoscape.visual.customgraphic.impl.AbstractDCustomGraphics;
import cytoscape.visual.customgraphic.impl.vector.CustomGraphicsProperty;
import cytoscape.visual.customgraphic.impl.vector.VectorCustomGraphics;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GradientLayerCustomGraphics
extends AbstractDCustomGraphics
implements VectorCustomGraphics {
    protected PaintFactory paintFactory;
    protected Shape bound;
    private static final float FIT = 0.9f;
    protected static final String COLOR1 = "Color 1";
    protected static final String COLOR2 = "Color 2";
    protected final CustomGraphicsProperty<Color> c1;
    protected final CustomGraphicsProperty<Color> c2;
    protected BufferedImage rendered;
    private static final Color transparentWhite = new Color(255, 255, 255, 100);
    private static final Color transparentBlack = new Color(100, 100, 100, 100);
    private static final int DEF_W = 100;
    private static final int DEF_H = 100;
    protected final Map<String, CustomGraphicsProperty<?>> props;

    public GradientLayerCustomGraphics(Long id, String name) {
        super(id, name);
        this.width = 100;
        this.height = 100;
        this.props = new HashMap();
        this.c1 = new CustomGraphicsPropertyImpl<Color>(transparentWhite);
        this.c2 = new CustomGraphicsPropertyImpl<Color>(transparentBlack);
        this.props.put(COLOR1, this.c1);
        this.props.put(COLOR2, this.c2);
        this.tags.add("vector image, gradient");
        this.fitRatio = 0.9f;
        this.getRenderedImage();
    }

    @Override
    public Map<String, CustomGraphicsProperty<?>> getGraphicsProps() {
        return this.props;
    }

    protected void renderImage(Graphics graphics) {
        this.rendered.flush();
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    @Override
    public Image getRenderedImage() {
        if (this.rendered == null || this.rendered != null && (this.rendered.getWidth() != this.width || this.rendered.getHeight() != this.height)) {
            this.rendered = new BufferedImage(this.width, this.height, 2);
            this.renderImage(this.rendered.getGraphics());
        }
        return this.rendered;
    }
}

