/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.CytoscapeInit;
import cytoscape.layout.Tunable;
import cytoscape.util.ModuleProperties;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulePropertiesImpl
implements ModuleProperties {
    protected HashMap<String, String> propertyMap = null;
    protected HashMap<String, String> savedPropertyMap = null;
    protected HashMap<String, Tunable> tunablesMap = null;
    protected List<Tunable> tunablesList = null;
    protected String propertyPrefix = null;
    protected String moduleType;

    public ModulePropertiesImpl(String propertyPrefix, String moduleType) {
        this.moduleType = moduleType;
        this.propertyPrefix = propertyPrefix;
        this.tunablesMap = new HashMap();
        this.tunablesList = new ArrayList<Tunable>();
    }

    @Override
    public void add(Tunable tunable) {
        this.tunablesMap.put(tunable.getName(), tunable);
        this.tunablesList.add(tunable);
    }

    @Override
    public Tunable get(String name) {
        if (this.tunablesMap.containsKey(name)) {
            return this.tunablesMap.get(name);
        }
        return null;
    }

    @Override
    public List<String> getTunableList() {
        return new ArrayList<String>(this.tunablesMap.keySet());
    }

    @Override
    public String getValue(String name) {
        if (this.tunablesMap.containsKey(name)) {
            Tunable t = this.tunablesMap.get(name);
            return t.getValue().toString();
        }
        return null;
    }

    @Override
    public void updateValues() {
        for (Tunable tunable : this.tunablesList) {
            tunable.updateValue();
        }
    }

    @Override
    public HashMap getProperties() {
        String prefix = this.getPrefix();
        Properties props = CytoscapeInit.getProperties();
        this.propertyMap = new HashMap();
        this.savedPropertyMap = new HashMap();
        Enumeration<?> iter = props.propertyNames();
        while (iter.hasMoreElements()) {
            String property = (String)iter.nextElement();
            if (!property.startsWith(prefix)) continue;
            int start = prefix.length();
            this.propertyMap.put(property.substring(start), props.getProperty(property));
            this.savedPropertyMap.put(property.substring(start), props.getProperty(property));
        }
        return this.propertyMap;
    }

    @Override
    public void saveProperties() {
        String prefix = this.getPrefix();
        Properties props = CytoscapeInit.getProperties();
        for (String key : this.propertyMap.keySet()) {
            props.setProperty(prefix + key, this.propertyMap.get(key));
        }
    }

    @Override
    public void setProperty(String property, String value) {
        this.propertyMap.put(property, value);
    }

    @Override
    public void setSavedProperty(String property, String value) {
        this.savedPropertyMap.put(property, value);
    }

    @Override
    public void revertProperties() {
        this.propertyMap = new HashMap();
        if (this.savedPropertyMap == null) {
            return;
        }
        Set<String> keys = this.savedPropertyMap.keySet();
        for (String key : keys) {
            this.propertyMap.put(new String(key), new String(this.savedPropertyMap.get(key)));
            Tunable t = this.tunablesMap.get(key);
            if (t == null) continue;
            t.setValue(this.savedPropertyMap.get(key));
        }
    }

    @Override
    public void initializeProperties() {
        this.getProperties();
        for (Tunable tunable : this.tunablesList) {
            String property = tunable.getName();
            if (this.propertyMap.containsKey(property)) {
                tunable.setValue(this.propertyMap.get(property));
                continue;
            }
            this.setProperty(property, tunable.getValue().toString());
            this.setSavedProperty(property, tunable.getValue().toString());
        }
    }

    @Override
    public List<Tunable> getTunables() {
        return this.tunablesList;
    }

    protected void setModuleType(String type) {
        this.moduleType = type;
    }

    protected String getPrefix() {
        String prefix = this.moduleType + "." + this.propertyPrefix;
        if (prefix.lastIndexOf(46) != prefix.length()) {
            prefix = prefix + ".";
        }
        return prefix;
    }
}

