/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.layout;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.layout.CyLayoutAlgorithm;
import cytoscape.layout.LayoutProperties;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import ding.view.DGraphView;
import ding.view.ViewChangeEdit;
import giny.view.NodeView;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayout
implements CyLayoutAlgorithm {
    protected Set<NodeView> staticNodes;
    protected CyNetworkView networkView;
    protected CyNetwork network;
    protected boolean selectedOnly = false;
    protected String edgeAttribute = null;
    protected String nodeAttribute = null;
    protected boolean canceled = false;
    protected Dimension currentSize = new Dimension(20, 20);
    protected HashMap propertyMap = null;
    protected HashMap savedPropertyMap = null;
    private ViewChangeEdit undoableEdit;
    protected TaskMonitor taskMonitor;
    protected static TaskMonitor nullTaskMonitor = new TaskMonitor(){

        public void setPercentCompleted(int percent) {
        }

        public void setEstimatedTimeRemaining(long time) throws IllegalThreadStateException {
        }

        public void setException(Throwable t, String userErrorMessage) {
        }

        public void setException(Throwable t, String userErrorMessage, String recoveryTip) {
        }

        public void setStatus(String message) throws IllegalThreadStateException, NullPointerException {
        }
    };
    protected String propertyPrefix = "abstract";

    public AbstractLayout() {
        this.staticNodes = new HashSet<NodeView>();
    }

    public abstract void construct();

    @Override
    public abstract String getName();

    public abstract String toString();

    @Override
    public boolean supportsSelectedOnly() {
        return false;
    }

    @Override
    public void setSelectedOnly(boolean selectedOnly) {
        this.selectedOnly = selectedOnly;
    }

    @Override
    public byte[] supportsNodeAttributes() {
        return null;
    }

    @Override
    public byte[] supportsEdgeAttributes() {
        return null;
    }

    @Override
    public void setLayoutAttribute(String attributeName) {
        if (this.supportsNodeAttributes() != null) {
            this.nodeAttribute = attributeName;
        } else if (this.supportsEdgeAttributes() != null) {
            this.edgeAttribute = attributeName;
        }
    }

    @Override
    public List<String> getInitialAttributeList() {
        return new ArrayList<String>();
    }

    @Override
    public JPanel getSettingsPanel() {
        return null;
    }

    @Override
    public void revertSettings() {
    }

    @Override
    public void updateSettings() {
    }

    @Override
    public LayoutProperties getSettings() {
        return null;
    }

    @Override
    public void doLayout() {
        this.doLayout(Cytoscape.getCurrentNetworkView(), nullTaskMonitor);
    }

    @Override
    public void doLayout(CyNetworkView nview) {
        this.doLayout(nview, nullTaskMonitor);
    }

    @Override
    public void doLayout(CyNetworkView nview, TaskMonitor monitor) {
        this.canceled = false;
        this.networkView = nview;
        if (this.networkView == null || this.networkView == Cytoscape.getNullNetworkView()) {
            return;
        }
        this.network = this.networkView.getNetwork();
        if (this.network == null || this.network == Cytoscape.getNullNetwork()) {
            return;
        }
        if (this.network.getNodeCount() <= 0) {
            return;
        }
        if (monitor == null) {
            monitor = nullTaskMonitor;
        }
        this.taskMonitor = monitor;
        this.undoableEdit = new ViewChangeEdit((DGraphView)((Object)this.networkView), this.toString() + " Layout");
        this.construct();
        if (!this.selectedOnly) {
            this.networkView.fitContent();
        } else {
            this.networkView.updateView();
        }
        this.undoableEdit.post();
        CyAttributes networkAttributes = Cytoscape.getNetworkAttributes();
        networkAttributes.setAttribute(this.network.getIdentifier(), "__layoutAlgorithm", this.getName());
        networkAttributes.setUserVisible("__layoutAlgorithm", false);
        this.network = null;
        this.networkView = null;
    }

    public void initialize() {
        double node_count = this.network.getNodeCount();
        node_count = Math.sqrt(node_count);
        this.currentSize = new Dimension((int)(node_count *= 100.0), (int)node_count);
        this.initialize_local();
    }

    protected void initialize_local() {
    }

    @Override
    public void lockNodes(NodeView[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            this.staticNodes.add(nodes[i]);
        }
    }

    @Override
    public void lockNode(NodeView v) {
        this.staticNodes.add(v);
    }

    @Override
    public void unlockNode(NodeView v) {
        this.staticNodes.remove(v);
    }

    protected boolean isLocked(NodeView v) {
        return this.staticNodes.contains(v);
    }

    @Override
    public void unlockAllNodes() {
        this.staticNodes.clear();
    }

    @Override
    public void halt() {
        this.canceled = true;
    }
}

