/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.geom.rtree.test;

import cytoscape.geom.rtree.RTree;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RTreeSerializationPerformance {
    public static void main(String[] args) throws Exception {
        int read;
        RTree tree = new RTree();
        int N = Integer.parseInt(args[0]);
        double sqrtN = Math.sqrt(N);
        InputStream in = System.in;
        byte[] buff = new byte[16];
        int inx = 0;
        int off = 0;
        while (inx < N && (read = in.read(buff, off, buff.length - off)) > 0) {
            if ((off += read) < buff.length) continue;
            off = 0;
            int nonnegative = Integer.MAX_VALUE & RTreeSerializationPerformance.assembleInt(buff, 0);
            double centerX = (double)nonnegative / 2.147483647E9;
            nonnegative = Integer.MAX_VALUE & RTreeSerializationPerformance.assembleInt(buff, 4);
            double centerY = (double)nonnegative / 2.147483647E9;
            nonnegative = Integer.MAX_VALUE & RTreeSerializationPerformance.assembleInt(buff, 8);
            double width = (double)nonnegative / 2.147483647E9 / sqrtN;
            nonnegative = Integer.MAX_VALUE & RTreeSerializationPerformance.assembleInt(buff, 12);
            double height = (double)nonnegative / 2.147483647E9 / sqrtN;
            tree.insert(inx, (float)(centerX - width / 2.0), (float)(centerY - height / 2.0), (float)(centerX + width / 2.0), (float)(centerY + height / 2.0));
            ++inx;
        }
        if (inx < N) {
            throw new IOException("premature end of input");
        }
        for (inx = 0; inx < N; inx += 2) {
            tree.delete(inx);
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
        long millisBegin = System.currentTimeMillis();
        objOut.writeObject(tree);
        objOut.flush();
        objOut.close();
        long millisEnd = System.currentTimeMillis();
        System.err.println("serialization took " + (millisEnd - millisBegin) + " milliseconds");
        byte[] serializedData = byteOut.toByteArray();
        System.err.println("serialized stream is " + serializedData.length + " bytes long");
        ByteArrayInputStream byteIn = new ByteArrayInputStream(serializedData);
        long millisBegin2 = System.currentTimeMillis();
        ObjectInputStream objIn = new ObjectInputStream(byteIn);
        tree = (RTree)objIn.readObject();
        objIn.close();
        millisEnd = System.currentTimeMillis();
        System.err.println("deserialization took " + (millisEnd - millisBegin2) + " milliseconds");
    }

    private static int assembleInt(byte[] bytes, int offset) {
        int firstByte = (bytes[offset] & 0xFF) << 24;
        int secondByte = (bytes[offset + 1] & 0xFF) << 16;
        int thirdByte = (bytes[offset + 2] & 0xFF) << 8;
        int fourthByte = (bytes[offset + 3] & 0xFF) << 0;
        return firstByte | secondByte | thirdByte | fourthByte;
    }
}

