/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.FileUtil;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.MenuEvent;

public class ListFromFileSelectionAction
extends CytoscapeAction {
    private static final long serialVersionUID = 2309144834195371889L;

    public ListFromFileSelectionAction() {
        super("From ID List File...");
        this.setPreferredMenu("Select.Nodes");
    }

    public void actionPerformed(ActionEvent e) {
        this.selectFromFile();
        Cytoscape.getCurrentNetworkView().updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean selectFromFile() {
        HashSet<String> fileNodes;
        CyNetwork network;
        String fileName;
        block11: {
            try {
                fileName = FileUtil.getFile("Load ID List", FileUtil.LOAD).toString();
            }
            catch (Exception exp) {
                return false;
            }
            network = Cytoscape.getCurrentNetwork();
            fileNodes = new HashSet<String>();
            try {
                BufferedReader bin = null;
                try {
                    String s;
                    bin = new BufferedReader(new FileReader(fileName));
                    while ((s = bin.readLine()) != null) {
                        String trimedName = s.trim();
                        if (trimedName.length() <= 0) continue;
                        fileNodes.add(trimedName);
                    }
                    Object var8_10 = null;
                    if (bin == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (bin != null) {
                        bin.close();
                        bin = null;
                    }
                    throw throwable;
                }
                bin.close();
                bin = null;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Error Reading \"" + fileName + "\"", 0);
                return false;
            }
        }
        if (fileNodes.size() == 0) {
            JOptionPane.showMessageDialog(null, "No nodes read from \"" + fileName + "\"!", "Warning!", 2);
            return false;
        }
        List nodeList = network.nodesList();
        int selectCount = 0;
        for (Node node : nodeList) {
            network.setSelectedNodeState(node, true);
            ++selectCount;
        }
        if (selectCount == 0) {
            JOptionPane.showMessageDialog(null, "No nodes listed in \"" + fileName + "\" were found in the current network!", "Information", 1);
            return false;
        }
        return true;
    }

    public void menuSelected(MenuEvent e) {
        this.enableForNetwork();
    }
}

