/*
 * Decompiled with CFR 0.152.
 */
package cytoscape;

import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AllTests
extends TestCase {
    public static final String TEST_ALL = "JUNIT_TEST_ALL";

    public static void main(String[] args) {
        if (args.length > 0 && args[0] != null && args[0].equals("-ui")) {
            if (args.length == 2) {
                String[] newargs = new String[]{"cytoscape.AllTests", "-noloading", args[1]};
                junit.swingui.TestRunner.main(newargs);
            } else {
                String[] newargs = new String[]{"cytoscape.AllTests", "-noloading"};
                junit.swingui.TestRunner.main(newargs);
            }
        } else {
            TestRunner.run(AllTests.suite());
        }
    }

    public static Test suite() {
        System.out.println("suite started");
        TestSuite suite = new TestSuite("All JUnit Tests");
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            URL urlJar = ClassLoader.getSystemResource("cytoscape/AllTests.class");
            String urlStr = urlJar.toString();
            System.out.println("urlString " + urlStr);
            urlStr = urlStr.substring(0, urlStr.indexOf("!/") + 2);
            URL url = new URL(urlStr);
            JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
            JarFile thisJar = jarConnection.getJarFile();
            Enumeration<JarEntry> entries = thisJar.entries();
            ArrayList<String> testNames = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.matches(".*Test.class")) continue;
                testNames.add(name.substring(0, name.length() - 6));
            }
            URL[] testUrlArray = new URL[testNames.size()];
            for (int i = 0; i < testUrlArray.length; ++i) {
                testUrlArray[i] = new URL(urlStr + (String)testNames.get(i) + ".class");
            }
            URLClassLoader urlLoader = new URLClassLoader(testUrlArray, cl);
            String sep = System.getProperty("file.separator");
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                sep = "/";
            }
            for (int i = 0; i < testNames.size(); ++i) {
                String testname = (String)testNames.get(i);
                testname = testname.replace(sep.charAt(0), '.');
                Class<?> c = urlLoader.loadClass(testname);
                suite.addTest(new TestSuite(c));
                System.out.println("loading class " + testname);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return suite;
    }

    public static void standardOut(String msg) {
        String runAllTests = System.getProperty(TEST_ALL);
        if (runAllTests == null) {
            System.out.println(msg);
        }
    }

    public static boolean runAllTests() {
        String runAllTestProperty = System.getProperty(TEST_ALL);
        return runAllTestProperty != null;
    }
}

