/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.util;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class Toolbox {
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static boolean fontsLoaded;
    public static final String USAGE = "java com.sun.glf.util.Toolbox <imageFile>";

    public static void swingDefaultsInit() {
        Font font = new Font("Dialog", 0, 10);
        FontUIResource fontUIResource = new FontUIResource(font);
        UIManager.put("CheckBox.font", fontUIResource);
        UIManager.put("PopupMenu.font", fontUIResource);
        UIManager.put("TextPane.font", fontUIResource);
        UIManager.put("MenuItem.font", fontUIResource);
        UIManager.put("ComboBox.font", fontUIResource);
        UIManager.put("Button.font", fontUIResource);
        UIManager.put("Tree.font", fontUIResource);
        UIManager.put("ScrollPane.font", fontUIResource);
        UIManager.put("TabbedPane.font", fontUIResource);
        UIManager.put("EditorPane.font", fontUIResource);
        UIManager.put("TitledBorder.font", fontUIResource);
        UIManager.put("Menu.font", fontUIResource);
        UIManager.put("TextArea.font", fontUIResource);
        UIManager.put("OptionPane.font", fontUIResource);
        UIManager.put("DesktopIcon.font", fontUIResource);
        UIManager.put("MenuBar.font", fontUIResource);
        UIManager.put("ToolBar.font", fontUIResource);
        UIManager.put("RadioButton.font", fontUIResource);
        UIManager.put("ToggleButton.font", fontUIResource);
        UIManager.put("ToolTip.font", fontUIResource);
        UIManager.put("ProgressBar.font", fontUIResource);
        UIManager.put("TableHeader.font", fontUIResource);
        UIManager.put("Panel.font", fontUIResource);
        UIManager.put("List.font", fontUIResource);
        UIManager.put("ColorChooser.font", fontUIResource);
        UIManager.put("PasswordField.font", fontUIResource);
        UIManager.put("TextField.font", fontUIResource);
        UIManager.put("Table.font", fontUIResource);
        UIManager.put("Label.font", fontUIResource);
        UIManager.put("InternalFrameTitlePane.font", fontUIResource);
    }

    public static synchronized Image loadImage(String string) {
        File file = new File(string);
        Image image = null;
        try {
            URL uRL = file.toURL();
            image = Toolbox.loadImage(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Image loadImage(URL uRL) {
        Image image = null;
        image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (image != null) {
            tracker.addImage(image, 0);
            try {
                try {
                    tracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    tracker.removeImage(image);
                    image = null;
                    Object var4_3 = null;
                    if (image != null) {
                        tracker.removeImage(image);
                    }
                    if (tracker.isErrorAny()) {
                        image = null;
                    }
                    if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                        image = null;
                    }
                }
                Object var4_2 = null;
                if (image != null) {
                    tracker.removeImage(image);
                }
                if (tracker.isErrorAny()) {
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    image = null;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (image != null) {
                    tracker.removeImage(image);
                }
                if (tracker.isErrorAny()) {
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    image = null;
                }
                throw throwable;
            }
        }
        return image;
    }

    public static synchronized BufferedImage loadImage(File file, int n) {
        BufferedImage bufferedImage = null;
        try {
            URL uRL = file.toURL();
            bufferedImage = Toolbox.loadImage(uRL, n);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return bufferedImage;
    }

    public static synchronized BufferedImage loadImage(String string, int n) {
        File file = new File(string);
        BufferedImage bufferedImage = null;
        try {
            URL uRL = file.toURL();
            bufferedImage = Toolbox.loadImage(uRL, n);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return bufferedImage;
    }

    public static synchronized BufferedImage loadImage(URL uRL, int n) {
        BufferedImage bufferedImage = null;
        if (uRL == null || !uRL.toString().toLowerCase().endsWith(".jpg")) {
            Image image = Toolbox.loadImage(uRL);
            if (image != null) {
                bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.drawImage(image, 0, 0, null);
                graphics2D.dispose();
            }
        } else {
            BufferedImage bufferedImage2 = Toolbox.loadJPEGImage(uRL);
            if (bufferedImage2 != null) {
                if (bufferedImage2.getType() != n) {
                    bufferedImage = new BufferedImage(bufferedImage2.getWidth(null), bufferedImage2.getHeight(null), n);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
                    graphics2D.dispose();
                } else {
                    bufferedImage = bufferedImage2;
                }
            }
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized BufferedImage loadJPEGImage(URL uRL) {
        BufferedImage bufferedImage;
        block13: {
            block12: {
                bufferedImage = null;
                if (uRL == null) break block13;
                InputStream inputStream = null;
                inputStream = uRL.openStream();
                JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
                bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
                Object var5_5 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block12;
                }
                catch (IOException iOException) {}
                break block12;
                {
                    catch (IOException iOException) {
                        bufferedImage = null;
                        Object var5_6 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block12;
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (bufferedImage != null && (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0)) {
                bufferedImage = null;
            }
        }
        return bufferedImage;
    }

    public static Shape concat(Shape[] shapeArray) {
        GeneralPath generalPath = new GeneralPath();
        int n = shapeArray != null ? shapeArray.length : 0;
        for (int i = 0; i < n; ++i) {
            generalPath.append(shapeArray[i], false);
        }
        return generalPath;
    }

    public static Color makeTransparent(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 1);
    }

    public static void initFonts() {
        if (!fontsLoaded) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            System.out.println("Initializing fonts .... please wait");
            String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
            System.out.println("Done initializing " + stringArray.length + " fonts");
            fontsLoaded = true;
        }
    }
}

