## ----options, include=FALSE, echo=FALSE---------------------------------------
knitr::opts_chunk$set(warning=FALSE, error=FALSE, message=FALSE)

## ---- eval= FALSE-------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE)){
#      install.packages("BiocManager")}
#  BiocManager::install("ExperimentSubset")

## ---- eval = FALSE------------------------------------------------------------
#  library(devtools)
#  install_github("campbio/ExperimentSubset")

## -----------------------------------------------------------------------------
library(ExperimentSubset)

## -----------------------------------------------------------------------------
counts <- matrix(rpois(100, lambda = 10), ncol=10, nrow=10)
sce <- SingleCellExperiment(list(counts = counts))
es <- ExperimentSubset(sce)
es

## -----------------------------------------------------------------------------
es <- createSubset(es, 
                   subsetName = "subset1",
                   rows = c(1:2),
                   cols = c(1:5),
                   parentAssay = "counts")
es

## -----------------------------------------------------------------------------
subset1Assay <- assay(es, "subset1")
subset1Assay[,] <- subset1Assay[,] + 1
es <- storeSubset(es, 
                  subsetName = "subset1", 
                  inputMatrix = subset1Assay, 
                  subsetAssayName = "subset1Assay")
es

## -----------------------------------------------------------------------------
subsetSummary(es)

## -----------------------------------------------------------------------------
counts <- matrix(rpois(100, lambda = 10), ncol=10, nrow=10)
sce <- SingleCellExperiment(list(counts = counts))
es <- ExperimentSubset(sce)
subsetSummary(es)

## -----------------------------------------------------------------------------
es <- createSubset(es, 
                   subsetName = "subset1",
                   rows = c(1:5),
                   cols = c(1:5),
                   parentAssay = "counts")
subsetSummary(es)

## -----------------------------------------------------------------------------
es <- createSubset(es, 
                   subsetName = "subset2",
                   rows = c(1:2),
                   cols = c(1:5),
                   parentAssay = "subset1")
subsetSummary(es)

## -----------------------------------------------------------------------------
subset2Assay <- assay(es, "subset2")
subset2Assay[,] <- subset2Assay[,] + 1

## -----------------------------------------------------------------------------
#approach 1
es <- storeSubset(es, 
                  subsetName = "subset2", 
                  inputMatrix = subset2Assay, 
                  subsetAssayName = "subset2Assay_a1")

#approach 2
assay(es, "subset2", subsetAssayName = "subset2Assay_a2") <- subset2Assay
subsetSummary(es)

## -----------------------------------------------------------------------------
altExp(x = es,
       e = "subset2_alt1",
       subsetName = "subset2") <- SingleCellExperiment(assay = list(
         counts = assay(es, "subset2")
       ))

## -----------------------------------------------------------------------------
subsetSummary(es)

## ---- eval = FALSE------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install(version = "3.11", ask = FALSE)
#  BiocManager::install(c("TENxPBMCData", "scater", "scran"))

## ---- eval = FALSE------------------------------------------------------------
#  library(ExperimentSubset)
#  library(TENxPBMCData)
#  library(scater)
#  library(scran)

## ---- eval = FALSE------------------------------------------------------------
#  tenx_pbmc4k <- TENxPBMCData(dataset = "pbmc4k")
#  es <- ExperimentSubset(tenx_pbmc4k)
#  subsetSummary(es)

## ---- eval = FALSE------------------------------------------------------------
#  perCellQCMetrics <- perCellQCMetrics(assay(es, "counts"))
#  colData(es) <- cbind(colData(es), perCellQCMetrics)

## ---- eval = FALSE------------------------------------------------------------
#  filteredCellsIndices <- which(colData(es)$sum > 1500)
#  es <- createSubset(es, "filteredCells", cols = filteredCellsIndices, parentAssay = "counts")
#  subsetSummary(es)

## ---- eval = FALSE------------------------------------------------------------
#  assay(es, "filteredCells", subsetAssayName = "filteredCellsNormalized") <- normalizeCounts(assay(es, "filteredCells"))
#  subsetSummary(es)

## ---- eval = FALSE------------------------------------------------------------
#  topHVG1000 <- getTopHVGs(modelGeneVar(assay(es, "filteredCellsNormalized")), n = 1000)
#  es <- createSubset(es, "hvg1000", rows = topHVG1000, parentAssay = "filteredCellsNormalized")
#  subsetSummary(es)

## ---- eval = FALSE------------------------------------------------------------
#  reducedDim(es, type = "PCA", subsetName = "hvg1000") <- calculatePCA(assay(es, "hvg1000"))

## ---- eval = FALSE------------------------------------------------------------
#  subsetSummary(es)

## -----------------------------------------------------------------------------
sessionInfo()

