## -----------------------------------------------------------------------------
library(BridgeDbR)

## -----------------------------------------------------------------------------
code = getOrganismCode("Rattus norvegicus")
code

## -----------------------------------------------------------------------------
fullName <- getFullName("Ce")
fullName
code <- getSystemCode("ChEBI")
code

## -----------------------------------------------------------------------------
getMatchingSources("HMDB00555")
getMatchingSources("ENSG00000100030")

## ---- eval=FALSE--------------------------------------------------------------
#  getBridgeNames()

## ---- eval=FALSE--------------------------------------------------------------
#  dbLocation <- getDatabase("Rattus norvegicus",location=getwd())

## ---- eval=FALSE--------------------------------------------------------------
#  getwd()
#  dbLocation <- ("/home/..../BridgeDb/wikidata_diseases.bridge")

## ---- eval=FALSE--------------------------------------------------------------
#  mapper <- loadDatabase(dbLocation)

## ---- eval=FALSE--------------------------------------------------------------
#  location <- getDatabase("Homo sapiens")
#  mapper <- loadDatabase(location)
#  map(mapper, "L", "196410", "X")

## ---- eval=FALSE--------------------------------------------------------------
#  input = data.frame(
#    source= rep("Ch", length(data[,2])),
#    identifer= data[,2]
#  )
#  wikidata = maps(mapper, input, "Wd")

## ---- eval=FALSE--------------------------------------------------------------
#  file <- "metabolites_20180201.bridge"
#  download.file(
#    "https://ndownloader.figshare.com/files/10358973",
#    location
#  )
#  location = normalizePath(file)
#  mapper <- loadDatabase(location)

## ---- eval=FALSE--------------------------------------------------------------
#  map(mapper, "456", source="Cs", target="Ck")

