/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.StringUtil;

public abstract class AuthenticationServiceBase
implements AuthenticationService,
ModuleControl,
ModuleSupportable,
PropertySetCallback {
    protected UserAuthenticator authenticationScheme;
    private AccessFactory store;
    public static final String AuthenticationTrace = null;
    public static final String ID_PATTERN_NEW_SCHEME = "3b60";
    protected static final int SECMEC_USRSSBPWD = 8;
    public static final int MAGICLEN_NEWENCRYPT_SCHEME = 44;

    protected void setAuthenticationService(UserAuthenticator userAuthenticator) {
        this.authenticationScheme = userAuthenticator;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.store = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        PropertyFactory propertyFactory = (PropertyFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        if (propertyFactory != null) {
            propertyFactory.addPropertySetNotification(this);
        }
    }

    public void stop() {
    }

    public boolean authenticate(String string, Properties properties) throws SQLException {
        if (properties == (Properties)null) {
            return false;
        }
        String string2 = properties.getProperty("user");
        if (string2 != null && string2.length() > 30) {
            return false;
        }
        return this.authenticationScheme.authenticateUser(string2, properties.getProperty("password"), string, properties);
    }

    public String getProperty(String string) {
        String string2 = null;
        TransactionController transactionController = null;
        try {
            if (this.store != null) {
                transactionController = this.store.getTransaction(ContextService.getFactory().getCurrentContextManager());
            }
            string2 = PropertyUtil.getServiceProperty(transactionController, string, null);
            if (transactionController != null) {
                transactionController.commit();
                transactionController = null;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return string2;
    }

    public String getDatabaseProperty(String string) {
        String string2 = null;
        TransactionController transactionController = null;
        try {
            if (this.store != null) {
                transactionController = this.store.getTransaction(ContextService.getFactory().getCurrentContextManager());
            }
            string2 = PropertyUtil.getDatabaseProperty(transactionController, string);
            if (transactionController != null) {
                transactionController.commit();
                transactionController = null;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return string2;
    }

    public String getSystemProperty(String string) {
        boolean bl = false;
        bl = Boolean.valueOf(this.getDatabaseProperty("derby.database.propertiesOnly"));
        if (bl) {
            return null;
        }
        return PropertyUtil.getSystemProperty(string);
    }

    public void init(boolean bl, Dictionary dictionary) {
    }

    public boolean validate(String string, Serializable serializable, Dictionary dictionary) {
        return string.startsWith("derby.user.");
    }

    public Serviceable apply(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    public Serializable map(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (!string.startsWith("derby.user.")) {
            return null;
        }
        String string2 = (String)dictionary.get("derby.authentication.provider");
        if (string2 != null && StringUtil.SQLEqualsIgnoreCase(string2, "LDAP")) {
            return null;
        }
        String string3 = (String)((Object)serializable);
        if (string3 != null) {
            string3 = this.encryptPassword(string3);
        }
        return string3;
    }

    protected final boolean requireAuthentication(Properties properties) {
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.connection.requireAuthentication");
        return Boolean.valueOf(string);
    }

    protected String encryptPassword(String string) {
        if (string == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.reset();
        byte[] byArray = null;
        byArray = StringUtil.toHexByte(string, 0, string.length());
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        String string2 = ID_PATTERN_NEW_SCHEME + StringUtil.toHexString(byArray2, 0, byArray2.length);
        return string2;
    }

    protected String substitutePassword(String string, String string2, Properties properties, boolean bl) {
        byte[] byArray;
        MessageDigest messageDigest = null;
        String string3 = ID_PATTERN_NEW_SCHEME;
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.reset();
        byte[] byArray3 = null;
        byte[] byArray4 = StringUtil.toHexByte(string, 0, string.length());
        String string4 = properties.getProperty("drdaSecTokenIn");
        String string5 = properties.getProperty("drdaSecTokenOut");
        byte[] byArray5 = StringUtil.fromHexString(string4, 0, string4.length());
        byte[] byArray6 = StringUtil.fromHexString(string5, 0, string5.length());
        String string6 = null;
        if (!bl) {
            byArray3 = StringUtil.toHexByte(string2, 0, string2.length());
            messageDigest.update(byArray3);
            byArray = messageDigest.digest();
            string6 = string3 + StringUtil.toHexString(byArray, 0, byArray.length);
        } else {
            string6 = string2;
        }
        messageDigest.update(byArray4);
        messageDigest.update(StringUtil.toHexByte(string6, 0, string6.length()));
        byArray = messageDigest.digest();
        messageDigest.update(byArray);
        messageDigest.update(byArray6);
        messageDigest.update(byArray5);
        messageDigest.update(byArray4);
        messageDigest.update(byArray2);
        byte[] byArray7 = messageDigest.digest();
        return StringUtil.toHexString(byArray7, 0, byArray7.length);
    }
}

