### R code from vignette source 'MAGEAndARR.Rnw'

###################################################
### code chunk number 1: setup
###################################################
library(AffyCompatible)


###################################################
### code chunk number 2: arr-examples
###################################################
arrDir <- system.file("extdata", "ARR", package="AffyCompatible")
arrFiles <- list.files(arrDir, pattern=".*ARR", full=TRUE)
basename(arrFiles)


###################################################
### code chunk number 3: readArr
###################################################
arr <- readArr(arrFiles[[1]])
arrs <- sapply(arrFiles, readArr)
arrs[[1]]


###################################################
### code chunk number 4: arr-accessors
###################################################
guid(arr)
version(arr)


###################################################
### code chunk number 5: physicalArrays-accessor
###################################################
physicalArrays(arr)
pas <- physicalArrays(arr)[[1]]
pas


###################################################
### code chunk number 6: physicalArray-accessor
###################################################
physicalArray(pas)[[1]]


###################################################
### code chunk number 7: userAttribute
###################################################
ua <- userAttribute(userAttributes(arr)[[1]])
ua


###################################################
### code chunk number 8: userAttribute-access
###################################################
lapply(ua[1:4], force)
sapply(ua[1:4], name)


###################################################
### code chunk number 9: ARR-readXml
###################################################
xml <- readXml(arrFiles[[1]])


###################################################
### code chunk number 10: xclass-ARR
###################################################
xclass(xml, "/ArraySetFile")
xclass(xml, "/ArraySetFile/UserAttributes/UserAttribute[4]")


###################################################
### code chunk number 11: xclass-abbrev-ARR
###################################################
xclass(xml, "//UserAttribute[4]")
sapply(xclass(xml, "//UserAttribute"), name)[1:4]


###################################################
### code chunk number 12: xpath-query
###################################################
AffyCompatible:::.xreserved()
unlist(xpathApply(xml, "//UserAttribute/@Name", xmlValue))


###################################################
### code chunk number 13: mage-examples
###################################################
mageDir <- system.file("extdata", "DTT", package="AffyCompatible")
mageFiles <- list.files(mageDir, pattern=".*xml", full=TRUE)
basename(mageFiles)


###################################################
### code chunk number 14: readMage
###################################################
mage <- readMage(mageFiles[[1]])
mages <- sapply(mageFiles, readMage)
mages[[1]]


###################################################
### code chunk number 15: mage-accessors
###################################################
ba <- bioAssay_assnlist(bioAssay_package(mage)[[1]])[[1]]
ba
measuredBioAssay(ba)[[1]]


###################################################
### code chunk number 16: mage-readXml
###################################################
xml <- readXml(mageFiles[[1]])
xclass(xml, "//MeasuredBioAssay")[[1]]
sapply(xclass(xml, "//Protocol/*/Parameter"), name)[1:10]
xpathApply(xml, "//MeasuredBioAssay/@name", xmlValue)


###################################################
### code chunk number 17: mage-hardware-xml
###################################################
hq <- "//Hybridization/*/ProtocolApplication/*/HardwareApplication/*/ParameterValue"
hval <- xpathApply(xml, paste(hq, "/@value"), xmlValue)
names(hval) <- xpathApply(xml, paste(hq, "//@identifier"), xmlValue)
hval


###################################################
### code chunk number 18: dtd
###################################################
dtdDir <- system.file("extdata", package="AffyCompatible")
list.files(dtdDir, pattern=".*dtd")


