## ---- echo = FALSE------------------------------------------------------------
library(knitr)

## ---- warning=F, message=F----------------------------------------------------
library(tradeSeq)
library(RColorBrewer)
library(SingleCellExperiment)
library(monocle)
library(dplyr)
library(tidyr)

# For reproducibility
palette(brewer.pal(8, "Dark2"))
data(countMatrix, package = "tradeSeq")
counts <- as.matrix(countMatrix)
rm(countMatrix)
data(celltype, package = "tradeSeq")

## ---- warning=FALSE, out.width="50%", fig.asp=.6------------------------------
set.seed(200)
pd <- data.frame(cells = colnames(counts), cellType = celltype)
rownames(pd) <- pd$cells
fd <- data.frame(gene_short_name = rownames(counts))
rownames(fd) <- fd$gene_short_name
cds <- newCellDataSet(counts, phenoData = new("AnnotatedDataFrame", data = pd),
                      featureData = new("AnnotatedDataFrame", data = fd))
cds <- estimateSizeFactors(cds)
cds <- reduceDimension(cds, max_components = 2)
cds <- orderCells(cds)
cds <- orderCells(cds, root_state = 5)

## -----------------------------------------------------------------------------
sce <- fitGAM(cds, verbose = TRUE)

## ---- eval = FALSE------------------------------------------------------------
#  library(monocle3)
#  # Create a cell_data_set object
#  cds <- new_cell_data_set(counts, cell_metadata = df,
#                  gene_metadata = data.frame(gene_short_name = rownames(counts),
#                                             row.names = rownames(counts)))
#  # Run PCA then UMAP on the data
#  cds <- preprocess_cds(cds, method = "PCA")
#  cds <- reduce_dimension(cds, preprocess_method = "PCA",
#                          reduction_method = "UMAP")
#  # First display, coloring by the cell types from Paul et al
#  plot_cells(cds, label_groups_by_cluster = FALSE, cell_size = 1,
#             color_cells_by = "cellType")
#  
#  # Running the clustering method. This is necessary to the construct the graph
#  cds <- cluster_cells(cds, reduction_method = "UMAP")
#  # Visualize the clusters
#  plot_cells(cds, color_cells_by = "cluster", cell_size = 1)
#  # Construct the graph
#  # Note that, for the rest of the code to run, the graph should be fully connected
#  cds <- learn_graph(cds, use_partition = FALSE)
#  
#  # Find the root of the graph, i.e the node that is closest to the
#  # cell labelled Multipotent progenitors
#  cell_ids <- which(celltype ==  "Multipotent progenitors")
#  closest_vertex <-
#    cds@principal_graph_aux[["UMAP"]]$pr_graph_cell_proj_closest_vertex
#  closest_vertex <- closest_vertex[colnames(cds), 1]
#  closest_vertex <- closest_vertex[cell_ids]
#  closest_vertex <- paste0("Y_", closest_vertex)
#  root <- names(which(igraph::degree(principal_graph(cds)[["UMAP"]]) == 1))
#  root <- root[root %in% closest_vertex]
#  cds <- order_cells(cds, root_pr_nodes = root)
#  plot_cells(cds, color_cells_by = "pseudotime")

## ---- eval = FALSE------------------------------------------------------------
#  y_to_cells <-  principal_graph_aux(cds)$UMAP$pr_graph_cell_proj_closest_vertex %>%
#    as.data.frame() %>%
#    dplyr::mutate(cells = rownames(.)) %>%
#    rename("Y" = V1)
#  mst <- principal_graph(cds)$UMAP
#  endpoints <- names(which(igraph::degree(mst) == 1))
#  endpoints <- endpoints[endpoints != root]
#  cellWeights <- lapply(endpoints, function(endpoint) {
#    path <- igraph::shortest_paths(mst, root, endpoint)$vpath[[1]]
#    path <- as.character(path)
#    df <- y_to_cells %>%
#      dplyr::filter(Y %in% path)
#    df <- data.frame(weights = as.numeric(colnames(cds) %in% df$cells))
#    colnames(df) <- endpoint
#    return(df)
#    }) %>% bind_cols()
#  pseudotime <- sapply(cellWeights, function(w) pseudotime(cds))
#  sce <- fitGAM(counts = counts,
#         pseudotime = pseudotime,
#         cellWeights = cellWeights)

## -----------------------------------------------------------------------------
sessionInfo()

