## -----------------------------------------------------------------------------
set_struct_obj(
  class_name = 'add_two_inputs',
  struct_obj = 'model',
  stato = FALSE,
  params=c(input_1 = 'numeric', input_2 = 'numeric'),
  outputs=c(result = 'numeric'),
  prototype=list(
    input_1 = 0, 
    input_2 = 0,
    name='Add two inputs',
    description='example class that adds two values together',
    predicted='result'
    )
  )

## -----------------------------------------------------------------------------
# show the class definition
show(add_two_inputs)

## -----------------------------------------------------------------------------
set_obj_method(
  class_name = 'add_two_inputs',
  method_name = 'model_apply',
  definition = function(M,D) { # you need to supply D here even if you dont use it
    M$result = M$input_1 + M$input_2
    return(M)                  # remember to always return the input object after modifying it
  }
)

## -----------------------------------------------------------------------------
# create an instance of the model
M = add_two_inputs(input_1 = 3, input_2 = 5)
# use the model
M = model_apply(M,iris_DatasetExperiment())
# check the result = 8
M$result

## -----------------------------------------------------------------------------
show(add_two_inputs())

## -----------------------------------------------------------------------------
# update the show method
set_obj_show(
  class_name = 'add_two_inputs',
  extra_string = function(x) {
    str= paste('This model is currently set to calculate: ',x$input_1,' + ', x$input_2,sep='')
    return(str)
  }
)


## -----------------------------------------------------------------------------
# call the show method
show(M)

