params <-
list(test = FALSE)

## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(BiocStyle)

## ----warning=FALSE, message=FALSE---------------------------------------------
# load required packages
library(spicyR)
library(ggplot2)

## ---- eval = FALSE------------------------------------------------------------
#  if (!require("BiocManager"))
#      install.packages("BiocManager")
#  BiocManager::install("spicyR")

## ----message=FALSE------------------------------------------------------------
data("melanomaResponders")
melanomaResponders
cellSummary(melanomaResponders)
imagePheno(melanomaResponders)

## -----------------------------------------------------------------------------
spicyTestPair <- spicy(melanomaResponders, 
                   condition = "condition", 
                   subject = "subject", 
                   from = "CD8+PD1+PDL1-", 
                   to = "CD8-PD1+PDL1+")
spicyTestPair
topPairs(spicyTestPair)

## ----echo=FALSE, eval=TRUE----------------------------------------------------
data("spicyTest")

## ----eval=FALSE---------------------------------------------------------------
#  spicyTest <- spicy(melanomaResponders,
#                     condition = "condition",
#                     subject = "subject")
#  

## ----echo=FALSE, eval=FALSE---------------------------------------------------
#  save(spicyTest, file = "../data/spicyTest.rda", compress = "xz")

## -----------------------------------------------------------------------------
spicyTest
topPairs(spicyTest)  

## -----------------------------------------------------------------------------
signifPlot(spicyTest, breaks=c(-3, 3, 0.5))

## ----echo=FALSE, eval=TRUE----------------------------------------------------
data(spicyTestBootstrap)

## ----eval=FALSE---------------------------------------------------------------
#  spicyTestBootstrap <- spicy(melanomaResponders,
#                     condition = "condition",
#                     subject = "subject",
#                     nsim = 199)

## ----echo=FALSE, eval=FALSE---------------------------------------------------
#  save(spicyTestBootstrap, file = "../data/spicyTestBootstrap.rda", compress = "xz")

## -----------------------------------------------------------------------------
spicyTestBootstrap

topPairs(spicyTestBootstrap)  

signifPlot(spicyTestBootstrap, breaks=c(-3, 3, 0.5))

## -----------------------------------------------------------------------------
sessionInfo()

