## ----eval=FALSE---------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#    install.packages("BiocManager")
#  BiocManager::version()

## ----eval=FALSE---------------------------------------------------------------
#  BiocManager::install()

## ----eval=FALSE---------------------------------------------------------------
#  BiocManager::valid()

## ----eval=FALSE---------------------------------------------------------------
#  BiocManager::install()

## ----eval=FALSE---------------------------------------------------------------
#  BiocManager::install("singleCellTK")

## ----eval=FALSE---------------------------------------------------------------
#  library(singleCellTK)
#  singleCellTK()

## ----eval=FALSE---------------------------------------------------------------
#  library(singleCellTK)
#  singleCellTK()

## ---- message=FALSE-----------------------------------------------------------
library(singleCellTK)
data("mouseBrainSubsetSCE")
counts_mat <- assay(mouseBrainSubsetSCE, "counts")
sample_annot <- colData(mouseBrainSubsetSCE)
row_annot <- rowData(mouseBrainSubsetSCE)
newSCE <- createSCE(assayFile = counts_mat, annotFile = sample_annot, 
                    featureFile = row_annot, assayName = "counts",
                    inputDataFrames = TRUE, createLogCounts = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  singleCellTK(newSCE)

## ----sessionInfo, echo=FALSE--------------------------------------------------
sessionInfo()

