## ---- include=FALSE-----------------------------------------------------------
library(BiocStyle)

## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("scDblFinder")
#  
#  # or, to get that latest developments:
#  BiocManager::install("plger/scDblFinder")

## -----------------------------------------------------------------------------
# we create a dummy dataset
sce <- scater::mockSCE(ncells=500, ngenes=500)
library(scDblFinder)
sce <- scDblFinder(sce, verbose=FALSE)

## ---- eval=FALSE--------------------------------------------------------------
#  library(BiocParallel)
#  sce <- scDblFinder(sce, samples="sample_id", BPPARAM=MulticoreParam(3))
#  table(sce$scDblFinder.class)

## ----echo=FALSE, fig.cap="Comparison with other tools; note that doubletFinder failed on the mixology10x3cl dataset."----
knitr::include_graphics(system.file('docs', 'scDblFinder_comparison.png', package='scDblFinder'))

