/*
 * Decompiled with CFR 0.152.
 */
package dcw.sarks;

import dcw.sarks.BWT;
import dcw.sarks.SarksUtilities;
import dcw.sarks.SkewSuffixArray;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Sarks {
    private int nThreads;
    private int halfWindow;
    private int spatialLength;
    private double[] scores;
    private String[] transcripts;
    private HashMap<String, Integer> transcriptPosition;
    private String catSeq;
    private int[] bounds;
    private int[] sa;
    private int[] saInv;
    private float[] windGini;
    private float[] spatGini;
    private float[] windowed;
    private float[] spatialWindowed;
    private BWT bwt;

    public Sarks(String string, String string2, int n, int n2, int n3, boolean bl) {
        this.nThreads = n3;
        this.halfWindow = n;
        this.spatialLength = n2;
        HashMap<String, String> hashMap = null;
        TreeMap<String, Double> treeMap = null;
        try {
            hashMap = SarksUtilities.readFasta(string);
            treeMap = SarksUtilities.readScores(string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        treeMap.keySet().retainAll(hashMap.keySet());
        hashMap.keySet().retainAll(treeMap.keySet());
        this.transcripts = new String[treeMap.size()];
        this.transcriptPosition = new HashMap();
        this.scores = new double[treeMap.size()];
        int n4 = 0;
        for (Map.Entry<String, Double> entry : treeMap.entrySet()) {
            this.transcripts[n4] = entry.getKey();
            this.transcriptPosition.put(this.transcripts[n4], n4);
            this.scores[n4] = entry.getValue();
            ++n4;
        }
        this.concatenateSeqs(hashMap);
        this.calcSuffixArray();
        this.bwt = bl ? new BWT(this.catSeq, this.sa) : null;
        this.windowGini();
        this.window();
        if (this.spatialLength > 1) {
            this.spatialGini();
            this.spatialWindow();
        } else {
            this.spatGini = null;
            this.spatialWindowed = null;
        }
    }

    public Sarks(String string, String string2, int n) {
        this(string, string2, n, 0, 1, false);
    }

    public Sarks(Sarks sarks, Integer[] integerArray) {
        this.nThreads = sarks.nThreads;
        this.halfWindow = sarks.halfWindow;
        this.spatialLength = sarks.spatialLength;
        this.transcripts = sarks.transcripts;
        this.transcriptPosition = sarks.transcriptPosition;
        this.scores = new double[sarks.scores.length];
        for (int i = 0; i < this.scores.length; ++i) {
            this.scores[integerArray[i].intValue()] = sarks.scores[i];
        }
        this.catSeq = sarks.catSeq;
        this.bounds = sarks.bounds;
        this.sa = sarks.sa;
        this.saInv = sarks.saInv;
        this.bwt = sarks.bwt;
        this.windGini = sarks.windGini;
        this.spatGini = sarks.spatGini;
        this.window();
        if (this.spatialLength > 1) {
            this.spatialWindow();
        }
    }

    private void concatenateSeqs(HashMap<String, String> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        this.bounds = new int[this.transcripts.length + 1];
        this.bounds[0] = 0;
        int n = 1;
        for (String string : this.transcripts) {
            String string2 = hashMap.get(string);
            stringBuilder.append(string2);
            stringBuilder.append("$");
            this.bounds[n] = this.bounds[n - 1] + string2.length() + 1;
            ++n;
        }
        this.catSeq = stringBuilder.toString();
    }

    private void calcSuffixArray() {
        int n;
        int[] nArray = new int[this.catSeq.length() + 3];
        for (n = this.catSeq.length() - 1; n >= 0; --n) {
            nArray[n] = this.catSeq.charAt(n);
        }
        for (n = this.catSeq.length(); n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        n = SarksUtilities.max(nArray, this.catSeq.length());
        int[] nArray2 = new int[nArray.length];
        SkewSuffixArray.suffixArray(nArray, nArray2, this.catSeq.length(), n);
        this.sa = new int[this.catSeq.length()];
        this.saInv = new int[this.sa.length];
        for (int i = 0; i < this.sa.length; ++i) {
            this.sa[i] = nArray2[i];
            this.saInv[nArray2[i]] = i;
        }
    }

    public void reset(int n, Integer n2, boolean bl) {
        this.halfWindow = n;
        if (n2 != null) {
            this.spatialLength = n2;
        }
        this.windowGini();
        if (bl) {
            this.window();
        } else {
            this.windowed = null;
        }
        if (this.spatialLength > 1) {
            this.spatialGini();
            if (bl) {
                this.spatialWindow();
            } else {
                this.spatialWindowed = null;
            }
        } else {
            this.spatGini = null;
            this.spatialWindowed = null;
        }
    }

    public void reset(int n) {
        this.reset(n, null, true);
    }

    public void resetSpatial(int n, boolean bl) {
        this.spatialLength = n;
        this.spatialWindowed = null;
        if (this.spatialLength > 1) {
            this.spatialGini();
            if (bl) {
                this.spatialWindow();
            }
        } else {
            this.spatGini = null;
        }
    }

    public void resetSpatial(int n) {
        this.resetSpatial(n, true);
    }

    public int sourceBlock(int n, int n2, int n3) {
        if (n3 == n2 + 1) {
            return n2;
        }
        int n4 = (n2 + n3) / 2;
        if (n < this.bounds[n4]) {
            return this.sourceBlock(n, n2, n4);
        }
        return this.sourceBlock(n, n4, n3);
    }

    public int sourceBlock(int n) {
        return this.sourceBlock(n, 0, this.bounds.length);
    }

    public int[] sourceBlock(int[] nArray) {
        if (nArray != null) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = this.sourceBlock(nArray[i]);
            }
            return nArray2;
        }
        int[] nArray3 = new int[this.sa.length];
        for (int i = 0; i < this.transcripts.length; ++i) {
            int n = i + 1;
            for (int j = this.bounds[i]; j < this.bounds[n]; ++j) {
                nArray3[this.saInv[j]] = i;
            }
        }
        return nArray3;
    }

    public double[] sourceScore(int[] nArray) {
        int[] nArray2 = this.sourceBlock(nArray);
        double[] dArray = new double[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            dArray[i] = this.scores[nArray2[i]];
        }
        return dArray;
    }

    public int[] blockCounts(int n, int[] nArray) {
        int n2;
        int n3 = this.transcripts.length;
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = 0;
        }
        for (n2 = -this.halfWindow; n2 <= this.halfWindow; ++n2) {
            int n4 = nArray[n + n2];
            nArray2[n4] = nArray2[n4] + 1;
        }
        return nArray2;
    }

    public static double giniImpurity(int[] nArray) {
        int n;
        double d = 0.0;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            n2 += nArray[n];
        }
        for (n = 0; n < nArray.length; ++n) {
            d += (double)nArray[n] * (double)(n2 - nArray[n]);
        }
        return d /= (double)(n2 * n2);
    }

    private void windowGini() {
        int n;
        int[] nArray = this.sourceBlock(null);
        this.windGini = new float[this.sa.length];
        int[] nArray2 = this.blockCounts(this.halfWindow, nArray);
        double d = Sarks.giniImpurity(nArray2);
        this.windGini[this.halfWindow] = (float)d;
        int n2 = 2 * this.halfWindow + 1;
        double d2 = n2 * n2;
        int n3 = 0;
        for (n = this.halfWindow + 1; n < this.sa.length - this.halfWindow; ++n) {
            int n4 = nArray[n - 1 - this.halfWindow];
            int n5 = nArray[n + this.halfWindow];
            n3 = -nArray2[n4] * (n2 - nArray2[n4]);
            if (nArray2[n5] > 0) {
                n3 -= nArray2[n5] * (n2 - nArray2[n5]);
            }
            int n6 = n4;
            nArray2[n6] = nArray2[n6] - 1;
            int n7 = n5;
            nArray2[n7] = nArray2[n7] + 1;
            if (nArray2[n4] > 0) {
                n3 += nArray2[n4] * (n2 - nArray2[n4]);
            }
            this.windGini[n] = (float)(d += (double)(n3 += nArray2[n5] * (n2 - nArray2[n5])) / d2);
        }
        for (n = 0; n < this.halfWindow; ++n) {
            this.windGini[n] = this.windGini[this.halfWindow];
            this.windGini[this.sa.length - 1 - n] = this.windGini[this.sa.length - 1 - this.halfWindow];
        }
    }

    private void spatialGini() {
        int n;
        double d = this.spatialLength;
        this.spatGini = new float[this.windGini.length];
        double d2 = 0.0;
        for (n = 0; n < this.spatialLength; ++n) {
            d2 += (double)this.windGini[this.saInv[n]];
        }
        this.spatGini[this.saInv[0]] = (float)(d2 /= d);
        for (n = 1; n <= this.sa.length - this.spatialLength; ++n) {
            d2 -= (double)this.windGini[this.saInv[n - 1]] / d;
            this.spatGini[this.saInv[n]] = (float)(d2 += (double)this.windGini[this.saInv[n + this.spatialLength - 1]] / d);
        }
        for (n = this.saInv.length + 1 - this.spatialLength; n < this.sa.length; ++n) {
            this.spatGini[this.saInv[n]] = (float)d2;
        }
    }

    private void window() {
        int n;
        double[] dArray = this.sourceScore(null);
        double d = 2 * this.halfWindow + 1;
        this.windowed = new float[this.sa.length];
        double d2 = 0.0;
        for (n = 0; n < 2 * this.halfWindow + 1; ++n) {
            d2 += dArray[n];
        }
        this.windowed[this.halfWindow] = (float)(d2 /= d);
        for (n = this.halfWindow + 1; n < this.sa.length - this.halfWindow; ++n) {
            d2 -= dArray[n - 1 - this.halfWindow] / d;
            this.windowed[n] = (float)(d2 += dArray[n + this.halfWindow] / d);
        }
        for (n = 0; n < this.halfWindow; ++n) {
            this.windowed[n] = this.windowed[this.halfWindow];
            this.windowed[this.sa.length - 1 - n] = (float)d2;
        }
    }

    private void spatialWindow() {
        int n;
        double d = this.spatialLength;
        this.spatialWindowed = new float[this.sa.length];
        double d2 = 0.0;
        for (n = 0; n < this.spatialLength; ++n) {
            d2 += (double)this.windowed[this.saInv[n]];
        }
        this.spatialWindowed[this.saInv[0]] = (float)(d2 /= d);
        for (n = 1; n <= this.sa.length - this.spatialLength; ++n) {
            d2 -= (double)this.windowed[this.saInv[n - 1]] / d;
            this.spatialWindowed[this.saInv[n]] = (float)(d2 += (double)this.windowed[this.saInv[n + this.spatialLength - 1]] / d);
        }
        for (n = this.sa.length + 1 - this.spatialLength; n < this.sa.length; ++n) {
            this.spatialWindowed[this.saInv[n]] = (float)d2;
        }
    }

    private boolean startGood(int n, String string) {
        String string2;
        int n2 = this.sa[n];
        int n3 = string.length();
        int n4 = n2 + n3;
        if (n4 > this.catSeq.length()) {
            n4 = this.catSeq.length();
        }
        if ((string2 = this.catSeq.substring(n2, n4)).equals(string) && n == 0) {
            return true;
        }
        if (string2.compareTo(string) >= 0) {
            String string3;
            int n5 = this.sa[n - 1];
            int n6 = n5 + n3;
            if (n6 > this.catSeq.length()) {
                n6 = this.catSeq.length();
            }
            if ((string3 = this.catSeq.substring(n5, n6)).compareTo(string) < 0) {
                return true;
            }
        }
        return false;
    }

    private boolean endGood(int n, String string) {
        String string2;
        int n2 = this.sa[n - 1];
        int n3 = string.length();
        int n4 = n2 + n3;
        if (n4 > this.catSeq.length()) {
            n4 = this.catSeq.length();
        }
        if ((string2 = this.catSeq.substring(n2, n4)).equals(string) && n == this.sa.length) {
            return true;
        }
        if (string2.compareTo(string) <= 0) {
            String string3;
            int n5 = this.sa[n];
            int n6 = n5 + n3;
            if (n6 > this.catSeq.length()) {
                n6 = this.catSeq.length();
            }
            if ((string3 = this.catSeq.substring(n5, n6)).compareTo(string) > 0) {
                return true;
            }
        }
        return false;
    }

    public int[] findKmer(String string, int[] nArray) {
        int n;
        if (string.equals("")) {
            return new int[]{0, this.sa.length};
        }
        if (this.bwt != null) {
            return this.bwt.findKmer(string);
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = this.sa.length;
        if (nArray != null) {
            n3 = nArray[0];
            n4 = nArray[1];
        }
        int n5 = n3 + (n4 - n3) / 2;
        String string2 = null;
        while (n5 < n4 && !this.startGood(n5, string)) {
            int n6 = this.sa[n5] + n2;
            if (n6 > this.catSeq.length()) {
                n6 = this.catSeq.length();
            }
            if ((string2 = this.catSeq.substring(this.sa[n5], n6)).compareTo(string) >= 0) {
                n4 = n5;
            } else {
                n3 = n5;
            }
            n = n3 + (n4 - n3) / 2;
            if (n == n5) {
                n5 = n4;
                continue;
            }
            n5 = n;
        }
        n3 = n5;
        n4 = this.sa.length;
        n = n3 + (n4 - n3) / 2;
        while (n > n5 && !this.endGood(n, string)) {
            int n7 = this.sa[n] + n2;
            if (n7 > this.catSeq.length()) {
                n7 = this.catSeq.length();
            }
            string2 = this.catSeq.substring(this.sa[n], n7);
            if (n == this.sa.length) {
                n4 = n;
            } else if (string2.compareTo(string) <= 0) {
                n3 = n;
            } else {
                n4 = n;
            }
            int n8 = n3 + (n4 - n3) / 2;
            if (n8 == n) {
                n = n4;
                continue;
            }
            n = n8;
        }
        return new int[]{n5, n};
    }

    public int[] findKmer(String string) {
        return this.findKmer(string, null);
    }

    public String kmer(int n, int n2, int n3) {
        int n4 = this.catSeq.length() - 1;
        int n5 = n + n3;
        int n6 = n + n2;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 > n4) {
            n5 = n4;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n6 > n4 + 1) {
            n6 = n4 + 1;
        }
        return this.catSeq.substring(n5, n6);
    }

    public String kmer(int n, int n2) {
        return this.kmer(n, n2, 0);
    }

    public String[] kmers(int[] nArray, int n, int n2) {
        String[] stringArray = new String[nArray.length];
        int n3 = this.catSeq.length() - 1;
        for (int i = 0; i < nArray.length; ++i) {
            int n4;
            int n5 = nArray[i] + n2;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n5 > n3) {
                n5 = n3;
            }
            if ((n4 = nArray[i] + n) < 0) {
                n4 = 0;
            }
            if (n4 > n3 + 1) {
                n4 = n3 + 1;
            }
            stringArray[i] = this.catSeq.substring(n5, n4);
        }
        return stringArray;
    }

    public String[] kmers(int[] nArray, int n) {
        return this.kmers(nArray, n, 0);
    }

    public double prefixAgreeSum(int n, int n2) {
        String string = this.kmers(new int[]{this.sa[n]}, n2)[0];
        int n3 = 0;
        int n4 = n - this.halfWindow;
        int n5 = n + this.halfWindow + 1;
        int n6 = n;
        int n7 = n + 1;
        if (n2 > string.length()) {
            n2 = string.length();
        }
        for (int i = n2; i > 0; --i) {
            int[] nArray = this.findKmer(string.substring(0, i));
            if (nArray[0] < n4) {
                nArray[0] = n4;
            }
            if (nArray[1] > n5) {
                nArray[1] = n5;
            }
            n3 += i * (n6 - nArray[0] + (nArray[1] - n7));
            n6 = nArray[0];
            n7 = nArray[1];
        }
        return (double)n3 / (2.0 * (double)this.halfWindow);
    }

    public ArrayList<Integer> filter(Float f, Double d, Float f2, Double d2, Boolean bl) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (d != null) {
            if (d >= 1.0) {
                d = 1.0 - (double)(1.0f - SarksUtilities.median(this.windGini)) * d;
            }
        } else {
            d = 0.0;
        }
        if (f == null) {
            f = Float.valueOf(Float.NEGATIVE_INFINITY);
        }
        if (d2 != null) {
            if (d2 >= 1.0) {
                d2 = 1.0 - (double)(1.0f - SarksUtilities.median(this.windGini)) * d2;
            }
        } else {
            d2 = 0.0;
        }
        if (bl == null) {
            bl = false;
        }
        for (int i = 0; i < this.sa.length; ++i) {
            if (!(this.windowed[i] >= f.floatValue()) || !((double)this.windGini[i] >= d)) continue;
            boolean bl2 = true;
            int n = this.sa[i];
            if (f2 != null && (this.spatialWindowed[i] < f2.floatValue() || (double)this.spatGini[i] < d2)) {
                bl2 = false;
            }
            if (bl2 && bl.booleanValue()) {
                int n2 = this.saInv[0];
                if (n > 0) {
                    n2 = this.saInv[n - 1];
                }
                int n3 = this.saInv[this.saInv.length - 1];
                if (n < this.saInv.length - 1) {
                    n3 = this.saInv[n + 1];
                }
                if (this.windowed[n2] > this.windowed[i] || this.windowed[n3] > this.windowed[i]) {
                    bl2 = false;
                }
            }
            if (!bl2) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    public ArrayList<Integer> filter(Float f, Double d, Boolean bl) {
        return this.filter(f, d, null, null, bl);
    }

    public ArrayList<Integer> filter(Float f, Double d) {
        return this.filter(f, d, null);
    }

    public ArrayList<ArrayList<Integer>> filter(ArrayList<HashMap> arrayList, Float[][] floatArray, Boolean bl) {
        int n = this.halfWindow;
        int n2 = this.spatialLength;
        ArrayList<ArrayList<Integer>> arrayList2 = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < arrayList.size(); ++i) {
            HashMap hashMap = arrayList.get(i);
            Integer n3 = (Integer)hashMap.get("halfWindow");
            Double d = (Double)hashMap.get("minGini");
            Integer n4 = (Integer)hashMap.get("spatialLength");
            Double d2 = (Double)hashMap.get("minSpatialGini");
            Float f = null;
            Float f2 = null;
            if (floatArray != null) {
                f = floatArray[i][0];
                f2 = floatArray[i][1];
            } else {
                f = (Float)hashMap.get("theta");
                f2 = (Float)hashMap.get("spatialTheta");
            }
            if (n3 != null && n3 != this.halfWindow) {
                this.reset(n3, n4, true);
            } else if (n4 != null && n4 != this.spatialLength) {
                this.resetSpatial(n4, true);
            }
            arrayList2.add(this.filter(f, d, f2, d2, bl));
        }
        if (this.halfWindow != n) {
            this.reset(n, n2, true);
        } else if (this.spatialLength != n2) {
            this.resetSpatial(n2, true);
        }
        return arrayList2;
    }

    public ArrayList<ArrayList<Integer>> filter(ArrayList<HashMap> arrayList, Float[][] floatArray) {
        return this.filter(arrayList, floatArray, null);
    }

    public ArrayList<ArrayList<Integer>> filter(ArrayList<HashMap> arrayList, Boolean bl) {
        return this.filter(arrayList, (Float[][])null, bl);
    }

    public ArrayList<ArrayList<Integer>> filter(ArrayList<HashMap> arrayList) {
        return this.filter(arrayList, (Float[][])null, null);
    }

    private boolean[] giniMask(Double d, Double d2) {
        int n;
        if (d != null && d >= 1.0) {
            d = 1.0 - (double)(1.0f - SarksUtilities.median(this.windGini)) * d;
        }
        if (d2 != null && d2 >= 1.0) {
            d2 = 1.0 - (double)(1.0f - SarksUtilities.median(this.windGini)) * d2;
        }
        boolean[] blArray = new boolean[this.windGini.length];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        if (d != null) {
            for (n = 0; n < blArray.length; ++n) {
                if (!((double)this.windGini[n] < d)) continue;
                blArray[n] = true;
            }
        }
        if (d2 != null && this.spatGini != null) {
            for (n = 0; n < blArray.length; ++n) {
                if (!((double)this.spatGini[n] < d2)) continue;
                blArray[n] = true;
            }
        }
        return blArray;
    }

    public ArrayList<Float[][]> permutationDistribution(Integer n, ArrayList<HashMap> arrayList, Long l, Integer[][] integerArray) {
        int n2;
        if (integerArray == null) {
            integerArray = SarksUtilities.generatePermutations(n, this.scores.length, l);
        }
        Integer[][][] integerArray2 = SarksUtilities.partitionPermutations(integerArray, this.nThreads);
        int n3 = this.halfWindow;
        int n4 = this.spatialLength;
        this.windowed = null;
        this.spatialWindowed = null;
        ArrayList<Float[][]> arrayList2 = new ArrayList<Float[][]>();
        for (n2 = 0; n2 < integerArray.length; ++n2) {
            arrayList2.add(new Float[arrayList.size()][2]);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            Float[][] floatArray;
            HashMap hashMap = arrayList.get(n2);
            Integer n5 = (Integer)hashMap.get("halfWindow");
            Double d = (Double)hashMap.get("minGini");
            Integer n6 = (Integer)hashMap.get("spatialLength");
            Double d2 = (Double)hashMap.get("minSpatialGini");
            if (n5 != null && n5 != this.halfWindow) {
                this.reset(n5, n6, false);
            } else if (n6 != null && n6 != this.spatialLength) {
                this.resetSpatial(n6, false);
            }
            boolean[] blArray = this.giniMask(d, d2);
            ArrayList<Future<Float[][]>> arrayList3 = new ArrayList<Future<Float[][]>>();
            ExecutorService executorService = Executors.newFixedThreadPool(this.nThreads);
            for (int i = 0; i < integerArray2.length; ++i) {
                floatArray = new SarksPermuter(this, integerArray2[i], blArray);
                Future<Float[][]> future = executorService.submit(floatArray);
                arrayList3.add(future);
            }
            ArrayList<Float[][]> arrayList4 = new ArrayList<Float[][]>();
            for (int i = 0; i < integerArray2.length; ++i) {
                try {
                    arrayList4.add((Float[][])((Future)arrayList3.get(i)).get());
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            executorService.shutdown();
            floatArray = SarksUtilities.mergeMaxResults(arrayList4);
            for (int i = 0; i < integerArray.length; ++i) {
                arrayList2.get((int)i)[n2][0] = floatArray[i][0];
                arrayList2.get((int)i)[n2][1] = floatArray[i][1];
            }
        }
        this.reset(n3, n4, true);
        return arrayList2;
    }

    public ArrayList<Float[][]> permutationDistribution(Integer n, ArrayList<HashMap> arrayList, Long l) {
        return this.permutationDistribution(n, arrayList, l, null);
    }

    public ArrayList<Float[][]> permutationDistribution(Integer n, ArrayList<HashMap> arrayList, int n2) {
        return this.permutationDistribution(n, arrayList, Long.valueOf(n2), null);
    }

    public ArrayList<Float[][]> permutationDistribution(Integer n, ArrayList<HashMap> arrayList) {
        return this.permutationDistribution(n, arrayList, null, null);
    }

    public static String printPermDist(ArrayList<HashMap> arrayList, ArrayList<Float[][]> arrayList2, String string, boolean bl) throws Exception {
        String string2 = "halfWindow\tminGini\tspatialLength\tminSpatialGini\trep\tmax\n";
        BufferedWriter bufferedWriter = null;
        StringBuilder stringBuilder = null;
        if (string != null) {
            if (!string.endsWith("/")) {
                string = string + "_";
            }
            String string3 = string + "windowed.tsv";
            bufferedWriter = new BufferedWriter(new FileWriter(string3));
            bufferedWriter.write(string2);
        } else {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
        }
        int n = bl ? 1 : 0;
        for (int i = 0; i < arrayList2.get(0).length; ++i) {
            HashMap hashMap = arrayList.get(i);
            String string4 = "" + (Integer)hashMap.get("halfWindow");
            String string5 = "" + (Double)hashMap.get("minGini");
            String string6 = "" + (Integer)hashMap.get("spatialLength");
            String string7 = "" + (Double)hashMap.get("minSpatialGini");
            String string8 = string4 + "\t" + string5 + "\t" + string6 + "\t" + string7 + "\t";
            for (int j = 0; j < arrayList2.size(); ++j) {
                String string9 = string8 + j + "\t" + arrayList2.get(j)[i][n] + "\n";
                if (string != null) {
                    bufferedWriter.write(string9);
                    continue;
                }
                stringBuilder.append(string9);
            }
        }
        if (string == null) {
            return stringBuilder.toString();
        }
        bufferedWriter.close();
        return null;
    }

    public static void printPermDists(ArrayList<HashMap> arrayList, ArrayList<Float[][]> arrayList2, String string) throws Exception {
        Sarks.printPermDist(arrayList, arrayList2, string, false);
        Sarks.printPermDist(arrayList, arrayList2, string + "_spatial", true);
    }

    public static String printThresholds(ArrayList<HashMap> arrayList, Float[][] floatArray, String string) throws Exception {
        String string2 = "halfWindow\tminGini\tspatialLength\tminSpatialGini\t";
        string2 = string2 + "theta\tspatialTheta\n";
        BufferedWriter bufferedWriter = null;
        StringBuilder stringBuilder = null;
        if (string != null) {
            if (!string.endsWith("/")) {
                string = string + "_";
            }
            String string3 = string + "theta.tsv";
            bufferedWriter = new BufferedWriter(new FileWriter(string3));
            bufferedWriter.write(string2);
        } else {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
        }
        for (int i = 0; i < floatArray.length; ++i) {
            HashMap hashMap = arrayList.get(i);
            String string4 = "" + (Integer)hashMap.get("halfWindow");
            String string5 = "" + (Double)hashMap.get("minGini");
            String string6 = "" + (Integer)hashMap.get("spatialLength");
            String string7 = "" + (Double)hashMap.get("minSpatialGini");
            String string8 = string4 + "\t" + string5 + "\t" + string6 + "\t" + string7 + "\t";
            String string9 = string8 + floatArray[i][0] + "\t" + floatArray[i][1] + "\n";
            if (string != null) {
                bufferedWriter.write(string9);
                continue;
            }
            stringBuilder.append(string9);
        }
        if (string == null) {
            return stringBuilder.toString();
        }
        bufferedWriter.close();
        return null;
    }

    public String printPeaks(ArrayList<HashMap> arrayList, Float[][] floatArray, ArrayList<ArrayList<Integer>> arrayList2, String string, int n) throws Exception {
        String string2 = "i\ts\tkmer\tkhat\tblock\twi\tgini\tspatialGini\tscore\twindowed\tspatialWindowed\tkmax\thalfWindow\tminGini\ttheta\tspatialLength\tminSpatialGini\tspatialTheta\n";
        BufferedWriter bufferedWriter = null;
        StringBuilder stringBuilder = null;
        if (string != null) {
            if (!string.endsWith("/")) {
                string = string + "_";
            }
            String string3 = string + "peaks.tsv";
            bufferedWriter = new BufferedWriter(new FileWriter(string3));
            bufferedWriter.write(string2);
        } else {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
        }
        int n2 = this.halfWindow;
        int n3 = this.spatialLength;
        for (int i = 0; i < floatArray.length; ++i) {
            HashMap hashMap = arrayList.get(i);
            Integer n4 = (Integer)hashMap.get("halfWindow");
            String string4 = "" + (Double)hashMap.get("minGini");
            Integer n5 = (Integer)hashMap.get("spatialLength");
            String string5 = "" + (Double)hashMap.get("minSpatialGini");
            String string6 = n + "\t" + n4 + "\t" + string4 + "\t" + floatArray[i][0] + "\t" + n5 + "\t" + string5 + "\t" + floatArray[i][1] + "\n";
            if (n4 != null && n4 != this.halfWindow) {
                this.reset(n4, n5, true);
            } else if (n5 != null && n5 != this.spatialLength) {
                this.resetSpatial(n5, true);
            }
            for (int j = 0; j < arrayList2.get(i).size(); ++j) {
                int n6 = arrayList2.get(i).get(j);
                int n7 = this.sa[n6];
                String string7 = this.kmer(n7, n);
                float f = (float)this.prefixAgreeSum(n6, n);
                string7 = string7.substring(0, Math.round(f));
                int n8 = this.sourceBlock(n7);
                String string8 = this.transcripts[n8];
                int n9 = n7 - this.bounds[n8];
                float f2 = this.windGini[n6];
                Float f3 = this.spatGini == null ? null : Float.valueOf(this.spatGini[n6]);
                float f4 = (float)this.scores[n8];
                Float f5 = this.spatialWindowed == null ? null : Float.valueOf(this.spatialWindowed[n6]);
                String string9 = n6 + "\t" + n7 + "\t" + string7 + "\t" + f + "\t" + string8 + "\t" + n9 + "\t" + f2 + "\t" + f3 + "\t" + f4 + "\t" + this.windowed[n6] + "\t" + f5 + "\t" + string6;
                if (string != null) {
                    bufferedWriter.write(string9);
                    continue;
                }
                stringBuilder.append(string9);
            }
        }
        this.reset(n2, n3, true);
        if (string == null) {
            return stringBuilder.toString();
        }
        bufferedWriter.close();
        return null;
    }

    public String printPeaks(ArrayList<HashMap> arrayList, Float[][] floatArray, ArrayList<ArrayList<Integer>> arrayList2, int n) throws Exception {
        return this.printPeaks(arrayList, floatArray, arrayList2, null, n);
    }

    public String printBlockInfo(ArrayList<HashMap> arrayList, Float[][] floatArray, String string, String string2, int n) throws Exception {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = this.transcriptPosition.get(string);
        for (int i = this.bounds[n2]; i < this.bounds[n2 + 1]; ++i) {
            arrayList2.add(this.saInv[i]);
        }
        ArrayList<ArrayList<Integer>> arrayList3 = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList3.add(arrayList2);
        }
        return this.printPeaks(arrayList, floatArray, arrayList3, string2, n);
    }

    public ArrayList<Integer> spatialSubPeaks(ArrayList<Integer> arrayList, Float f, Double d) {
        int n;
        if (this.spatialLength <= 1) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int n2 : arrayList) {
                arrayList2.add(this.sa[n2]);
            }
            return arrayList2;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            int n3 = object.next();
            for (int i = n = this.sa[n3]; i < n + this.spatialLength; ++i) {
                treeSet.add(i);
            }
        }
        object = new HashSet();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            if (f != null && this.windowed[this.saInv[n]] < f.floatValue()) {
                ((HashSet)object).add(n);
                continue;
            }
            if (treeSet.contains(n - 1) || !(this.windowed[this.saInv[n - 1]] >= f.floatValue())) continue;
            ((HashSet)object).add(n);
        }
        treeSet.removeAll((Collection<?>)object);
        return new ArrayList<Integer>(treeSet);
    }

    public ArrayList<int[]> mergeKmerIntervals(ArrayList<Integer> arrayList, int n) {
        Collections.sort(arrayList);
        int n2 = -1;
        int n3 = -1;
        int n4 = -2;
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        for (int i = 0; i < arrayList.size(); ++i) {
            int n5 = arrayList.get(i);
            int n6 = Math.round((float)this.prefixAgreeSum(this.saInv[n5], n));
            if (n5 - 1 == n4) {
                n3 = Math.max(n3, n5 + n6);
            } else {
                if (n2 >= 0) {
                    arrayList2.add(new int[]{n2, n3});
                }
                n2 = n5;
                n3 = n5 + n6;
                if (n3 > this.catSeq.length()) {
                    n3 = this.catSeq.length();
                }
            }
            n4 = n5;
        }
        if (n2 >= 0) {
            arrayList2.add(new int[]{n2, n3});
        }
        return arrayList2;
    }

    public ArrayList<ArrayList<int[]>> multiMergeKmerIntervals(ArrayList<ArrayList<Integer>> arrayList, Float[][] floatArray, ArrayList<HashMap> arrayList2, int n) {
        ArrayList<ArrayList<Integer>> arrayList3 = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<int[]>> arrayList4 = new ArrayList<ArrayList<int[]>>();
        int n2 = this.halfWindow;
        int n3 = this.spatialLength;
        for (int i = 0; i < arrayList.size(); ++i) {
            HashMap hashMap = arrayList2.get(i);
            Integer n4 = (Integer)hashMap.get("halfWindow");
            Double d = (Double)hashMap.get("minGini");
            Integer n5 = (Integer)hashMap.get("spatialLength");
            if (n4 != null && n4 != this.halfWindow) {
                this.reset(n4, n5, true);
            } else if (n5 != null && n5 != this.spatialLength) {
                this.resetSpatial(n5, true);
            }
            arrayList3.add(this.spatialSubPeaks(arrayList.get(i), floatArray[i][1], d));
            arrayList4.add(this.mergeKmerIntervals((ArrayList)arrayList3.get(i), n));
        }
        this.reset(n2, n3, true);
        return arrayList4;
    }

    public String[] mergedKmers(ArrayList<int[]> arrayList) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int[] nArray : arrayList) {
            treeSet.add(this.catSeq.substring(nArray[0], nArray[1]));
        }
        String[] stringArray = new String[treeSet.size()];
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n] = string = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    public ArrayList<String[]> mergedKmers_(ArrayList<ArrayList<int[]>> arrayList) {
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList2.add(this.mergedKmers(arrayList.get(i)));
        }
        return arrayList2;
    }

    public String printMergedSubPeaks(ArrayList<HashMap> arrayList, Float[][] floatArray, ArrayList<ArrayList<int[]>> arrayList2, String string, int n) throws Exception {
        String string2 = "i\ts\tkmer\tkhat\tblock\twi\tgini\tspatialGini\tscore\twindowed\tspatialWindowed\tkmax\thalfWindow\tminGini\ttheta\tspatialLength\tminSpatialGini\tspatialTheta\n";
        BufferedWriter bufferedWriter = null;
        StringBuilder stringBuilder = null;
        if (string != null) {
            if (!string.endsWith("/")) {
                string = string + "_";
            }
            String string3 = string + "merged_peaks.tsv";
            bufferedWriter = new BufferedWriter(new FileWriter(string3));
            bufferedWriter.write(string2);
        } else {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
        }
        int n2 = this.halfWindow;
        int n3 = this.spatialLength;
        for (int i = 0; i < floatArray.length; ++i) {
            HashMap hashMap = arrayList.get(i);
            Integer n4 = (Integer)hashMap.get("halfWindow");
            String string4 = "" + (Double)hashMap.get("minGini");
            Integer n5 = (Integer)hashMap.get("spatialLength");
            String string5 = "" + (Double)hashMap.get("minSpatialGini");
            String string6 = n + "\t" + n4 + "\t" + string4 + "\t" + floatArray[i][0] + "\t" + n5 + "\t" + string5 + "\t" + floatArray[i][1] + "\n";
            if (n4 != null && n4 != this.halfWindow) {
                this.reset(n4, n5, true);
            } else if (n5 != null && n5 != this.spatialLength) {
                this.resetSpatial(n5, true);
            }
            for (int j = 0; j < arrayList2.get(i).size(); ++j) {
                int[] nArray = arrayList2.get(i).get(j);
                int n6 = this.saInv[nArray[0]];
                String string7 = this.catSeq.substring(nArray[0], nArray[1]);
                float f = (float)this.prefixAgreeSum(n6, n);
                int n7 = this.sourceBlock(nArray[0]);
                String string8 = this.transcripts[n7];
                int n8 = nArray[0] - this.bounds[n7];
                float f2 = this.windGini[n6];
                Float f3 = this.spatGini == null ? null : Float.valueOf(this.spatGini[n6]);
                float f4 = (float)this.scores[n7];
                Float f5 = this.spatialWindowed == null ? null : Float.valueOf(this.spatialWindowed[n6]);
                String string9 = n6 + "\t" + nArray[0] + "\t" + string7 + "\t" + f + "\t" + string8 + "\t" + n8 + "\t" + f2 + "\t" + f3 + "\t" + f4 + "\t" + this.windowed[n6] + "\t" + f5 + "\t" + string6;
                if (string != null) {
                    bufferedWriter.write(string9);
                    continue;
                }
                stringBuilder.append(string9);
            }
        }
        this.reset(n2, n3, true);
        if (string == null) {
            return stringBuilder.toString();
        }
        bufferedWriter.close();
        return null;
    }

    public String printMergedSubPeaks(ArrayList<HashMap> arrayList, Float[][] floatArray, ArrayList<ArrayList<int[]>> arrayList2, int n) throws Exception {
        return this.printMergedSubPeaks(arrayList, floatArray, arrayList2, null, n);
    }

    public int getHalfWindow() {
        return this.halfWindow;
    }

    public int getSpatialLength() {
        return this.spatialLength;
    }

    public String getCatSeq() {
        return this.catSeq;
    }

    public int[] getBounds() {
        return this.bounds;
    }

    public double[] getScores() {
        return this.scores;
    }

    public String[] getTranscripts() {
        return this.transcripts;
    }

    public HashMap<String, Integer> getTranscriptPosition() {
        return this.transcriptPosition;
    }

    public int[] getSuffixArray() {
        return this.sa;
    }

    public int[] getInverseSuffixArray() {
        return this.saInv;
    }

    public float[] getGini() {
        return this.windGini;
    }

    public float[] getSpatialGini() {
        return this.spatGini;
    }

    public float[] getYhat() {
        return this.windowed;
    }

    public float[] getYdoubleHat() {
        return this.spatialWindowed;
    }

    public int s2i(int n) {
        return this.saInv[n];
    }

    public int i2s(int n) {
        return this.sa[n];
    }

    public static class SarksPermuter
    implements Callable<Float[][]> {
        private Sarks base;
        private Integer[][] permutations;
        private boolean[] mask;

        public SarksPermuter(Sarks sarks, Integer[][] integerArray, boolean[] blArray) {
            this.base = sarks;
            this.permutations = integerArray;
            this.mask = blArray;
        }

        @Override
        public Float[][] call() {
            Float[][] floatArray = new Float[this.permutations.length][2];
            for (int i = 0; i < this.permutations.length; ++i) {
                Sarks sarks = new Sarks(this.base, this.permutations[i]);
                floatArray[i][0] = SarksUtilities.max(sarks.windowed, this.mask);
                floatArray[i][1] = SarksUtilities.max(sarks.spatialWindowed, this.mask);
            }
            return floatArray;
        }
    }
}

